/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.internal.ControlThemer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class TreeThemer
extends ControlThemer {
    private TreeViewer fTreeViewer;
    private IPropertyChangeListener fontListener;
    private Listener measureItemListener;
    private Listener customDrawingListener;
    private Listener selectionPaintListener;

    public TreeThemer(TreeViewer treeViewer) {
        super((Control)treeViewer.getTree());
        this.fTreeViewer = treeViewer;
    }

    public TreeThemer(Tree tree) {
        super((Control)tree);
    }

    @Override
    public void apply() {
        super.apply();
        this.addSelectionColorOverride();
        this.addCustomTreeControlDrawing();
        this.addMeasureItemListener();
        this.addFontListener();
    }

    @Override
    protected void applyTheme() {
        super.applyTheme();
        if (this.fTreeViewer != null && !this.controlIsDisposed()) {
            this.fTreeViewer.refresh(true);
        }
    }

    @Override
    protected void addSelectionColorOverride() {
        if (this.controlIsDisposed()) {
            return;
        }
        super.addSelectionColorOverride();
        final Tree tree = this.getTree();
        this.selectionPaintListener = new Listener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleEvent(Event event) {
                if (!TreeThemer.this.invasiveThemesEnabled()) {
                    return;
                }
                GC gc = event.gc;
                Color oldBackground = gc.getBackground();
                try {
                    TreeItem[] items;
                    CellEditor[] editors;
                    Rectangle clientArea = tree.getClientArea();
                    if (!isWindows && !isMacOSX) {
                        gc.setBackground(TreeThemer.this.getBackground());
                        Rectangle itemBounds = new Rectangle(0, 0, 0, 0);
                        if (tree.getItemCount() != 0) {
                            TreeItem lastItem = tree.getItem(tree.getItemCount() - 1);
                            lastItem = TreeThemer.this.getLastItemRecursively(lastItem);
                            itemBounds = lastItem.getBounds();
                        }
                        int bottomY = itemBounds.y + itemBounds.height;
                        Rectangle toColor = new Rectangle(clientArea.x, bottomY, clientArea.width + 2, clientArea.height - bottomY);
                        gc.fillRectangle(toColor);
                    }
                    if (!isWindows) {
                        return;
                    }
                    if (TreeThemer.this.fTreeViewer != null && (editors = TreeThemer.this.fTreeViewer.getCellEditors()) != null) {
                        CellEditor[] cellEditorArray = editors;
                        int n = editors.length;
                        int toColor = 0;
                        while (toColor < n) {
                            Control c;
                            CellEditor editor = cellEditorArray[toColor];
                            if (editor != null && (c = editor.getControl()) != null) {
                                c.setForeground(TreeThemer.this.getForeground());
                            }
                            ++toColor;
                        }
                    }
                    if ((items = tree.getSelection()) == null || items.length == 0) {
                        if (tree.getData("LBUTTONDOWN") == null) return;
                        Display display = tree.getDisplay();
                        TreeItem item = tree.getItem(display.map(null, (Control)tree, display.getCursorLocation()));
                        if (item == null) return;
                        items = new TreeItem[]{item};
                    }
                    try {
                        gc.setBackground(TreeThemer.this.getSelection());
                        int clientWidth = clientArea.width + 2;
                        int columns = tree.getColumnCount();
                        TreeItem[] treeItemArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item != null) {
                                Rectangle bounds = columns == 0 ? item.getBounds() : item.getBounds(columns - 1);
                                int x = bounds.x + bounds.width;
                                if (x < clientWidth) {
                                    gc.fillRectangle(x, bounds.y, clientWidth - x, bounds.height);
                                }
                            }
                            ++n2;
                        }
                        return;
                    }
                    catch (Exception exception) {}
                    return;
                }
                finally {
                    gc.setBackground(oldBackground);
                    gc.setForeground(TreeThemer.this.getForeground());
                }
            }
        };
        tree.addListener(9, this.selectionPaintListener);
    }

    protected TreeItem getLastItemRecursively(TreeItem lastItem) {
        if (lastItem == null) {
            return null;
        }
        int itemCount = lastItem.getItemCount();
        if (itemCount == 0 || !lastItem.getExpanded()) {
            return lastItem;
        }
        return this.getLastItemRecursively(lastItem.getItem(itemCount - 1));
    }

    private void addCustomTreeControlDrawing() {
        if (isMacOSX || isUbuntu || this.controlIsDisposed()) {
            return;
        }
        Tree tree = this.getTree();
        this.customDrawingListener = new Listener(){

            public void handleEvent(Event event) {
                if (!TreeThemer.this.invasiveThemesEnabled()) {
                    return;
                }
                GC gc = event.gc;
                Widget item = event.item;
                boolean isExpanded = false;
                boolean draw = false;
                if (item instanceof TreeItem) {
                    TreeItem tItem = (TreeItem)item;
                    isExpanded = tItem.getExpanded();
                    boolean bl = draw = tItem.getItemCount() > 0;
                }
                if (!draw) {
                    return;
                }
                int x = event.x - 16;
                int y = event.y + 4;
                Color oldBackground = gc.getBackground();
                gc.setBackground(TreeThemer.this.getBackground());
                gc.fillRectangle(x, y, 11, 11);
                gc.setBackground(TreeThemer.this.getForeground());
                gc.setAlpha(195);
                gc.drawRectangle(x + 1, y + 1, 8, 8);
                gc.setAlpha(255);
                int halfWidth = 5;
                gc.drawLine(x + 3, y + halfWidth, x + 7, y + halfWidth);
                if (!isExpanded) {
                    gc.drawLine(x + halfWidth, y + 3, x + halfWidth, y + 7);
                }
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFF7;
            }
        };
        tree.addListener(42, this.customDrawingListener);
    }

    private void addMeasureItemListener() {
        if (this.controlIsDisposed()) {
            return;
        }
        Tree tree = this.getTree();
        this.measureItemListener = new Listener(){

            public void handleEvent(Event event) {
                if (!TreeThemer.this.useEditorFont()) {
                    return;
                }
                Font font = JFaceResources.getFont((String)"com.aptana.explorer.font");
                if (font == null) {
                    font = JFaceResources.getTextFont();
                }
                if (font != null) {
                    event.gc.setFont(font);
                    FontMetrics metrics = event.gc.getFontMetrics();
                    int height = metrics.getHeight() + 2;
                    TreeItem item = (TreeItem)event.item;
                    int width = event.gc.stringExtent((String)item.getText()).x + 24;
                    event.height = height;
                    if (width > event.width) {
                        event.width = width;
                    }
                }
            }
        };
        tree.addListener(41, this.measureItemListener);
    }

    private void addFontListener() {
        if (this.controlIsDisposed()) {
            return;
        }
        final Tree tree = this.getTree();
        this.fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!event.getProperty().equals("com.aptana.explorer.font") || !TreeThemer.this.useEditorFont()) {
                    return;
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Font font = TreeThemer.this.getFont();
                        if (font != null && !tree.isDisposed()) {
                            tree.setFont(font);
                            GC gc = new GC((Drawable)Display.getDefault());
                            gc.setFont(font);
                            FontMetrics metrics = gc.getFontMetrics();
                            int height = metrics.getHeight() + 2;
                            gc.dispose();
                            if (isWindows) {
                                try {
                                    Method m = Tree.class.getDeclaredMethod("setItemHeight", Integer.TYPE);
                                    if (m != null) {
                                        m.setAccessible(true);
                                        m.invoke((Object)tree, height);
                                    }
                                }
                                catch (Exception e) {
                                    IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                                }
                            } else if (isMacOSX && isCocoa) {
                                try {
                                    Method m;
                                    Object widget;
                                    Field f = Control.class.getField("view");
                                    if (f != null && (widget = f.get(tree)) != null && (m = widget.getClass().getMethod("setRowHeight", Double.TYPE)) != null) {
                                        m.invoke(widget, height);
                                    }
                                }
                                catch (Exception e) {
                                    IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                                }
                            }
                        }
                        if (TreeThemer.this.fTreeViewer != null) {
                            TreeThemer.this.fTreeViewer.refresh();
                        }
                        tree.redraw();
                        tree.update();
                    }
                });
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fontListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeSelectionOverride();
        this.removeCustomTreeControlDrawing();
        this.removeMeasureItemListener();
        this.removeFontListener();
    }

    private void removeCustomTreeControlDrawing() {
        if (this.customDrawingListener != null && !this.controlIsDisposed()) {
            this.getTree().removeListener(42, this.customDrawingListener);
        }
        this.customDrawingListener = null;
    }

    @Override
    protected void removeSelectionOverride() {
        super.removeSelectionOverride();
        if (this.selectionPaintListener != null && !this.controlIsDisposed()) {
            this.getTree().removeListener(9, this.selectionPaintListener);
        }
        this.selectionPaintListener = null;
    }

    private void removeMeasureItemListener() {
        if (this.measureItemListener != null && !this.controlIsDisposed()) {
            this.getTree().removeListener(41, this.measureItemListener);
        }
        this.measureItemListener = null;
    }

    protected Tree getTree() {
        return (Tree)this.getControl();
    }

    private void removeFontListener() {
        if (this.fontListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fontListener);
        }
        this.fontListener = null;
    }
}

