/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.theme.IThemeChangeListener;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.ThemeRule;
import com.aptana.theme.internal.Messages;
import com.aptana.theme.internal.OrderedProperties;
import com.aptana.ui.util.UIUtils;
import com.pandora.core.stats.Stats;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ThemeManager
implements IThemeManager {
    public static final String THEMES_NODE = "themes";
    private volatile Theme fCurrentTheme;
    private Set<String> fBuiltins;
    private Set<String> fThemeNames;
    private static Set<String> checkedVersionThemeNames = new HashSet<String>();
    private static ThemeManager fgInstance;
    public static List<IThemeChangeListener> changeListeners;
    private static final String[] annotationKeyPrefixes;

    static {
        changeListeners = new ArrayList<IThemeChangeListener>();
        annotationKeyPrefixes = new String[]{"pydevOccurrenceIndication", "searchResultIndication", "xmlTagPairOccurrenceIndication", "htmlTagPairOccurrenceIndication", "rubyBlockPairOccurrenceIndication"};
    }

    private ThemeManager() {
        EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors").addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String[] stringArray = annotationKeyPrefixes;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String prefix = stringArray[n2];
                    if (event.getKey().startsWith(prefix)) {
                        final String scopeSelector = "override." + prefix;
                        if (event.getNewValue() == null && event.getKey().endsWith("Color")) {
                            UIJob job = new UIJob("Restoring overrides of Annotation"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    ThemeRule rule = ThemeManager.this.getCurrentTheme().getRuleForSelector((IScopeSelector)new ScopeSelector(scopeSelector));
                                    if (rule != null) {
                                        ThemeManager.this.getCurrentTheme().remove(rule);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            EclipseUtil.setSystemForJob((Job)job);
                            job.setPriority(50);
                            job.schedule();
                            break;
                        }
                        if (ThemeManager.this.getCurrentTheme().hasEntry(scopeSelector)) break;
                        int index = ThemeManager.this.getCurrentTheme().getTokens().size();
                        ThemeManager.this.getCurrentTheme().addNewRule(index, "Annotation Override - " + prefix, new ScopeSelector(scopeSelector), null);
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    public static synchronized ThemeManager instance() {
        if (fgInstance == null) {
            fgInstance = new ThemeManager();
        }
        return fgInstance;
    }

    private TextAttribute getTextAttribute(String name) {
        if (this.getCurrentTheme() != null) {
            return this.getCurrentTheme().getTextAttribute(name);
        }
        return new TextAttribute(ThemePlugin.getDefault().getColorManager().getColor(new RGB(255, 255, 255)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Theme getCurrentTheme() {
        if (this.fCurrentTheme == null) {
            ThemeManager themeManager = this;
            synchronized (themeManager) {
                String activeThemeName = Platform.getPreferencesService().getString("com.aptana.theme", "ACTIVE_THEME", "\u7eff\u67d4-\u9971\u6ee1", null);
                if (activeThemeName != null) {
                    this.fCurrentTheme = this.getTheme(activeThemeName);
                }
                if (this.fCurrentTheme == null && !this.getThemeNames().isEmpty()) {
                    this.fCurrentTheme = this.getTheme(this.getThemeNames().iterator().next());
                }
                if (this.fCurrentTheme != null) {
                    this.setCurrentTheme(this.fCurrentTheme);
                }
            }
        }
        return this.fCurrentTheme;
    }

    @Override
    public void setCurrentTheme(Theme theme) {
        this.fCurrentTheme = theme;
        this.setSearchResultColor(theme);
        this.setAnnotationColorsToMatchTheme(theme);
        this.setAptanaEditorColorsToMatchTheme(theme);
        this.setCompareColors("com.aptana.editor.common", true);
        this.setCompareColors("org.eclipse.ui.editors", ThemePlugin.applyToAllEditors());
        this.setTabColor(theme);
        UIUtils.runInUIThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ThemeManager.this.notifyThemeChangeListeners(ThemeManager.this.fCurrentTheme);
            }
        });
        this.forceFontsUpToDate();
        Stats.addOperateInfo((String)"theme", (String)"TS", (String)(String.valueOf(theme.getName()) + "|" + theme.getGray()));
    }

    private void setTabColor(Theme theme) {
        RGB bg_rgb = theme.getTabcolor();
        String backRGB = ThemeManager.toString(bg_rgb);
        if ("Monokai".equals(theme.getName())) {
            backRGB = ThemeManager.toString(theme.getBackground());
        } else if ("Monokai Dark".equals(theme.getName())) {
            backRGB = ThemeManager.toString(theme.getBackground());
        }
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", backRGB);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END", backRGB);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_START", backRGB);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_END", backRGB);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START", backRGB);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END", backRGB);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR", ThemeManager.toString(theme.getForeground()));
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR", ThemeManager.toString(theme.getForeground()));
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_TEXT_COLOR", ThemeManager.toString(theme.getForeground()));
    }

    private void setCompareColors(String nodeName, boolean override) {
        IEclipsePreferences instancePrefs = EclipseUtil.instanceScope().getNode(nodeName);
        if (override) {
            RGB bg = this.getCurrentTheme().getBackground();
            RGB inverted = new RGB(255 - bg.red, 255 - bg.green, 255 - bg.blue);
            JFaceResources.getColorRegistry().put("INCOMING_COLOR", inverted);
            JFaceResources.getColorRegistry().put("OUTGOING_COLOR", inverted);
            instancePrefs.put("INCOMING_COLOR", StringConverter.asString((RGB)inverted));
            instancePrefs.put("OUTGOING_COLOR", StringConverter.asString((RGB)inverted));
        } else {
            RGB rgb;
            IEclipsePreferences defPrefs = EclipseUtil.defaultScope().getNode(nodeName);
            String value = defPrefs.get("OUTGOING_COLOR", null);
            if (value != null) {
                try {
                    rgb = StringConverter.asRGB((String)value);
                    if (rgb != null) {
                        JFaceResources.getColorRegistry().put("OUTGOING_COLOR", rgb);
                    }
                }
                catch (DataFormatException dataFormatException) {}
            }
            if ((value = defPrefs.get("INCOMING_COLOR", null)) != null) {
                try {
                    rgb = StringConverter.asRGB((String)value);
                    if (rgb != null) {
                        JFaceResources.getColorRegistry().put("INCOMING_COLOR", rgb);
                    }
                }
                catch (DataFormatException dataFormatException) {}
            }
            instancePrefs.remove("INCOMING_COLOR");
            instancePrefs.remove("OUTGOING_COLOR");
        }
        try {
            instancePrefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setSearchResultColor(Theme theme) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.search");
        prefs.put("org.eclipse.search.potentialMatch.fgColor", ThemeManager.toString(theme.getSearchResultColor()));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void forceFontsUpToDate() {
        final String[] fontIds = new String[]{"com.aptana.explorer.font", "org.eclipse.jface.textfont", "org.eclipse.ui.workbench.texteditor.blockSelectionModeFont"};
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = fontIds;
                int n = fontIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String fdString;
                    String fontId = stringArray[n2];
                    Font fFont = JFaceResources.getFontRegistry().get(fontId);
                    Font existing = JFaceResources.getFont((String)fontId);
                    String existingString = "";
                    if (!existing.isDisposed()) {
                        existingString = PreferenceConverter.getStoredRepresentation((FontData[])existing.getFontData());
                    }
                    if (!existingString.equals(fdString = PreferenceConverter.getStoredRepresentation((FontData[])fFont.getFontData()))) {
                        JFaceResources.getFontRegistry().put(fontId, fFont.getFontData());
                    }
                    ++n2;
                }
            }
        });
    }

    private void notifyThemeChangeListeners(Theme theme) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.theme");
        prefs.put("ACTIVE_THEME", theme.getName());
        prefs.putLong("THEME_CHANGED", System.currentTimeMillis());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setAptanaEditorColorsToMatchTheme(Theme theme) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.editor.common");
        prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", false);
        prefs.put("AbstractTextEditor.Color.SelectionForeground", ThemeManager.toString(theme.getForeground()));
        prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", false);
        prefs.put("AbstractTextEditor.Color.Background", ThemeManager.toString(theme.getBackground()));
        prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", false);
        prefs.put("AbstractTextEditor.Color.Foreground", ThemeManager.toString(theme.getForeground()));
        prefs.put("currentLineColor", ThemeManager.toString(theme.getLineHighlightAgainstBG()));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private void setAnnotationColorsToMatchTheme(Theme theme) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors");
        boolean isReseted = prefs.getBoolean("tagPairOccurrenceIndicationTextStyleHasReseted", false);
        if (!theme.hasEntry("override.searchResultIndication")) {
            prefs.put("searchResultIndicationColor", ThemeManager.toString(theme.getSearchResultColor()));
        }
        if (!theme.hasEntry("override.xmlTagPairOccurrenceIndication") || !isReseted) {
            prefs.putBoolean("xmlTagPairOccurrenceIndicationHighlighting", false);
            prefs.putBoolean("xmlTagPairOccurrenceIndication", true);
            prefs.put("xmlTagPairOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
            prefs.put("xmlTagPairOccurrenceIndicationTextStyle", "DASHED_BOX");
        }
        if (!theme.hasEntry("override.htmlTagPairOccurrenceIndication") || !isReseted) {
            prefs.putBoolean("htmlTagPairOccurrenceIndicationHighlighting", false);
            prefs.putBoolean("htmlTagPairOccurrenceIndication", true);
            prefs.put("htmlTagPairOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
            prefs.put("htmlTagPairOccurrenceIndicationTextStyle", "DASHED_BOX");
        }
        if (!theme.hasEntry("override.rubyBlockPairOccurrenceIndication") || !isReseted) {
            prefs.putBoolean("rubyBlockPairOccurrenceIndicationHighlighting", false);
            prefs.putBoolean("rubyBlockPairOccurrenceIndication", true);
            prefs.put("rubyBlockPairOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
            prefs.put("rubyBlockPairOccurrenceIndicationTextStyle", "DASHED_BOX");
        }
        prefs.put("HBuilder.linked.slave.color", ThemeManager.toString(theme.getSelectionAgainstBG()));
        prefs.put("HBuilder.linked.exit.color", ThemeManager.toString(theme.getCaret()));
        if (!isReseted) {
            prefs.putBoolean("tagPairOccurrenceIndicationTextStyleHasReseted", true);
        }
        if (Platform.getPreferencesService().getBoolean("org.python.pydev.red_core", "PYDEV_USE_APTANA_THEMES", true, null) && !theme.hasEntry("override.pydevOccurrenceIndication")) {
            MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
            AnnotationPreference pydevOccurPref = null;
            for (Object obj : preferences.getAnnotationPreferences()) {
                AnnotationPreference pref = (AnnotationPreference)obj;
                Object type = pref.getAnnotationType();
                if (!"com.python.pydev.occurrences".equals(type)) continue;
                pydevOccurPref = pref;
            }
            if (pydevOccurPref != null) {
                if (pydevOccurPref.getTextStylePreferenceKey() != null) {
                    prefs.putBoolean("pydevOccurrenceHighlighting", false);
                    prefs.putBoolean("pydevOccurrenceIndication", true);
                    prefs.put("pydevOccurrenceIndicationColor", ThemeManager.toString(theme.getOccurenceHighlightColor()));
                    prefs.put("pydevOccurrenceIndicationTextStyle", "BOX");
                } else {
                    prefs.putBoolean("pydevOccurrenceHighlighting", true);
                    prefs.putBoolean("pydevOccurrenceIndication", true);
                    prefs.put("pydevOccurrenceIndicationColor", ThemeManager.toString(theme.getSearchResultColor()));
                }
            }
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private static String toString(RGB selection) {
        return StringConverter.asString((RGB)selection);
    }

    @Override
    public Theme getTheme(String name) {
        Theme loaded = null;
        try {
            loaded = this.loadUserTheme(name);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (String)MessageFormat.format("Failed to load theme {0} from preferences.", name), (Throwable)e);
        }
        if (loaded != null && checkedVersionThemeNames.contains(name)) {
            return loaded;
        }
        try {
            Theme theme = this.loadBuiltinTheme(name);
            if (loaded != null) {
                if (!checkedVersionThemeNames.contains(name)) {
                    checkedVersionThemeNames.add(name);
                    if (theme != null && theme.getVersion() > loaded.getVersion()) {
                        return theme;
                    }
                }
            } else {
                return theme;
            }
            return loaded;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (String)MessageFormat.format("Failed to load theme {0} from builtins.", name), (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized Set<String> getThemeNames() {
        if (this.fThemeNames == null) {
            IScopeContext[] scopes;
            this.fThemeNames = new HashSet<String>();
            this.fThemeNames.addAll(this.getBuiltinThemeNames());
            IScopeContext[] iScopeContextArray = scopes = new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()};
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                IScopeContext scope = iScopeContextArray[n2];
                IEclipsePreferences prefs = scope.getNode("com.aptana.theme");
                Preferences preferences = prefs.node(THEMES_NODE);
                try {
                    String[] themeNames = preferences.keys();
                    this.fThemeNames.addAll(Arrays.asList(themeNames));
                }
                catch (BackingStoreException e) {
                    IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                }
                ++n2;
            }
        }
        return this.fThemeNames;
    }

    /*
     * Exception decompiling
     */
    private Theme loadUserTheme(String themeName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private OrderedProperties getBuiltinThemeProperties(String themeName) {
        Collection<URL> urls = this.getBuiltinThemeURLs();
        if (CollectionsUtil.isEmpty(urls)) {
            return null;
        }
        for (URL url : urls) {
            try {
                OrderedProperties props;
                InputStream stream;
                block19: {
                    OrderedProperties orderedProperties;
                    String loadedName;
                    block18: {
                        stream = FileLocator.toFileURL((URL)url).openStream();
                        props = new OrderedProperties();
                        props.load(stream);
                        loadedName = props.getProperty("name");
                        if (themeName.equals(loadedName)) break block18;
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    try {
                        String[] pieces;
                        String multipleThemeExtends = props.getProperty("extends_theme");
                        if (multipleThemeExtends == null) break block19;
                        OrderedProperties newProperties = new OrderedProperties();
                        String[] stringArray = pieces = multipleThemeExtends.split(",");
                        int n = pieces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String themeExtends = stringArray[n2];
                            OrderedProperties extended = this.getBuiltinThemeProperties(themeExtends);
                            if (extended == null) {
                                throw new IllegalStateException(MessageFormat.format(Messages.ThemeManager_ERR_NoThemeFound, themeExtends, loadedName));
                            }
                            newProperties.putAll((Map<?, ?>)extended);
                            ++n2;
                        }
                        newProperties.putAll((Map<?, ?>)props);
                        newProperties.remove("extends_theme");
                        Assert.isTrue((boolean)newProperties.get("name").equals(themeName));
                        orderedProperties = newProperties;
                    }
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    return orderedProperties;
                }
                OrderedProperties orderedProperties = props;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                return orderedProperties;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (String)url.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private synchronized Set<String> getBuiltinThemeNames() {
        if (this.fBuiltins == null) {
            this.fBuiltins = new HashSet<String>();
            Collection<URL> urls = this.getBuiltinThemeURLs();
            if (urls == null || urls.isEmpty()) {
                return this.fBuiltins;
            }
            for (URL url : urls) {
                InputStream stream = null;
                try {
                    try {
                        stream = FileLocator.toFileURL((URL)url).openStream();
                        OrderedProperties props = new OrderedProperties();
                        props.load(stream);
                        String loadedName = props.getProperty("name");
                        if (loadedName != null && !loadedName.startsWith("abstract_theme")) {
                            this.fBuiltins.add(loadedName);
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                        try {
                            if (stream == null) continue;
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream == null) continue;
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.fBuiltins;
    }

    private Collection<URL> getBuiltinThemeURLs() {
        ThemePlugin themePlugin = ThemePlugin.getDefault();
        if (themePlugin == null) {
            return Collections.emptyList();
        }
        Bundle bundle = themePlugin.getBundle();
        if (bundle == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> collection = new ArrayList<URL>();
        Enumeration enumeration = bundle.findEntries(THEMES_NODE, "*.properties", false);
        while (enumeration.hasMoreElements()) {
            collection.add((URL)enumeration.nextElement());
        }
        collection.trimToSize();
        return collection;
    }

    public Theme loadBuiltinTheme(String themeName) {
        OrderedProperties properties = this.getBuiltinThemeProperties(themeName);
        if (properties == null) {
            return null;
        }
        return this.loadBuiltinTheme(properties);
    }

    private Theme loadBuiltinTheme(Properties props) {
        try {
            return new Theme(ThemePlugin.getDefault().getColorManager(), props);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    @Override
    public IToken getToken(String scope) {
        return new Token((Object)this.getTextAttribute(scope));
    }

    @Override
    public void addTheme(Theme newTheme) {
        newTheme.save(false);
        this.getThemeNames().add(newTheme.getName());
    }

    @Override
    public void removeTheme(Theme theme) {
        Theme activeTheme = this.getCurrentTheme();
        this.getThemeNames().remove(theme.getName());
        if (activeTheme.getName().equals(theme.getName())) {
            this.setCurrentTheme(this.getTheme(this.getThemeNames().iterator().next()));
        }
    }

    @Override
    public boolean isBuiltinTheme(String themeName) {
        return this.getBuiltinThemeNames().contains(themeName);
    }

    @Override
    public IStatus validateThemeName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return new Status(4, "com.aptana.theme", Messages.ThemeManager_NameNonEmptyMsg);
        }
        if (this.getThemeNames().contains(name.trim())) {
            return new Status(4, "com.aptana.theme", Messages.ThemeManager_NameAlreadyExistsMsg);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void addThemeChangeListener(IThemeChangeListener themeChangeListener) {
        if (!changeListeners.contains(themeChangeListener)) {
            changeListeners.add(themeChangeListener);
        }
    }

    @Override
    public void postChangeEvent(Theme theme, Font font) {
        for (IThemeChangeListener themeChangeListener : changeListeners) {
            if (themeChangeListener == null) continue;
            if (theme != null) {
                themeChangeListener.themeChanged(theme);
            }
            if (font == null) continue;
            themeChangeListener.fontChanged(font);
        }
    }

    @Override
    public void removeThemeChangeListener(IThemeChangeListener themeChangeListener) {
        if (changeListeners.contains(themeChangeListener)) {
            changeListeners.remove(themeChangeListener);
        }
    }
}

