/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.theme.IControlThemer;
import com.aptana.theme.IControlThemerFactory;
import com.aptana.theme.internal.AlphaBlendThemer;
import com.aptana.theme.internal.ControlThemer;
import com.aptana.theme.internal.StyledFontThemer;
import com.aptana.theme.internal.TableThemer;
import com.aptana.theme.internal.TextViewerThemer;
import com.aptana.theme.internal.TreeThemer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class ControlThemerFactory
implements IControlThemerFactory {
    private Map<Control, IControlThemer> themers = new HashMap<Control, IControlThemer>();

    @Override
    public void apply(Control control) {
        this.apply(control, null);
    }

    @Override
    public void apply(Control control, Color defaultBg) {
        this.apply(control, 0, -1, defaultBg);
    }

    @Override
    public void applyWithFontStyle(Control control, int fontStyle) {
        this.applyWithAlpha(control, fontStyle, null);
    }

    @Override
    public void applyWithFontStyle(Control control, int fontStyle, Color defaultBg) {
        this.apply(control, fontStyle, -1, defaultBg);
    }

    @Override
    public void applyWithAlpha(Control control, int alpha) {
        this.applyWithAlpha(control, alpha, null);
    }

    @Override
    public void applyWithAlpha(Control control, int alpha, Color defaultBg) {
        this.apply(control, 0, alpha, defaultBg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(Control control, int fontStyle, int alpha, Color defaultBg) {
        IControlThemer themer = this.themers.get(control);
        if (themer != null) {
            return;
        }
        themer = this.createThemer(control, fontStyle, alpha, defaultBg);
        Map<Control, IControlThemer> map = this.themers;
        synchronized (map) {
            this.themers.put(control, themer);
        }
        themer.apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(Control control) {
        IControlThemer themer = null;
        Map<Control, IControlThemer> map = this.themers;
        synchronized (map) {
            themer = this.themers.remove(control);
        }
        if (themer != null) {
            themer.dispose();
        }
    }

    private IControlThemer createThemer(Control control, int fontStyle, int alpha, Color defaultBg) {
        if (control instanceof Tree) {
            return new TreeThemer((Tree)control);
        }
        if (control instanceof Table) {
            return new TableThemer((Table)control);
        }
        if (fontStyle != 0) {
            return new StyledFontThemer(control, fontStyle, defaultBg);
        }
        if (alpha > -1) {
            return new AlphaBlendThemer(control, alpha, defaultBg);
        }
        return new ControlThemer(control, defaultBg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<Control, IControlThemer> map = this.themers;
        synchronized (map) {
            for (Control control : new ArrayList<Control>(this.themers.keySet())) {
                this.dispose(control);
            }
            this.themers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Viewer viewer) {
        Map<Control, IControlThemer> map;
        IControlThemer themer;
        if (viewer instanceof TreeViewer) {
            themer = this.themers.get(viewer.getControl());
            if (themer != null) {
                return;
            }
            themer = new TreeThemer((TreeViewer)viewer);
            map = this.themers;
            synchronized (map) {
                this.themers.put(viewer.getControl(), themer);
            }
            themer.apply();
        }
        if (viewer instanceof TextViewer) {
            themer = this.themers.get(viewer.getControl());
            if (themer != null) {
                return;
            }
            themer = new TextViewerThemer((ITextViewer)((TextViewer)viewer));
            map = this.themers;
            synchronized (map) {
                this.themers.put(viewer.getControl(), themer);
            }
            themer.apply();
        } else {
            this.apply(viewer.getControl());
        }
    }

    @Override
    public void dispose(Viewer viewer) {
        if (viewer != null) {
            this.dispose(viewer.getControl());
        } else {
            this.dispose();
        }
    }
}

