/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.theme.IThemeManager;
import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ThemedDelegatingLabelProvider
implements ILabelProvider,
IColorProvider,
IFontProvider {
    private ILabelProvider wrapped;
    private boolean disabled;

    public ThemedDelegatingLabelProvider(ILabelProvider wrapped) {
        this.wrapped = wrapped;
    }

    public void disable() {
        this.disabled = true;
    }

    public Image getImage(Object element) {
        return this.wrapped.getImage(element);
    }

    public String getText(Object element) {
        return this.wrapped.getText(element);
    }

    public Color getForeground(Object element) {
        if (this.disabled || !this.invasiveThemesEnabled()) {
            if (this.wrapped instanceof IColorProvider) {
                return ((IColorProvider)this.wrapped).getForeground(element);
            }
            return null;
        }
        return this.getThemeManager().getCurrentTheme().getForegroundColor();
    }

    protected boolean invasiveThemesEnabled() {
        return this.getThemeManager().getCurrentTheme().isInvasive();
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        if (this.disabled) {
            if (this.wrapped instanceof IFontProvider) {
                return ((IFontProvider)this.wrapped).getFont(element);
            }
            return null;
        }
        if (!this.useEditorFont()) {
            return null;
        }
        Font font = JFaceResources.getFont((String)"com.aptana.explorer.font");
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        return font;
    }

    protected boolean useEditorFont() {
        return Platform.getPreferencesService().getBoolean("com.aptana.theme", "enable_invasive_font", false, null);
    }

    public void addListener(ILabelProviderListener listener) {
        this.wrapped.addListener(listener);
    }

    public void dispose() {
        this.wrapped.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.wrapped.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.wrapped.removeListener(listener);
    }

    public void enable() {
        this.disabled = false;
    }
}

