/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.theme.DelayedTextAttribute;
import com.aptana.theme.RGBa;
import java.text.MessageFormat;

public class ThemeRule {
    private static final ScopeSelector EMPTY_SCOPE = new ScopeSelector("");
    private IScopeSelector fSelector;
    private String fName;
    private DelayedTextAttribute fTextAttribute;

    ThemeRule(String name, IScopeSelector selector, DelayedTextAttribute attr) {
        this.fSelector = selector;
        this.fName = name;
        this.fTextAttribute = attr;
    }

    public IScopeSelector getScopeSelector() {
        if (this.fSelector == null) {
            return EMPTY_SCOPE;
        }
        return this.fSelector;
    }

    public DelayedTextAttribute getTextAttribute() {
        if (this.fTextAttribute == null) {
            return new DelayedTextAttribute(null);
        }
        return this.fTextAttribute;
    }

    public String getName() {
        return this.fName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ThemeRule)) {
            return false;
        }
        ThemeRule other = (ThemeRule)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getScopeSelector().equals(other.getScopeSelector())) {
            return false;
        }
        return this.getTextAttribute().equals(other.getTextAttribute());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return MessageFormat.format("name: {0}; scope: {1}; style: {2}", this.getName(), this.getScopeSelector(), this.getTextAttribute());
    }

    public boolean isSeparator() {
        IScopeSelector scopeSelector = this.getScopeSelector();
        if (scopeSelector.equals(EMPTY_SCOPE)) {
            return true;
        }
        return "dont.match".equals(scopeSelector.toString());
    }

    public ThemeRule setName(String newName) {
        return new ThemeRule(newName, this.getScopeSelector(), this.getTextAttribute());
    }

    public ThemeRule setTextAttribute(RGBa fg, RGBa bg, int style) {
        return new ThemeRule(this.getName(), this.getScopeSelector(), new DelayedTextAttribute(fg, bg, style));
    }

    public ThemeRule updateFontStyle(int style) {
        return this.setTextAttribute(this.getTextAttribute().foreground, this.getTextAttribute().background, style);
    }

    public ThemeRule updateFG(RGBa fg) {
        return this.setTextAttribute(fg, this.getTextAttribute().background, this.getTextAttribute().style);
    }

    public ThemeRule updateBG(RGBa bg) {
        return this.setTextAttribute(this.getTextAttribute().foreground, bg, this.getTextAttribute().style);
    }

    public ThemeRule setScopeSelector(ScopeSelector scopeSelector) {
        return new ThemeRule(this.getName(), (IScopeSelector)scopeSelector, this.getTextAttribute());
    }
}

