/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.core.util.EclipseUtil;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IControlThemerFactory;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.internal.ControlThemerFactory;
import com.aptana.theme.internal.InvasiveThemeHijacker;
import com.aptana.theme.internal.ThemeManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ThemePlugin
extends AbstractUIPlugin {
    public static final String IBEAM_BLACK = "/icons/ibeam-black.gif";
    public static final String IBEAM_WHITE = "/icons/ibeam-white.gif";
    private boolean hasInitApplyTheme = false;
    public static final String PLUGIN_ID = "com.aptana.theme";
    private static ThemePlugin plugin;
    private InvasiveThemeHijacker themeHijacker;
    private ColorManager fColorManager;
    private IControlThemerFactory fControlThemerFactory;
    private Boolean fApplyThemeToAllViews;
    private Boolean fApplyThemeToAllEditors;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private IEclipsePreferences.IPreferenceChangeListener fEclipseColorsListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ("enable_invasive_themes".equals(event.getKey())) {
                    ThemePlugin.this.fApplyThemeToAllViews = Platform.getPreferencesService().getBoolean(ThemePlugin.PLUGIN_ID, "enable_invasive_themes", false, null);
                } else if ("apply_to_all_editors".equals(event.getKey())) {
                    ThemePlugin.this.fApplyThemeToAllEditors = Platform.getPreferencesService().getBoolean(ThemePlugin.PLUGIN_ID, "apply_to_all_editors", false, null);
                }
            }
        };
        EclipseUtil.instanceScope().getNode(PLUGIN_ID).addPreferenceChangeListener(this.fThemeChangeListener);
        this.fApplyThemeToAllViews = Platform.getPreferencesService().getBoolean(PLUGIN_ID, "enable_invasive_themes", false, null);
        this.fApplyThemeToAllEditors = Platform.getPreferencesService().getBoolean(PLUGIN_ID, "apply_to_all_editors", false, null);
        this.themeHijacker = new InvasiveThemeHijacker();
        this.fEclipseColorsListener = new EditorColorSyncher();
        EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors").addPreferenceChangeListener(this.fEclipseColorsListener);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fThemeChangeListener != null) {
                EclipseUtil.instanceScope().getNode(PLUGIN_ID).removePreferenceChangeListener(this.fThemeChangeListener);
                this.fThemeChangeListener = null;
            }
            if (this.fEclipseColorsListener != null) {
                EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors").removePreferenceChangeListener(this.fEclipseColorsListener);
                this.fEclipseColorsListener = null;
            }
            if (this.themeHijacker != null) {
                this.themeHijacker.dispose();
            }
            if (this.fColorManager != null) {
                this.fColorManager.dispose();
            }
            if (this.fControlThemerFactory != null) {
                this.fControlThemerFactory.dispose();
            }
        }
        finally {
            this.themeHijacker = null;
            this.fColorManager = null;
            this.fControlThemerFactory = null;
            plugin = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(IBEAM_BLACK, ThemePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)IBEAM_BLACK));
        reg.put(IBEAM_WHITE, ThemePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)IBEAM_WHITE));
    }

    public static ThemePlugin getDefault() {
        return plugin;
    }

    public synchronized ColorManager getColorManager() {
        if (this.fColorManager == null) {
            this.fColorManager = new ColorManager();
        }
        return this.fColorManager;
    }

    public IThemeManager getThemeManager() {
        return ThemeManager.instance();
    }

    public synchronized IControlThemerFactory getControlThemerFactory() {
        if (this.fControlThemerFactory == null) {
            this.fControlThemerFactory = new ControlThemerFactory();
        }
        return this.fControlThemerFactory;
    }

    public static synchronized boolean applyToViews() {
        return ThemePlugin.getDefault().fApplyThemeToAllViews;
    }

    public static synchronized boolean applyToAllEditors() {
        return ThemePlugin.getDefault().fApplyThemeToAllEditors;
    }

    public void initApplyTeme() {
        if (!this.hasInitApplyTheme) {
            this.hasInitApplyTheme = true;
            this.themeHijacker.initApplyTeme();
        }
    }

    private final class EditorColorSyncher
    implements IEclipsePreferences.IPreferenceChangeListener {
        private EditorColorSyncher() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            RGB existing;
            RGB value;
            String newValue;
            if (!ThemePlugin.applyToAllEditors()) {
                return;
            }
            if ("AbstractTextEditor.Color.Foreground".equals(event.getKey())) {
                RGB existing2;
                RGB value2;
                String newValue2 = (String)event.getNewValue();
                if (newValue2 != null && !(value2 = StringConverter.asRGB((String)newValue2)).equals((Object)(existing2 = this.getCurrentTheme().getForeground()))) {
                    this.getCurrentTheme().updateFG(value2);
                }
            } else if ("AbstractTextEditor.Color.Background".equals(event.getKey())) {
                RGB existing3;
                RGB value3;
                String newValue3 = (String)event.getNewValue();
                if (newValue3 != null && !(value3 = StringConverter.asRGB((String)newValue3)).equals((Object)(existing3 = this.getCurrentTheme().getBackground()))) {
                    this.getCurrentTheme().updateBG(value3);
                }
            } else if ("AbstractTextEditor.Color.SelectionBackground".equals(event.getKey())) {
                RGB existing4;
                RGB value4;
                String newValue4 = (String)event.getNewValue();
                if (newValue4 != null && !(value4 = StringConverter.asRGB((String)newValue4)).equals((Object)(existing4 = this.getCurrentTheme().getSelectionAgainstBG()))) {
                    this.getCurrentTheme().updateSelection(value4);
                }
            } else if ("currentLineColor".equals(event.getKey()) && (newValue = (String)event.getNewValue()) != null && !(value = StringConverter.asRGB((String)newValue)).equals((Object)(existing = this.getCurrentTheme().getLineHighlightAgainstBG()))) {
                this.getCurrentTheme().updateLineHighlight(value);
            }
        }

        protected Theme getCurrentTheme() {
            return ThemePlugin.this.getThemeManager().getCurrentTheme();
        }
    }
}

