/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp.actions;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.pandora.core.utils.RegistryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardMenu
extends BaseNewWizardMenu {
    private static Map<String, String> quickAccessMenus = new HashMap<String, String>();
    private boolean enabled = true;

    public NewWizardMenu(IWorkbenchWindow window) {
        this(window, null);
        this.initialQuickAccessMenus();
    }

    protected void initialQuickAccessMenus() {
        if (!quickAccessMenus.isEmpty()) {
            return;
        }
        List elements = RegistryUtils.getEp((String)"com.pandora.ui.quickAccess", (String)"bind");
        for (IConfigurationElement el : elements) {
            String bindId = el.getAttribute("bindId");
            String label = el.getAttribute("label");
            quickAccessMenus.put(bindId, label);
        }
    }

    public NewWizardMenu(IWorkbenchWindow window, String id) {
        super(window, id);
    }

    public NewWizardMenu(IMenuManager innerMgr, IWorkbenchWindow window, boolean register) {
        this(window, null);
        this.fillMenu((IContributionManager)innerMgr);
    }

    private void fillMenu(IContributionManager innerMgr) {
        innerMgr.removeAll();
        IContributionItem[] items = this.getContributionItems();
        int i = 0;
        while (i < items.length) {
            innerMgr.add(items[i]);
            ++i;
        }
    }

    public void deregisterListeners() {
    }

    protected boolean hasExamples() {
        boolean hasCategory = this.registryHasCategory("org.eclipse.ui.Examples");
        if (hasCategory) {
            IWizardCategory exampleCategory = WorkbenchPlugin.getDefault().getNewWizardRegistry().findCategory("org.eclipse.ui.Examples");
            return this.hasWizards(exampleCategory);
        }
        return false;
    }

    private boolean hasWizards(IWizardCategory category) {
        IWizardDescriptor[] wizards = category.getWizards();
        if (wizards.length > 0) {
            int i = 0;
            while (i < wizards.length) {
                if (!WorkbenchActivityHelper.filterItem((Object)wizards[i])) {
                    return true;
                }
                ++i;
            }
        }
        IWizardCategory[] categories = category.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (this.hasWizards(categories[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addItems(List list) {
        ArrayList shortCuts = new ArrayList();
        this.addShortcuts(shortCuts);
        Iterator iterator = shortCuts.iterator();
        while (iterator.hasNext()) {
            Object curr = iterator.next();
            if (!(curr instanceof ActionContributionItem) || !this.isNewProjectWizardAction(((ActionContributionItem)curr).getAction())) continue;
            iterator.remove();
            list.add(curr);
        }
        list.add(new Separator());
        if (!shortCuts.isEmpty()) {
            list.addAll(shortCuts);
            list.add(new Separator());
        }
        list.add(new ActionContributionItem(this.getShowDialogAction()));
    }

    private boolean isNewProjectWizardAction(IAction action) {
        if (action instanceof NewWizardShortcutAction) {
            IWizardDescriptor wizardDescriptor = ((NewWizardShortcutAction)action).getWizardDescriptor();
            String[] tags = wizardDescriptor.getTags();
            int i = 0;
            while (i < tags.length) {
                if ("project".equals(tags[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabledValue) {
        this.enabled = enabledValue;
    }

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] results = new IContributionItem[]{};
        if (this.isEnabled()) {
            results = super.getContributionItems();
        }
        ArrayList<Object> resultItems = new ArrayList<Object>();
        IContributionItem[] iContributionItemArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            boolean isNextSeparator = false;
            if (item instanceof ActionContributionItem) {
                ActionContributionItem actionItem = (ActionContributionItem)item;
                IAction action = actionItem.getAction();
                if (action instanceof NewWizardShortcutAction) {
                    NewWizardShortcutAction wizardAction = (NewWizardShortcutAction)action;
                    String localId = wizardAction.getLocalId();
                    IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)("ID:" + localId));
                    String label = quickAccessMenus.get(wizardAction.getLocalId());
                    if (StringUtil.isNotBlank((String)label)) {
                        wizardAction.setText(label);
                    }
                    if (localId.equals("com.pandora.projects.ui.wizards.NewCssWizard")) {
                        isNextSeparator = true;
                    }
                }
                if ("\u5176\u4ed6(&O)...".equals(action.getText())) {
                    action.setText("\u5176\u4ed6(&N)...");
                }
            }
            resultItems.add(item);
            if (isNextSeparator) {
                resultItems.add(new Separator());
            }
            ++n2;
        }
        return resultItems.toArray(new IContributionItem[resultItems.size()]);
    }
}

