/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.URLEncoder;
import com.aptana.rcp.IdePlugin;
import com.aptana.rcp.Messages;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.datalocation.Location;

class InstallCommandLineExecutableJob
extends Job {
    private static final String EXECUTABLE_NAME = "studio3";
    private static final String INSTALL_PATH = "/usr/local/bin";

    public InstallCommandLineExecutableJob() {
        super(Messages.InstallCommandLineExecutableJob_JobName);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Location loc = Platform.getInstallLocation();
            URL url = loc.getURL();
            File installFolder = new File(URLEncoder.encode((URL)url).toURI());
            sub.worked(1);
            File executable = new File(installFolder, EXECUTABLE_NAME);
            if (!executable.exists()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            File dest = new File(INSTALL_PATH, EXECUTABLE_NAME);
            if (dest.exists()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                ProcessUtil.runInBackground((String)"ln", (IPath)Path.fromOSString((String)installFolder.getAbsolutePath()), (String[])new String[]{"-s", executable.getAbsolutePath(), dest.getAbsolutePath()});
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
                Status status = new Status(4, IdePlugin.PLUGIN_ID, e.getMessage(), (Throwable)e);
                return status;
            }
        }
        finally {
            sub.done();
        }
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        if (Platform.getOS().equals("win32")) {
            return false;
        }
        File dest = new File(INSTALL_PATH, EXECUTABLE_NAME);
        return !dest.exists();
    }

    public boolean shouldRun() {
        return this.shouldSchedule();
    }
}

