/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.refactoring;

import com.pandora.refactor.core.refactoring.PandoraRefactorUtils;
import com.pandora.refactor.core.refactoring.RefactorRenameFileParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ide.IDE;

public class PandoraRenameParticipant
extends RenameParticipant {
    private static IFile srcFile;
    private static IFolder srcFolder;
    private static boolean isFile;

    protected boolean initialize(Object element) {
        srcFile = null;
        srcFolder = null;
        if (element instanceof IFile) {
            srcFile = (IFile)element;
            isFile = true;
        }
        if (element instanceof IFolder) {
            srcFolder = (IFolder)element;
            isFile = false;
        }
        return true;
    }

    private void saveAll() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IProject project = null;
                project = isFile ? srcFile.getProject() : srcFolder.getProject();
                IDE.saveAllEditors((IResource[])new IResource[]{project}, (boolean)true);
            }
        });
    }

    public String getName() {
        return "com.pandora.refactor";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        this.saveAll();
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RenameArguments rename = super.getArguments();
        if (rename == null) {
            return null;
        }
        String newName = rename.getNewName();
        String name = "";
        if (isFile && srcFile != null) {
            name = srcFile.getName();
        } else if (!isFile && srcFolder != null) {
            newName = String.valueOf(newName) + "/";
            name = String.valueOf(srcFolder.getName()) + "/";
        } else {
            return null;
        }
        PandoraRefactorUtils.refactorProjectResource(srcFile, srcFolder, isFile);
        CompositeChange result = new CompositeChange(this.getName());
        if (isFile) {
            RefactorRenameFileParticipant refactorFileParticipant = new RefactorRenameFileParticipant(result, (IResource)srcFile, name, newName);
            refactorFileParticipant.computeChange();
        } else {
            RefactorRenameFileParticipant refactorFileParticipant = new RefactorRenameFileParticipant(result, (IResource)srcFolder, name, newName);
            refactorFileParticipant.computeChange();
        }
        if (result == null || result.getChildren().length < 1) {
            return null;
        }
        return result;
    }
}

