/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.refactor.core.js.inferrer.JSLocalScopeInferrer;
import com.pandora.refactor.core.js.refactoring.JSObjectRefactorStrategy;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class JSPrototypeRefactorStrategy
extends JSObjectRefactorStrategy
implements IRefactorStrategy {
    private IParseNode targetNode = null;

    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        this.targetNode = node;
        super.searchLocalRefactorNode(node, identification, refactorInfo, targetFile);
    }

    @Override
    protected JSFunctionNode getObjectNode(JSIdentifierNode identifierNode) {
        JSGetPropertyNode protoNode;
        JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)identifierNode.getParent();
        if (getPropertyNode.getLeftHandSide() instanceof JSGetPropertyNode && "prototype".equals((protoNode = (JSGetPropertyNode)getPropertyNode.getLeftHandSide()).getRightHandSide().getText())) {
            String objName = protoNode.getLeftHandSide().getText();
            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)identifierNode.getRootNode(), (int)identifierNode.getStartingOffset());
            while (scope != null) {
                JSNode baseNode = null;
                if (scope.getRange() instanceof JSNode) {
                    baseNode = (JSNode)scope.getRange();
                }
                JSLocalScopeInferrer localScopeInferrer = new JSLocalScopeInferrer(baseNode, objName);
                if (baseNode != null) {
                    localScopeInferrer.visit(baseNode);
                } else {
                    localScopeInferrer.visit((JSParseRootNode)identifierNode.getRootNode());
                }
                List<JSIdentifierNode> nodes = localScopeInferrer.getIdentifierNodes();
                for (JSIdentifierNode idnode : nodes) {
                    if (!(idnode.getParent() instanceof JSFunctionNode)) continue;
                    return (JSFunctionNode)idnode.getParent();
                }
                scope = scope.getParentScope();
            }
        }
        return super.getObjectNode(identifierNode);
    }

    @Override
    public void searchOutsideRefactorNode(IFile jsFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
        super.searchOutsideRefactorNode(jsFile, node, identification, refactorInfo);
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        ArrayList<JSRefactorRegion> deleteRegions = new ArrayList<JSRefactorRegion>();
        List<JSRefactorRegion> results = refactorInfo.getResults();
        for (JSRefactorRegion refactorRegion : results) {
            JSIdentifierNode identifierNode = refactorRegion.getRefactorNode();
            if (!(identifierNode.getParent() instanceof JSGetPropertyNode)) {
                deleteRegions.add(refactorRegion);
                continue;
            }
            if (this.targetNode == identifierNode) {
                refactorRegion.setMakeSure(true);
                continue;
            }
            JSGetPropertyNode getNode = (JSGetPropertyNode)identifierNode.getParent();
            IParseNode parseNode = getNode.getLeftHandSide();
            if (parseNode instanceof JSThisNode) continue;
            if (!this.symbols.contains(parseNode.getText())) {
                refactorRegion.setMakeSure(false);
                continue;
            }
            refactorRegion.setMakeSure(true);
        }
        this.executeFilter(refactorInfo, deleteRegions);
    }
}

