/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.js.refactoring;

import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.refactor.core.js.inferrer.JSLocalScopeInferrer;
import com.pandora.refactor.core.js.refactoring.JSFunctionRefactorStrategy;
import com.pandora.refactor.core.refactoring.IRefactorStrategy;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class JSInvokeRefactorStrategy
extends JSFunctionRefactorStrategy
implements IRefactorStrategy {
    protected boolean hasFindTargetFunction = false;

    @Override
    public void searchLocalRefactorNode(IParseNode node, String identification, RefactorContextInfo refactorInfo, IFile targetFile) {
        JSIdentifierNode identifierNode;
        if (node instanceof JSIdentifierNode && ((identifierNode = (JSIdentifierNode)node).getParent() instanceof JSInvokeNode || identifierNode.getParent() instanceof JSConstructNode)) {
            JSParseRootNode rootNode = (JSParseRootNode)identifierNode.getRootNode();
            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)rootNode, (int)identifierNode.getStartingOffset());
            JSFunctionNode targetFunc = this.searchTargetFunctionNode(scope, identifierNode);
            if (targetFunc != null) {
                IParseNode parseNode = targetFunc.getName();
                this.hasFindTargetFunction = true;
                super.searchLocalRefactorNode(parseNode, identification, refactorInfo, targetFile);
            } else {
                this.addResult(refactorInfo, identifierNode, targetFile);
            }
        }
    }

    protected JSFunctionNode searchTargetFunctionNode(JSScope scope, JSIdentifierNode identifierNode) {
        boolean hasFind = false;
        while (!hasFind) {
            JSNode baseNode = null;
            if (scope == null) break;
            if (scope.getRange() instanceof JSNode) {
                baseNode = (JSNode)scope.getRange();
            }
            JSLocalScopeInferrer localScopeInferrer = new JSLocalScopeInferrer(baseNode, identifierNode.getText());
            if (baseNode == null) {
                localScopeInferrer.visit((JSParseRootNode)identifierNode.getRootNode());
            } else {
                localScopeInferrer.visit(baseNode);
            }
            List<JSIdentifierNode> identifierNodes = localScopeInferrer.getIdentifierNodes();
            ArrayList<JSFunctionNode> resultNodes = new ArrayList<JSFunctionNode>();
            for (JSIdentifierNode idNode : identifierNodes) {
                if (!(idNode.getParent() instanceof JSFunctionNode)) continue;
                hasFind = true;
                resultNodes.add((JSFunctionNode)idNode.getParent());
            }
            int offset = -1;
            JSFunctionNode targetFuncNode = null;
            if (hasFind) {
                for (JSFunctionNode functionNode : resultNodes) {
                    if (functionNode.getStartingOffset() < offset) continue;
                    offset = functionNode.getStartingOffset();
                    targetFuncNode = functionNode;
                }
                return targetFuncNode;
            }
            scope = scope.getParentScope();
        }
        return null;
    }

    @Override
    public void searchOutsideRefactorNode(IFile jsFile, IParseNode node, String identification, RefactorContextInfo refactorInfo) {
        if (this.hasFindTargetFunction) {
            super.searchOutsideRefactorNode(jsFile, node, identification, refactorInfo);
        } else if (node instanceof JSIdentifierNode) {
            this.globalSearchRefactorNode(refactorInfo, (JSIdentifierNode)node);
        }
    }

    @Override
    public void filterRefactorNode(RefactorContextInfo refactorInfo) {
        super.filterRefactorNode(refactorInfo);
    }
}

