/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.html.refactoring;

import com.aptana.core.util.FileUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.ext.HTMLFullScript;
import com.aptana.editor.html.ext.HTMLPartitionScanner;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.pandora.refactor.core.IRefactorStrategyFactory;
import com.pandora.refactor.core.html.refactoring.HTMLScriptRefactorStrategyFactory;
import com.pandora.refactor.core.js.refactoring.JSRefactorStrategyFactory;
import com.pandora.refactor.core.refactoring.AbstractSearchContext;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class SwitchRefactorSearchContext
extends AbstractSearchContext {
    private boolean isJSModel = false;
    private IFile targetFile = null;

    public SwitchRefactorSearchContext(boolean isJSModel, IFile targetFile) {
        this.isJSModel = isJSModel;
        this.targetFile = targetFile;
    }

    @Override
    public IRefactorStrategyFactory getRefactorStrategyFactory() {
        if (this.isJSModel) {
            return new JSRefactorStrategyFactory();
        }
        return new HTMLScriptRefactorStrategyFactory();
    }

    @Override
    public int getRealOffset(int offset) {
        if (this.isJSModel) {
            return offset;
        }
        return this.htmlScript.getOffset();
    }

    @Override
    protected IParseNode getCacheAST(AbstractThemeableEditor targetEditor, int offset) throws Exception {
        return this.getAST(targetEditor, offset);
    }

    @Override
    public IParseNode getAST(AbstractThemeableEditor targetEditor, int offset) throws Exception {
        if (this.targetFile.exists()) {
            File file = FileUtil.convertIFileToFile((IFile)this.targetFile);
            String source = FileUtils.readFileToString((File)file);
            if (this.isJSModel) {
                JSParseState parseState = new JSParseState(source, 0, true, true);
                IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
                return ast;
            }
            Document doc = new Document(source);
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new HTMLPartitionScanner(), new String[]{"__html_comment", "__html_quote_tag", "__html_single_tag", "__html_nest_tag"});
            partitioner.connect((IDocument)doc);
            doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            this.htmlScript = new HTMLFullScript((IDocument)doc, offset, this.targetFile, true);
            JSParseState parseState = new JSParseState(this.htmlScript.getSource(), 0, true, true);
            IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            return ast;
        }
        return null;
    }

    @Override
    protected boolean checkEditor(AbstractThemeableEditor targetEditor) {
        return true;
    }

    @Override
    protected IFile getCurrentFile(AbstractThemeableEditor targetEditor) {
        return this.targetFile;
    }
}

