/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.refactor.core.html.refactoring;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.URIUtils;
import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.refactor.core.refactoring.RefactorContextInfo;
import com.pandora.refactor.core.refactoring.RefactorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.TextSearchPage;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IFileEditorInput;

public class HTMLIDOrCLASSRefactorSearch
extends TextSearchPage {
    private static final String HTML_TYPE = "html";
    private static final String JS_TYPE = "js";
    private static final String CSS_TYPE = "css";
    IProject _Project;
    IFile _IFile;
    RefactorContextInfo refactorInfo;
    IDocument _Document;
    HTMLIndexQueryHelper _queryHelper;
    AbstractThemeableEditor editor;
    List<String> jsPrefrenseForIFile;

    public HTMLIDOrCLASSRefactorSearch(AbstractThemeableEditor targetEditor, RefactorContextInfo refactorInfo, int offset) {
        this.editor = targetEditor;
        this._IFile = ((IFileEditorInput)targetEditor.getEditorInput()).getFile();
        this._Project = this._IFile.getProject();
        this.refactorInfo = refactorInfo;
        this._Document = targetEditor.getDocumentProvider().getDocument((Object)targetEditor.getEditorInput());
        this._queryHelper = new HTMLIndexQueryHelper();
        this.jsPrefrenseForIFile = new ArrayList<String>();
        this.getIFileJSPrefrense(this._IFile);
    }

    public RefactorContextInfo searchResult() {
        this.performAction();
        return this.refactorInfo;
    }

    public boolean performAction() {
        IResource[] res = new IResource[1];
        String htmlPrefix = "class";
        String cssPrefix = "\\.";
        String JSPrefix_1 = "document.getElementsByClassName\\([\"']";
        String JSPrefix_2 = "className[\\s]*=[\\s]*[\"']";
        if (this.refactorInfo.isID()) {
            htmlPrefix = "id";
            cssPrefix = "#";
            JSPrefix_1 = "document.getElementById\\([\"']";
            JSPrefix_2 = "";
        }
        res[0] = this._Project;
        String[] extens = this.getExtends(HTML_TYPE);
        String oldName = this.refactorInfo.getOldName();
        String searchContent = String.valueOf(htmlPrefix) + "[\\s]*=[\\s]*[\"'][a-zA-Z0-9]*[\\s]*" + oldName + "[\\s]*[a-zA-Z0-9]*[\"']";
        this.search(res, searchContent, extens);
        extens = this.getExtends(CSS_TYPE);
        searchContent = String.valueOf(cssPrefix) + oldName;
        this.search(res, searchContent, extens);
        extens = this.getExtends(JS_TYPE);
        searchContent = String.valueOf(JSPrefix_1) + oldName + "[\"']\\)";
        this.search(res, searchContent, extens);
        if (!this.refactorInfo.isID()) {
            searchContent = String.valueOf(JSPrefix_2) + oldName + "[\"']";
            this.search(res, searchContent, extens);
            searchContent = "classList[\\.](add|remove|item|contains|toggle){1}[\\(][\"']" + oldName + "[\"'][\\)]";
            this.search(res, searchContent, extens);
        }
        return true;
    }

    private void getIFileJSPrefrense(IFile file) {
        Index index = this.getIndex();
        Map jsMap = this._queryHelper.getJSReferences(index);
        if (jsMap == null) {
            return;
        }
        Set set = jsMap.keySet();
        String iFilePath = file.getProjectRelativePath().toString();
        for (String key : set) {
            Set values;
            if (StringUtil.isBlank((String)key) || !(values = (Set)jsMap.get(key)).contains(iFilePath)) continue;
            this.jsPrefrenseForIFile.add(this.getPath(key));
        }
    }

    private void search(IResource[] res, String searchContent, String[] extens) {
        FileTextSearchScope fts = FileTextSearchScope.newSearchScope((IResource[])res, (String[])extens, (boolean)false);
        FileSearchQuery isq = new FileSearchQuery(searchContent, true, true, fts);
        isq.run((IProgressMonitor)new NullProgressMonitor());
        this.processResult(isq);
    }

    private void processResult(FileSearchQuery isq) {
        ISearchResult isr = isq.getSearchResult();
        try {
            if (isr instanceof FileSearchResult) {
                Object[] os;
                FileSearchResult fsr = (FileSearchResult)isr;
                Object[] objectArray = os = fsr.getElements();
                int n = os.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file;
                    Object object = objectArray[n2];
                    if (object instanceof IFile && this.filterFile(file = (IFile)object)) {
                        IDocument document = RefactorUtils.getDocumentByIFile(file);
                        Match[] matchs = fsr.getMatches(object);
                        this.getResult(file, document, matchs);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    private void getResult(IFile file, IDocument document, Match[] matchs) throws CoreException {
        Match[] matchArray = matchs;
        int n = matchs.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            try {
                String searchInfo = document.get(match.getOffset(), match.getLength());
                String oldName = this.refactorInfo.getOldName();
                IRange resultRange = this.getResultRange(searchInfo, match, file);
                if (resultRange != null) {
                    JSRefactorRegion region = new JSRefactorRegion();
                    region.setStartOffset(resultRange.getStartingOffset());
                    region.setEndOffset(resultRange.getEndingOffset());
                    region.setNewName(this.refactorInfo.getNewName());
                    region.setOldName(oldName);
                    region.setTargetFile(file);
                    if (file.equals((Object)this._IFile)) {
                        region.setMakeSure(true);
                    } else {
                        region.setMakeSure(false);
                    }
                    this.refactorInfo.addResult(region);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private IRange getResultRange(String searchInfo, Match match, IFile file) throws CoreException, BadLocationException {
        boolean isID = this.refactorInfo.isID();
        String oldName = this.refactorInfo.getOldName();
        int oLength = oldName.length();
        Range range = null;
        String prefix = "";
        int startOffset = match.getOffset();
        int endOffset = 0;
        String cssSearchInfo = "";
        IDocument document = RefactorUtils.getDocumentByIFile(file);
        cssSearchInfo = isID ? "#" + oldName : "." + oldName;
        if (searchInfo.equals(cssSearchInfo)) {
            try {
                CSSParseRootNode root = RefactorUtils.getCSSParseRoot(document);
                IParseNode node = root.getNodeAtOffset(match.getOffset());
                String tagValue = node.getText();
                if (!cssSearchInfo.equals(tagValue)) {
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            endOffset = ++startOffset + oLength - 1;
            range = new Range(startOffset, endOffset);
        } else {
            prefix = "\"" + oldName + "\"";
            if ((range = this.getIRange(searchInfo, oLength, (IRange)range, prefix, startOffset)) == null) {
                prefix = "'" + oldName + "'";
                range = this.getIRange(searchInfo, oLength, (IRange)range, prefix, startOffset);
            }
            if (range == null) {
                prefix = " " + oldName + " ";
                range = this.getIRange(searchInfo, oLength, (IRange)range, prefix, startOffset);
            }
            if (range == null) {
                prefix = " " + oldName + "'";
                range = this.getIRange(searchInfo, oLength, (IRange)range, prefix, startOffset);
            }
            if (range == null) {
                prefix = " " + oldName + "\"";
                range = this.getIRange(searchInfo, oLength, (IRange)range, prefix, startOffset);
            }
            if (range == null) {
                prefix = "'" + oldName + " ";
                range = this.getIRange(searchInfo, oLength, (IRange)range, prefix, startOffset);
            }
            if (range == null) {
                prefix = "\"" + oldName + " ";
                range = this.getIRange(searchInfo, oLength, (IRange)range, prefix, startOffset);
            }
        }
        return range;
    }

    private IRange getIRange(String searchInfo, int oLength, IRange range, String prefix, int startOffset) {
        int index = searchInfo.indexOf(prefix);
        int endOffset = 0;
        if (index > -1) {
            endOffset = (startOffset += index + 1) + oLength - 1;
            range = new Range(startOffset, endOffset);
        }
        return range;
    }

    private boolean filterFile(IFile file) {
        if (file.equals((Object)this._IFile)) {
            return true;
        }
        String path = file.getProjectRelativePath().toString();
        if (HMobileProject.isFilterFolder((String)path)) {
            return false;
        }
        if (RefactorUtils.isHTML(file)) {
            return true;
        }
        if (RefactorUtils.isJS(file)) {
            return true;
        }
        if (RefactorUtils.isCSS(file)) {
            List<String> list = this.getCSSReferences(this._IFile);
            return list.contains(file.getProjectRelativePath().toString());
        }
        return false;
    }

    private List<String> getCSSReferences(IFile iFile) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IDocument document = RefactorUtils.getDocumentByIFile(iFile);
            int length = document.getLength();
            int offset = 0;
            boolean inDocument = true;
            while (inDocument) {
                String regix;
                String srcvalue;
                ITypedRegion partition = document.getPartition(offset);
                String pInfo = document.get(partition.getOffset(), partition.getLength());
                offset = partition.getOffset() + partition.getLength();
                if (offset >= length) {
                    inDocument = false;
                }
                if (!StringUtil.isNotBlank((String)(pInfo = pInfo.trim())) || !pInfo.startsWith("<link ") || !StringUtil.isNotBlank((String)(srcvalue = RegularUtils.match((String)(regix = "href[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']"), (String)pInfo, (int)1)))) continue;
                srcvalue = srcvalue.startsWith("/") ? srcvalue.substring(1) : URIUtils.resolveURI((String)iFile.getProjectRelativePath().toString(), (String)srcvalue);
                list.add(srcvalue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private String getPath(String key) {
        String projectPath;
        String path = key;
        String prefix = "file:/";
        if (path.startsWith(prefix)) {
            path = path.substring(prefix.length());
        }
        if (path.startsWith(projectPath = this._Project.getLocation().toString())) {
            path = path.substring(projectPath.length());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    protected Index getIndex() {
        return EditorUtil.getIndex((AbstractThemeableEditor)this.editor);
    }

    private String[] getExtends(String type) {
        String[] htmlExtends = new String[1];
        if (type.equals(HTML_TYPE)) {
            htmlExtends = RefactorUtils.HTML_EXTENDTIONS;
        } else if (type.equals(JS_TYPE)) {
            htmlExtends = RefactorUtils.JS_EXTENDTIONS;
        } else if (type.equals(CSS_TYPE)) {
            htmlExtends = RefactorUtils.CSS_EXTENDTIONS;
        }
        int htmlExtendLength = htmlExtends.length;
        String[] extens = new String[htmlExtendLength + 1];
        int i = 0;
        while (i < htmlExtendLength) {
            extens[i] = "*." + htmlExtends[i];
            ++i;
        }
        extens[htmlExtendLength] = this._IFile.getName();
        return extens;
    }
}

