/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.search.ui.query;

import com.pandora.refactor.core.js.refactoring.JSRefactorRegion;
import com.pandora.search.FileReferenceSearchResult;
import com.pandora.search.ui.provider.ReferenceMatch;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class FileReferenceSearchQuery
implements ISearchQuery {
    private List<JSRefactorRegion> regions = null;

    public FileReferenceSearchQuery(List<JSRefactorRegion> regions) {
        this.regions = regions;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        System.out.println("\u6267\u884c");
        return Status.OK_STATUS;
    }

    public String getLabel() {
        System.out.println("getLabel");
        return "ReferenceSearch...";
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return false;
    }

    public ISearchResult getSearchResult() {
        if (this.regions == null || this.regions.isEmpty()) {
            return null;
        }
        FileReferenceSearchResult searchResult = new FileReferenceSearchResult();
        searchResult.setSearchQuery(this);
        for (JSRefactorRegion region : this.regions) {
            ReferenceMatch match = new ReferenceMatch(region.getTargetFile(), region.getStartOffset(), region.getLength());
            match.setElementName(region.getOldName());
            try {
                IFile ifile = region.getTargetFile();
                File file = ifile.getLocation().makeAbsolute().toFile();
                if (file.exists()) {
                    String contents = FileUtils.readFileToString((File)file, (String)ifile.getCharset());
                    Document document = new Document(contents);
                    match.setLineNum(document.getLineOfOffset(region.getStartOffset()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            searchResult.addMatch(match);
        }
        return searchResult;
    }
}

