/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.compare.contentmergeviewer.TokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class FormatterUtils {
    public static boolean isSpace(char c) {
        return c == '\t' || c == ' ';
    }

    public static boolean isLineSeparator(char c) {
        return c == '\r' || c == '\n';
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isNewLine(IFormatterNode node) {
        if (!(node instanceof IFormatterTextNode)) {
            return false;
        }
        IFormatterTextNode textNode = (IFormatterTextNode)node;
        IFormatterDocument document = node.getDocument();
        int start = textNode.getStartOffset();
        if (start < textNode.getEndOffset()) {
            if (document.charAt(start) == '\n') {
                ++start;
            } else {
                if (document.charAt(start) != '\r') {
                    return false;
                }
                if (++start < textNode.getEndOffset() && document.charAt(start) == '\n') {
                    ++start;
                }
            }
        }
        while (start < textNode.getEndOffset()) {
            if (!FormatterUtils.isSpace(document.charAt(start))) {
                return false;
            }
            ++start;
        }
        return true;
    }

    public static boolean isEmptyText(IFormatterNode node) {
        if (node instanceof IFormatterTextNode) {
            String text = ((IFormatterTextNode)node).getText();
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static IFormatterNode[] toTextNodeArray(List<IFormatterNode> list) {
        if (list != null) {
            return list.toArray(new IFormatterNode[list.size()]);
        }
        return null;
    }

    public static int getEditorTabWidth(IPreferenceStore preferenceStore) {
        IPreferenceStore prefs = FormatterUtils.getChainedPreferences(preferenceStore, EditorsPlugin.getDefault().getPreferenceStore());
        return prefs.getInt("tabWidth");
    }

    public static boolean isInsertSpacesForTabs(IPreferenceStore preferenceStore) {
        IPreferenceStore prefs = FormatterUtils.getChainedPreferences(preferenceStore, EditorsPlugin.getDefault().getPreferenceStore());
        return prefs.getBoolean("spacesForTabs");
    }

    public static List<IRegion> resolveOnOffRegions(LinkedHashMap<Integer, String> commentsMap, Pattern onPattern, Pattern offPattern, int documentEndOffset) {
        ArrayList<IRegion> regions = new ArrayList<IRegion>();
        boolean isOn = true;
        int start = -1;
        int end = -1;
        int startCommentBeginOffset = -1;
        for (Integer offset : commentsMap.keySet()) {
            Matcher matcher;
            String comment = commentsMap.get(offset);
            if (isOn) {
                matcher = offPattern.matcher(comment);
                if (!matcher.find()) continue;
                start = matcher.start();
                startCommentBeginOffset = offset;
                isOn = false;
                continue;
            }
            matcher = onPattern.matcher(comment);
            if (!matcher.find()) continue;
            end = matcher.end();
            int regionStart = startCommentBeginOffset + start;
            regions.add((IRegion)new Region(regionStart, offset + end - regionStart));
            isOn = true;
            start = -1;
            end = -1;
            startCommentBeginOffset = -1;
        }
        if (start > -1 && end < 0) {
            start = startCommentBeginOffset + start;
            regions.add((IRegion)new Region(start, documentEndOffset - start));
        }
        return regions;
    }

    public static String applyOffOnRegions(String input, String output, List<IRegion> inputOffOnRegions, List<IRegion> outputOffOnRegions) throws CoreException {
        if (outputOffOnRegions == null || inputOffOnRegions.size() != outputOffOnRegions.size()) {
            IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)(outputOffOnRegions == null ? "Output OFF/ON regions was null" : "Output OFF/ON regions do not match in size to the input regions"), (String)"com.aptana.formatter.epl/debug");
            throw new CoreException((IStatus)new Status(4, "com.aptana.formatter.epl", "Error applying the formatter ON-OFF regions"));
        }
        StringBuilder outputBuffer = new StringBuilder(output);
        int i = inputOffOnRegions.size() - 1;
        while (i >= 0) {
            IRegion inputRegion = inputOffOnRegions.get(i);
            IRegion outputRegion = outputOffOnRegions.get(i);
            String originalString = input.substring(inputRegion.getOffset(), inputRegion.getOffset() + inputRegion.getLength());
            outputBuffer.replace(outputRegion.getOffset(), outputRegion.getOffset() + outputRegion.getLength(), originalString);
            --i;
        }
        return outputBuffer.toString();
    }

    public static RangeDifference[] getDiff(String left, String right) {
        TokenComparator leftRangeComparator = new TokenComparator(left);
        TokenComparator rightRangeComparator = new TokenComparator(right);
        return RangeDifferencer.findRanges((IRangeComparator)leftRangeComparator, (IRangeComparator)rightRangeComparator);
    }

    public static void logDiff(String input, String output) {
        int length = Math.min(input.length(), output.length());
        int offset = 0;
        while (offset < length) {
            if (input.charAt(offset) != output.charAt(offset)) break;
            ++offset;
        }
        StringBuilder message = new StringBuilder(100);
        message.append("Formatted content differ around position ");
        message.append(offset);
        message.append("\nINPUT:\n");
        int start = Math.max(0, offset - 10);
        int end = Math.min(offset + 40, input.length());
        message.append(input.substring(start, end));
        message.append("\nOUTPUT:\n");
        start = Math.max(0, offset - 10);
        end = Math.min(offset + 40, output.length());
        message.append(output.substring(start, end));
        IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)message.toString());
    }

    private static IPreferenceStore getChainedPreferences(IPreferenceStore optionalStore, IPreferenceStore defaultStore) {
        IPreferenceStore prefs;
        if (optionalStore == null) {
            prefs = defaultStore;
        } else {
            IPreferenceStore[] preferenceStores = new IPreferenceStore[]{optionalStore, defaultStore};
            prefs = new ChainedPreferenceStore(preferenceStores);
        }
        return prefs;
    }
}

