/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.formatter.FormatterIndentGenerator;
import com.aptana.formatter.FormatterMixedIndentGenerator;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterIndentGenerator;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.IParserPool;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public abstract class AbstractScriptFormatter
implements IScriptFormatter {
    protected static final long ERROR_DISPLAY_TIMEOUT = 3000L;
    protected static final Context scriptContext = Context.enter();
    protected static final Scriptable scriptScope = scriptContext.initStandardObjects(null, true);
    private static volatile boolean hasInitJavaScriptEngine = false;
    private final Map<String, String> preferences;
    private boolean isSlave;
    private String mainContentType;
    protected String lineSeparator;

    protected AbstractScriptFormatter(Map<String, String> preferences, String mainContentType, String lineSeparator) {
        this.preferences = preferences;
        this.mainContentType = mainContentType;
        this.lineSeparator = lineSeparator;
        this.initScriptScriptEngine();
    }

    private void initScriptScriptEngine() {
        if (!hasInitJavaScriptEngine) {
            hasInitJavaScriptEngine = true;
            scriptContext.evaluateString(scriptScope, "global = new Object();", null, 0, null);
        }
        this.loadScript();
    }

    protected void loadScript() {
    }

    protected IParser checkoutParser() {
        IParser parser = null;
        IParserPool pool = ParserPoolFactory.getInstance().getParserPool(this.getMainContentType());
        if (pool != null) {
            parser = (IParser)pool.checkOut();
        }
        return parser;
    }

    protected void checkinParser(IParser parser) {
        IParserPool pool;
        if (parser != null && (pool = ParserPoolFactory.getInstance().getParserPool(this.getMainContentType())) != null) {
            pool.checkIn((Object)parser);
        }
    }

    protected IParser checkoutParser(String contentTypeOrLanguage) {
        IParser parser = null;
        IParserPool pool = ParserPoolFactory.getInstance().getParserPool(contentTypeOrLanguage);
        if (pool != null) {
            parser = (IParser)pool.checkOut();
        }
        return parser;
    }

    protected void checkinParser(IParser parser, String contentTypeOrLanguage) {
        IParserPool pool;
        if (parser != null && (pool = ParserPoolFactory.getInstance().getParserPool(contentTypeOrLanguage)) != null) {
            pool.checkIn((Object)parser);
        }
    }

    public String getMainContentType() {
        return this.mainContentType;
    }

    protected boolean getBoolean(String key) {
        String value = this.preferences.get(key);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)((Object)value);
            }
            if (value instanceof Number) {
                return ((Number)((Object)value)).intValue() != 0;
            }
            return Boolean.valueOf(value.toString());
        }
        return false;
    }

    protected Set<String> getSet(String key, String delimiter) {
        String value = this.preferences.get(key);
        if (value != null) {
            String[] elements = value.toString().split(delimiter);
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                set.add(str);
                ++n2;
            }
            return set;
        }
        return Collections.emptySet();
    }

    protected int getInt(String key) {
        return AbstractScriptFormatter.toInt(this.preferences.get(key));
    }

    protected int getInt(String key, int minValue) {
        return Math.max(minValue, AbstractScriptFormatter.toInt(this.preferences.get(key)));
    }

    protected void logError(String input, String output) {
        StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
        IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)FormatterMessages.Formatter_basicLogFormatterError, (String)"com.aptana.formatter.epl/debug");
    }

    private static int toInt(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    protected String getString(String key) {
        String value = this.preferences.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected List<IRegion> getOutputOnOffRegions(String output, String formatterOffPattern, String formatterOnPattern) {
        return this.getOutputOnOffRegions(formatterOffPattern, formatterOnPattern, (IParseState)new ParseState(output));
    }

    protected List<IRegion> getOutputOnOffRegions(String formatterOffPattern, String formatterOnPattern, IParseState parseState) {
        String output = parseState.getSource();
        List<IRegion> onOffRegions = null;
        try {
            IParseNode[] commentNodes;
            IParseRootNode parseResult = null;
            IParser parser = this.checkoutParser();
            try {
                if (parser != null) {
                    parseResult = parser.parse(parseState).getRootNode();
                }
            }
            finally {
                this.checkinParser(parser);
            }
            if (parseResult != null && (commentNodes = parseResult.getCommentNodes()) != null) {
                LinkedHashMap<Integer, String> commentsMap = new LinkedHashMap<Integer, String>(commentNodes.length);
                IParseNode[] iParseNodeArray = commentNodes;
                int n = commentNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    IParseNode comment = iParseNodeArray[n2];
                    int start = comment.getStartingOffset();
                    int end = comment.getEndingOffset();
                    String commentStr = output.substring(start, end);
                    commentsMap.put(start, commentStr);
                    ++n2;
                }
                if (!commentsMap.isEmpty()) {
                    Pattern onPattern = Pattern.compile(Pattern.quote(formatterOnPattern));
                    Pattern offPattern = Pattern.compile(Pattern.quote(formatterOffPattern));
                    onOffRegions = FormatterUtils.resolveOnOffRegions(commentsMap, onPattern, offPattern, output.length() - 1);
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)"Error while computing the formatter's output OFF/ON regions", (Throwable)e, (String)"com.aptana.formatter.epl/debug");
        }
        return onOffRegions;
    }

    protected TextEdit indent(String completeSource, String toFormat, int offset, int length, int indentationLevel) {
        if (!this.canIndent(completeSource, offset - 1)) {
            return null;
        }
        IFormatterIndentGenerator indentGenerator = this.createIndentGenerator();
        StringBuilder builder = new StringBuilder();
        indentGenerator.generateIndent(indentationLevel, builder);
        int leftWhitespaceChars = AbstractScriptFormatter.countLeftWhitespaceChars(toFormat);
        builder.append(toFormat.substring(leftWhitespaceChars));
        return new ReplaceEdit(offset, length, builder.toString());
    }

    private boolean canIndent(String completeSource, int offset) {
        if (StringUtil.isEmpty((String)completeSource)) {
            return true;
        }
        if (offset >= completeSource.length()) {
            return false;
        }
        int i = offset;
        while (i >= 0) {
            char c = completeSource.charAt(i);
            if (c != ' ' && c != '\t') {
                return c == '\n' || c == '\r';
            }
            --i;
        }
        return false;
    }

    protected IFormatterIndentGenerator createIndentGenerator() {
        int tabSize = this.getTabSize();
        int indentSize = this.getIndentSize();
        String indentType = this.getIndentType();
        if ("editor".equals(indentType)) {
            indentSize = tabSize = this.getEditorSpecificTabWidth();
            if (this.isEditorInsertSpacesForTabs()) {
                return new FormatterIndentGenerator(' ', indentSize, tabSize);
            }
            return new FormatterMixedIndentGenerator(indentSize, tabSize);
        }
        if ("space".equals(indentType)) {
            return new FormatterIndentGenerator(' ', indentSize, tabSize);
        }
        if ("mixed".equals(indentType)) {
            return new FormatterMixedIndentGenerator(indentSize, tabSize);
        }
        return new FormatterIndentGenerator('\t', 1, tabSize);
    }

    protected boolean equalLinesIgnoreBlanks(Reader inputReader, Reader outputReader) {
        LineNumberReader input = new LineNumberReader(inputReader);
        LineNumberReader output = new LineNumberReader(outputReader);
        String inputLine = null;
        String outputLine = null;
        boolean result = true;
        while (result) {
            inputLine = this.readLine(input);
            outputLine = this.readLine(output);
            if (inputLine == null) {
                result = outputLine == null;
                break;
            }
            if (outputLine == null) {
                result = false;
                continue;
            }
            if (inputLine.equals(outputLine)) continue;
            result = false;
        }
        if (!result && FormatterPlugin.getDefault().isDebugging()) {
            if (inputLine != null && outputLine != null) {
                FormatterUtils.logDiff(inputLine, outputLine);
            } else {
                IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (String)("Formatter Error - Input line does not match output line:\nINPUT:\n" + inputLine + "\nOUTPUT\n" + outputLine));
            }
        }
        return result;
    }

    protected boolean equalsIgnoreWhitespaces(String in, String out) {
        if (in == null || out == null) {
            return in == out;
        }
        boolean result = (in = in.replaceAll("\\s|\\u3000|\\u00A0", "")).equals(out = out.replaceAll("\\s|\\u3000|\\u00A0", ""));
        if (!result && FormatterPlugin.getDefault().isDebugging()) {
            FormatterUtils.logDiff(in, out);
        }
        return result;
    }

    private String readLine(LineNumberReader reader) {
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                return line;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int detectIndentationLevel(IDocument document, int offset) {
        if (document.getLength() <= offset + 1) {
            return 0;
        }
        try {
            char c;
            int lineNumber;
            String lineDelimiter = document.getLineDelimiter(document.getLineOfOffset(offset));
            if (lineDelimiter == null) {
                lineDelimiter = "";
            }
            if ((lineNumber = document.getLineOfOffset(Math.min(document.getLength(), offset + lineDelimiter.length()))) <= 0) return 0;
            IRegion previousLineRegion = document.getLineInformation(lineNumber - 1);
            String text = document.get(previousLineRegion.getOffset(), previousLineRegion.getLength());
            int spaceChars = 0;
            int tabChars = 0;
            int i = 0;
            while (i < text.length() && Character.isWhitespace(c = text.charAt(i))) {
                if (c != '\n' && c != '\r') {
                    if (c == ' ') {
                        ++spaceChars;
                    } else if (c == '\t') {
                        ++tabChars;
                    }
                }
                ++i;
            }
            String indentType = this.getIndentType();
            int indentSize = this.getIndentSize();
            int tabSize = this.getTabSize();
            if ("tab".equals(indentType)) {
                if (tabSize != 0) return spaceChars / tabSize + tabChars + 1;
                return 0;
            }
            if ("editor".equals(indentType)) {
                indentSize = tabSize = this.getEditorSpecificTabWidth();
            }
            if (indentSize <= 0) return 0;
            if ("space".equals(indentType)) return (spaceChars + tabSize * tabChars) / indentSize + 1;
            if (!"editor".equals(indentType)) return (spaceChars + tabChars) / indentSize + 1;
            return (spaceChars + tabSize * tabChars) / indentSize + 1;
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
        }
        return 0;
    }

    @Override
    public void setIsSlave(boolean isSlave) {
        this.isSlave = isSlave;
    }

    @Override
    public boolean isSlave() {
        return this.isSlave;
    }

    protected static String leftTrim(String str, int keptChars) {
        int whitespaceChars = AbstractScriptFormatter.countLeftWhitespaceChars(str);
        if (whitespaceChars >= keptChars) {
            whitespaceChars -= keptChars;
        }
        return str.substring(whitespaceChars);
    }

    protected static int countLeftWhitespaceChars(String str) {
        int i = 0;
        int length = str.length();
        while (i < length && Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        return i;
    }

    protected String processNestedOutput(String output, String lineSeparator, String suffix, String indentSufix, boolean prefixWithNewLine, boolean postfixWithNewLine) {
        if (output.split(lineSeparator, 2).length > 1) {
            StringBuilder wrappedOutput = new StringBuilder(output);
            if (prefixWithNewLine) {
                wrappedOutput.insert(0, lineSeparator);
            }
            if (postfixWithNewLine) {
                if (!output.endsWith(lineSeparator)) {
                    wrappedOutput.append(lineSeparator);
                }
                wrappedOutput.append(indentSufix);
            } else {
                wrappedOutput.append(suffix);
            }
            output = wrappedOutput.toString();
        } else {
            output = String.valueOf(output.trim()) + suffix;
        }
        return output;
    }

    protected String processNestedOutput(String output, String lineSeparator, String indentSufix, boolean prefixWithNewLine, boolean postfixWithNewLine) {
        return this.processNestedOutput(output, lineSeparator, "", indentSufix, prefixWithNewLine, postfixWithNewLine);
    }
}

