/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.epl.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Set;

public final class SoftHashMap<Key, Val>
extends AbstractMap<Key, Val> {
    private final LinkedHashMap<Key, SoftValue<Key, Val>> map = new LinkedHashMap();
    private ReferenceQueue<Val> queue = new ReferenceQueue();
    private int maxSize = -1;

    public SoftHashMap(int maxSize) {
        this.maxSize = maxSize;
    }

    public SoftHashMap() {
        this.maxSize = 100;
    }

    @Override
    public Val get(Object key) {
        Val res = null;
        SoftValue<Key, Val> sr = this.map.get(key);
        if (sr != null && (res = (Val)sr.get()) == null) {
            this.removeStaleEntries();
        }
        return res;
    }

    public void removeStaleEntries() {
        SoftValue softValue;
        while ((softValue = (SoftValue)this.queue.poll()) != null) {
            SoftValue<Key, Val> curr = this.map.get(softValue.key);
            if (curr != softValue) continue;
            curr.clear();
            this.map.remove(softValue.key);
        }
    }

    @Override
    public Val put(Key key, Val value) {
        if (this.maxSize >= 0 && this.map.size() + 1 > this.maxSize) {
            this.map.remove(this.map.keySet().iterator().next());
        }
        this.map.put(key, new SoftValue(value, key, this.queue));
        return value;
    }

    @Override
    public Val remove(Object key) {
        this.map.remove(key);
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.queue = new ReferenceQueue();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    private static final class SoftValue<Key, Val>
    extends SoftReference<Val> {
        private final Key key;

        private SoftValue(Val value, Key key, ReferenceQueue<Val> queue) {
            super(value, queue);
            this.key = key;
        }
    }
}

