/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.epl.util;

import com.aptana.core.epl.util.LRUCache;
import com.aptana.core.epl.util.SoftHashMap;
import java.util.Map;

public class LRUCacheWithSoftPrunedValues<K, V>
extends LRUCache<K, V> {
    private final Map<K, V> auxiliaryCache;

    public LRUCacheWithSoftPrunedValues(int size) {
        this(size, new SoftHashMap());
    }

    LRUCacheWithSoftPrunedValues(int size, Map<K, V> auxiliaryCache) {
        super(size);
        this.auxiliaryCache = auxiliaryCache;
    }

    @Override
    public V get(K key) {
        Object value = super.get(key);
        if (value == null) {
            V auxiliaryValue = this.auxiliaryCache.get(key);
            if (auxiliaryValue != null && super.put(key, auxiliaryValue)) {
                this.auxiliaryCache.remove(key);
            }
            return auxiliaryValue;
        }
        return value;
    }

    @Override
    protected void privateRemoveEntry(LRUCache.LRUCacheEntry<K, V> entry, boolean shuffle) {
        super.privateRemoveEntry(entry, shuffle);
        if (!shuffle) {
            this.auxiliaryCache.put(entry.key, entry.value);
        }
    }

    @Override
    public boolean put(K key, V value) {
        boolean added = super.put(key, value);
        if (!added) {
            this.auxiliaryCache.put(key, value);
        } else {
            this.auxiliaryCache.remove(key);
        }
        return added;
    }

    @Override
    public void flush() {
        super.flush();
        this.auxiliaryCache.clear();
    }
}

