/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.build.BuildTerminateException;
import com.aptana.core.build.IndexBuildHelper;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.FileStoreBuildContext;
import com.aptana.index.core.IFileStoreIndexingContextType;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.IIndexFileContributor;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.Messages;
import com.aptana.index.core.build.BuildContext;
import com.aptana.index.core.filter.IIndexFilterParticipant;
import com.pandora.core.stats.Stats;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

abstract class IndexRequestJob
extends Job {
    public static final String INDEX_REQUEST_JOB_FAMILY = "index-request-job-family";
    private URI containerURI;
    private IProject project;
    private boolean isNeedFilter = true;

    public boolean isNeedFilter() {
        return this.isNeedFilter;
    }

    public void setNeedFilter(boolean isNeedFilter) {
        this.isNeedFilter = isNeedFilter;
    }

    protected IndexRequestJob(String name, URI containerURI, IProject project) {
        super(name);
        this.containerURI = containerURI;
        this.setRule(IndexManager.MUTEX_RULE);
        this.setPriority(40);
        this.project = project;
    }

    protected IndexRequestJob(URI containerURI, IProject project) {
        this(MessageFormat.format(Messages.IndexRequestJob_Name, new File(containerURI).exists() ? new File(containerURI).getAbsolutePath() : containerURI.toString()), containerURI, project);
    }

    public boolean belongsTo(Object family) {
        return family == INDEX_REQUEST_JOB_FAMILY;
    }

    protected BuildContextType getBuildContextType() {
        return BuildContextType.ALL;
    }

    protected Set<IFileStore> filterFileStores(Set<IFileStore> fileStores) {
        IndexManager manager;
        if (!CollectionsUtil.isEmpty(fileStores) && (manager = this.getIndexManager()) != null) {
            for (IIndexFilterParticipant filterParticipant : manager.getFilterParticipants()) {
                fileStores = filterParticipant.applyFilter(fileStores);
            }
        }
        return fileStores;
    }

    protected URI getContainerURI() {
        return this.containerURI;
    }

    protected Set<IFileStore> getContributedFiles(URI container) {
        HashSet<IFileStore> result = new HashSet<IFileStore>();
        IndexManager manager = this.getIndexManager();
        if (manager != null) {
            for (IIndexFileContributor contributor : manager.getFileContributors()) {
                Set<IFileStore> files = contributor.getFiles(container);
                if (CollectionsUtil.isEmpty(files)) continue;
                result.addAll(files);
            }
        }
        return result;
    }

    protected Index getIndex() {
        IndexManager manager = this.getIndexManager();
        return manager != null ? manager.getIndex(this.getContainerURI()) : null;
    }

    protected IndexManager getIndexManager() {
        IndexPlugin plugin = IndexPlugin.getDefault();
        return plugin != null ? plugin.getIndexManager() : null;
    }

    protected IProject getProject() {
        return this.project;
    }

    protected void indexFileStores(Index index, Set<IFileStore> fileStores, IProgressMonitor monitor) throws CoreException {
        if (index == null) {
            return;
        }
        if (CollectionsUtil.isEmpty(fileStores = this.filterFileStores(fileStores))) {
            return;
        }
        int remaining = fileStores.size();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(remaining * 11));
        try {
            for (IFileStore file : fileStores) {
                if (sub.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                List<IFileStoreIndexingParticipant> indexers = this.getIndexParticipants(file);
                boolean removeIndex = false;
                for (IFileStoreIndexingParticipant indexer : indexers) {
                    try {
                        if (!indexer.isEnableType(this.getBuildContextType())) continue;
                        removeIndex = true;
                        break;
                    }
                    catch (Throwable throwable) {}
                }
                if (removeIndex) {
                    index.remove(file.toURI());
                    sub.worked(1);
                }
                if (!CollectionsUtil.isEmpty(indexers)) {
                    int work = 10 / indexers.size();
                    FileStoreBuildContext context = new FileStoreBuildContext(this.getProject(), file);
                    context.setNeedSleep(true);
                    IndexBuildHelper.startListening((!context.isReconcile() ? 1 : 0) != 0, (IFile)((BuildContext)context).getFile());
                    for (IFileStoreIndexingParticipant indexer : indexers) {
                        if (sub.isCanceled()) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                        try {
                            if (indexer instanceof IFileStoreIndexingContextType) {
                                IFileStoreIndexingContextType contextType = (IFileStoreIndexingContextType)((Object)indexer);
                                contextType.setBuildContextType(this.getBuildContextType());
                            }
                            if (indexer.isEnableType(this.getBuildContextType())) {
                                indexer.index(context, index, (IProgressMonitor)sub.newChild(work));
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof BuildTerminateException) {
                                Stats.addExceptionInfo((Throwable)e);
                                break;
                            }
                            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                        }
                        BuildHelper.sleep((String)"BUILD_FILE_TYPE");
                    }
                }
                sub.setWorkRemaining(--remaining * 11);
            }
        }
        finally {
            sub.done();
        }
    }

    protected List<IFileStoreIndexingParticipant> getIndexParticipants(IFileStore file) {
        IndexManager indexManager = this.getIndexManager();
        if (indexManager != null) {
            return indexManager.getIndexParticipants(file.getName());
        }
        return Collections.emptyList();
    }
}

