/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.IndexRequestJob;
import com.aptana.index.core.filter.SDocMLFileIndexingFilterManager;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class IndexContainerJob
extends IndexRequestJob {
    protected IndexContainerJob(URI containerURI, IProject project) {
        super(containerURI, project);
    }

    protected IndexContainerJob(String name, URI containerURI, IProject project) {
        super(name, containerURI, project);
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Index index = this.getIndex();
        if (index == null) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)MessageFormat.format("Index is null for container: {0}", this.getContainerURI()));
            return Status.CANCEL_STATUS;
        }
        try {
            Set<IFileStore> files = this.addFiles(this.getContainerFileStore(), (IProgressMonitor)sub.newChild(100));
            if (this.isNeedFilter()) {
                SDocMLFileIndexingFilterManager.getInstance().clearCache();
            }
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            files.addAll(this.getContributedFiles(this.getContainerURI()));
            Set<String> documents = index.queryDocumentNames(null);
            sub.worked(25);
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.removeDeletedFiles(index, documents, files, (IProgressMonitor)sub.newChild(75));
            if (CollectionsUtil.isEmpty(files)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            long timestamp = 0L;
            if (!CollectionsUtil.isEmpty(documents)) {
                timestamp = index.getIndexFile().lastModified();
            }
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                files = this.filterFilesByTimestamp(timestamp, files);
                sub.worked(50);
                if (!CollectionsUtil.isEmpty(files)) {
                    this.indexFileStores(index, files, (IProgressMonitor)sub.newChild(750));
                }
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            try {
                index.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)"An error occurred while saving an index", (Throwable)e);
            }
            sub.done();
        }
        return Status.OK_STATUS;
    }

    protected IFileStore getContainerFileStore() throws CoreException {
        return EFS.getStore((URI)this.getContainerURI());
    }

    /*
     * Unable to fully structure code
     */
    private Set<IFileStore> addFiles(IFileStore file, IProgressMonitor monitor) {
        block17: {
            sub = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            files = new HashSet<IFileStore>();
            try {
                block16: {
                    if (file == null) {
                        var12_5 = files;
                        return var12_5;
                    }
                    info = file.fetchInfo(0, (IProgressMonitor)sub.newChild(1));
                    if (!info.exists()) {
                        var12_6 = files;
                        return var12_6;
                    }
                    if (!info.isDirectory()) ** GOTO lbl33
                    fileList = file.childStores(0, (IProgressMonitor)sub.newChild(2));
                    if (!ArrayUtil.isEmpty((Object[])fileList)) break block16;
                    var12_7 = files;
                    return var12_7;
                }
                try {
                    try {
                        var10_13 = fileList;
                        var9_14 = fileList.length;
                        var8_15 = 0;
                        while (var8_15 < var9_14) {
                            child = var10_13[var8_15];
                            files.addAll(this.addFiles((IFileStore)child, (IProgressMonitor)sub.newChild(7)));
                            ++var8_15;
                        }
                        break block17;
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    }
                    break block17;
lbl33:
                    // 1 sources

                    if (this.isNeedFilter()) {
                        isRemove = SDocMLFileIndexingFilterManager.getInstance().filterFile(file, this.getProject());
                        if (!isRemove) {
                            files.add(file);
                        }
                        break block17;
                    }
                    files.add(file);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                }
            }
            finally {
                sub.done();
            }
        }
        return files;
    }

    private void removeDeletedFiles(Index index, Set<String> documents, Set<IFileStore> files, IProgressMonitor monitor) {
        if (CollectionsUtil.isEmpty(documents)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(files.size() + documents.size()));
        List fileStoreURIs = CollectionsUtil.map(files, (IMap)new IMap<IFileStore, String>(){

            public String map(IFileStore item) {
                return item.toURI().toString();
            }
        });
        HashSet uris = new HashSet(fileStoreURIs);
        sub.worked(files.size());
        for (String docName : documents) {
            if (!uris.contains(docName)) {
                index.remove(URI.create(docName));
            }
            sub.worked(1);
        }
        sub.done();
    }

    protected Set<IFileStore> filterFilesByTimestamp(final long indexLastModified, Set<IFileStore> files) {
        HashSet<IFileStore> filtered = new HashSet<IFileStore>(files.size());
        CollectionsUtil.filter(files, filtered, (IFilter)new IFilter<IFileStore>(){

            public boolean include(IFileStore item) {
                return item.fetchInfo().getLastModified() >= indexLastModified;
            }
        });
        return filtered;
    }

    @Override
    protected BuildContextType getBuildContextType() {
        return BuildContextType.ALL;
    }
}

