/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.vsdoc.parsing;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.MetadataReader;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.ExampleTag;
import com.aptana.editor.js.sdoc.model.ExceptionTag;
import com.aptana.editor.js.sdoc.model.ParamTag;
import com.aptana.editor.js.sdoc.model.Parameter;
import com.aptana.editor.js.sdoc.model.PrivateTag;
import com.aptana.editor.js.sdoc.model.ReturnTag;
import com.aptana.editor.js.sdoc.model.SeeTag;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.model.Usage;
import com.aptana.editor.js.sdoc.model.UserAgent;
import com.aptana.editor.js.sdoc.parsing.SDocParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VSDocReader
extends MetadataReader {
    private static final String METADATA_SCHEMA_XML = "/metadata/VSDocSchema.xml";
    private String _summary;
    private List<Tag> _tags;
    private List<Type> _exceptionTypes;
    private Parameter _currentParameter;
    private List<Type> _currentTypes;
    private DocumentationBlock _block;
    private SDocParser _typeParser = new SDocParser();

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        super.startElement(namespaceURI, localName, qualifiedName, attributes);
        switch (Element.fromString(localName)) {
            case DOCS: {
                this.enterDocs(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case EXCEPTION: {
                this.enterException(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PARA: {
                this.enterPara(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PARAM: {
                this.enterParam(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case RETURNS: {
                this.enterReturns(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case SEEALSO: 
            case SEE: {
                this.enterSee(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case USER_AGENT: {
                this.enterUserAgent(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case SUMMARY: 
            case PRIVATE: 
            case EXAMPLE: {
                this.startTextBuffer(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        switch (Element.fromString(localName)) {
            case DOCS: {
                this.exitDocs(namespaceURI, localName, qualifiedName);
                break;
            }
            case EXAMPLE: {
                this.exitExample(namespaceURI, localName, qualifiedName);
                break;
            }
            case EXCEPTION: {
                this.exitException(namespaceURI, localName, qualifiedName);
                break;
            }
            case PARAM: {
                this.exitParam(namespaceURI, localName, qualifiedName);
                break;
            }
            case PRIVATE: {
                this.exitPrivate(namespaceURI, localName, qualifiedName);
                break;
            }
            case RETURNS: {
                this.exitReturns(namespaceURI, localName, qualifiedName);
                break;
            }
            case SUMMARY: {
                this.exitSummary(namespaceURI, localName, qualifiedName);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
        super.endElement(namespaceURI, localName, qualifiedName);
    }

    public void enterDocs(String ns, String name, String qname, Attributes attributes) {
        this._tags = new ArrayList<Tag>();
    }

    public void enterException(String ns, String name, String qname, Attributes attributes) {
        this._exceptionTypes = this.parseTypes(attributes.getValue("cref"));
        this.startTextBuffer();
    }

    public void enterPara(String ns, String name, String qname, Attributes attributes) {
        if (this.isBufferingText()) {
            String text = String.valueOf(this.getText()) + "&x0A;";
            this.startTextBuffer();
            this.characters(text.toCharArray(), 0, text.length());
        }
    }

    public void enterParam(String ns, String name, String qname, Attributes attributes) {
        String parameterName = attributes.getValue("name");
        boolean optional = Boolean.parseBoolean(attributes.getValue("optional"));
        boolean parameterArray = Boolean.parseBoolean(attributes.getValue("parameterArray"));
        Usage usage = optional ? (parameterArray ? Usage.ZERO_OR_MORE : Usage.OPTIONAL) : (parameterArray ? Usage.ONE_OR_MORE : Usage.REQUIRED);
        this._currentParameter = new Parameter(parameterName);
        this._currentParameter.setUsage(usage);
        this._currentTypes = this.parseTypes(attributes.getValue("type"));
        this.startTextBuffer();
    }

    public void enterReturns(String ns, String name, String qname, Attributes attributes) {
        this._currentTypes = this.parseTypes(attributes.getValue("type"));
        this.startTextBuffer();
    }

    public void enterSee(String ns, String name, String qname, Attributes attributes) {
        String type = attributes.getValue("cref");
        this._tags.add(new SeeTag(type));
    }

    public void enterUserAgent(String ns, String name, String qname, Attributes attributes) {
        UserAgent ua = new UserAgent();
        String uaName = attributes.getValue("name");
        String version = attributes.getValue("version");
        ua.setName(uaName);
        ua.setVersion(version);
        this._tags.add(ua);
    }

    public void exitDocs(String ns, String name, String qname) {
        this._block = new DocumentationBlock(this._summary, this._tags);
        this._summary = null;
        this._tags = null;
    }

    public void exitExample(String ns, String name, String qname) {
        String text = this.getText();
        this._tags.add(new ExampleTag(text));
    }

    public void exitException(String ns, String name, String qname) {
        String text = this.getText();
        ArrayList<Type> types = new ArrayList<Type>();
        if (this._exceptionTypes != null) {
            types.addAll(this._exceptionTypes);
        } else {
            types.add(new Type("Object"));
        }
        this._tags.add(new ExceptionTag(types, text));
        this._exceptionTypes = null;
    }

    public void exitParam(String ns, String name, String qname) {
        String text = this.getText();
        ArrayList<Type> types = new ArrayList<Type>();
        if (this._currentTypes != null) {
            types.addAll(this._currentTypes);
        } else {
            types.add(new Type("Object"));
        }
        this._tags.add(new ParamTag(this._currentParameter, types, text));
        this._currentParameter = null;
        this._currentTypes = null;
    }

    public void exitPrivate(String ns, String name, String qname) {
        String text = this.getText();
        this._tags.add(new PrivateTag(text));
    }

    public void exitReturns(String ns, String name, String qname) {
        String text = this.getText();
        ArrayList<Type> types = new ArrayList<Type>();
        if (this._currentTypes != null) {
            types.addAll(this._currentTypes);
        } else {
            types.add(new Type("Object"));
        }
        this._tags.add(new ReturnTag(types, text));
        this._currentTypes = null;
    }

    public void exitSummary(String ns, String name, String qname) {
        this._summary = this.resolveEntities(this.getText());
    }

    public DocumentationBlock getBlock() {
        return this._block;
    }

    protected InputStream getSchemaStream() {
        try {
            return FileLocator.openStream((Bundle)JSPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)METADATA_SCHEMA_XML), (boolean)false);
        }
        catch (IOException iOException) {
            return ((Object)((Object)this)).getClass().getResourceAsStream(METADATA_SCHEMA_XML);
        }
    }

    protected String getText() {
        return this.normalizeText(super.getText());
    }

    protected List<Type> parseTypes(String types) {
        List<Type> result = Collections.emptyList();
        if (!StringUtil.isEmpty((String)types)) {
            try {
                result = this._typeParser.parseType(types);
            }
            catch (Exception exception) {
                result.add(new Type("Object"));
            }
        } else {
            result.add(new Type("Object"));
        }
        return result;
    }

    private static enum Element {
        SUMMARY("summary"),
        PRIVATE("private"),
        EXAMPLE("example"),
        USER_AGENT("userAgent"),
        SEEALSO("seealso"),
        SEE("see"),
        RETURNS("returns"),
        PARAM("param"),
        PARA("para"),
        EXCEPTION("exception"),
        DOCS("docs"),
        UNDEFINED(null);

        private String name;

        private Element(String name) {
            this.name = name;
        }

        private static Element fromString(String name) {
            if (name != null) {
                Element[] elementArray = Element.values();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element b = elementArray[n2];
                    if (name.equals(b.name)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return UNDEFINED;
        }
    }
}

