/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.views;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.ClassElement;
import com.aptana.editor.js.contentassist.model.ClassGroupElement;
import com.aptana.editor.js.contentassist.model.EventElement;
import com.aptana.editor.js.contentassist.model.JSElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.views.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class JSIndexViewContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> result = Collections.emptyList();
        if (parentElement instanceof JSElement) {
            JSElement root = (JSElement)parentElement;
            result = CollectionsUtil.newList((Object[])new ClassGroupElement[]{new ClassGroupElement(Messages.JSIndexViewContentProvider_WorkspaceGroupLabel, JSIndexQueryHelper.getIndex()), new ClassGroupElement(Messages.JSIndexViewContentProvider_ProjectGroupLabel, root.getIndex())});
        } else if (parentElement instanceof ClassGroupElement) {
            ClassGroupElement group = (ClassGroupElement)parentElement;
            result = group.getClasses();
        } else if (parentElement instanceof ClassElement) {
            ClassElement type = (ClassElement)parentElement;
            ArrayList<BaseElement> temp = new ArrayList<BaseElement>();
            temp.addAll(((TypeElement)type).getProperties());
            temp.addAll(((TypeElement)type).getEvents());
            result = temp;
        } else if (parentElement instanceof EventElement) {
            EventElement event = (EventElement)parentElement;
            result = event.getProperties();
        }
        return result.toArray(new Object[result.size()]);
    }

    public Object[] getElements(Object inputElement) {
        Object[] result;
        if (inputElement instanceof IProject) {
            IProject project = (IProject)inputElement;
            Index index = this.getIndexManager().getIndex(project.getLocationURI());
            result = new Object[]{new JSElement(index)};
        } else {
            result = new Object[]{};
        }
        return result;
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ClassGroupElement) {
            ClassGroupElement classGroup = (ClassGroupElement)element;
            return classGroup.hasChildren();
        }
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

