/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StreamUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.validator.Messages;
import com.aptana.index.core.build.BuildContext;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class JSLintValidator
extends AbstractBuildParticipant {
    public static final String JS_LINT_OPTIONS = "jsLintOptions";
    public static final String ID = "com.aptana.editor.js.validator.JSLintValidator";
    private static final String JSLINT_FILENAME = "fulljslint.js";
    private static JSLint JS_LINT_SCRIPT;
    private static ContextFactory contextFactory;

    static {
        contextFactory = new ContextFactory();
    }

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.js.jslint_problem", problems);
        context.putProblems("com.aptana.editor.js.problem", problems);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        List<Object> problems = Collections.emptyList();
        String sourcePath = context.getURI().toString();
        try {
            problems = this.parseWithLint(context.getContents(), sourcePath);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} with JSLint", sourcePath), (Throwable)e);
        }
        context.putProblems("com.aptana.editor.js.jslint_problem", problems);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.js.jslint_problem");
    }

    protected List<IProblem> parseWithLint(String source, String path) {
        JSLint script = this.getJSLintScript();
        if (script == null) {
            return Collections.emptyList();
        }
        script.runLint(source, this.getOptions());
        List<IProblem> collected = script.getProblems(source, path);
        final List filters = this.getFilters();
        return CollectionsUtil.filter(collected, (IFilter)new IFilter<IProblem>(){

            public boolean include(IProblem item) {
                return !JSLintValidator.this.isIgnored(item.getMessage(), filters);
            }
        });
    }

    private synchronized JSLint getJSLintScript() {
        URL url;
        if (JS_LINT_SCRIPT == null && (url = FileLocator.find((Bundle)JSPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)JSLINT_FILENAME), null)) != null) {
            try {
                String source = StreamUtil.readContent((InputStream)url.openStream());
                if (source != null) {
                    JS_LINT_SCRIPT = this.getJSLintScript(source);
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.JSLintValidator_ERR_FailToGetJSLint, (Throwable)e);
            }
        }
        return JS_LINT_SCRIPT;
    }

    private JSLint getJSLintScript(String source) {
        try {
            Context cx = contextFactory.enterContext();
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateString((Scriptable)scope, source, JSLINT_FILENAME, 1, null);
            JSLint jSLint = new JSLint(contextFactory, scope);
            return jSLint;
        }
        finally {
            Context.exit();
        }
    }

    protected void setJSONOptions(String optionsAsJSON) throws IllegalStateException {
        JSON.parse((String)optionsAsJSON);
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.getPreferenceNode());
        prefs.put(JS_LINT_OPTIONS, optionsAsJSON);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private Map<String, Object> getOptions() {
        return (Map)JSON.parse((String)this.getPreferenceString(JS_LINT_OPTIONS));
    }

    public void restoreDefaults() {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.getPreferenceNode());
        prefs.remove(JS_LINT_OPTIONS);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
        super.restoreDefaults();
    }

    class DefaultErrorReporter
    implements ErrorReporter {
        private List<IProblem> items = new ArrayList<IProblem>();

        public void error(String message, String sourceURI, int line, String lineText, int lineOffset) {
            this.items.add(JSLintValidator.this.createError(message, line, lineOffset, 1, sourceURI));
        }

        public void warning(String message, String sourceURI, int line, String lineText, int lineOffset) {
            this.items.add(JSLintValidator.this.createWarning(message, line, lineOffset, 1, sourceURI));
        }

        public EvaluatorException runtimeError(String message, String sourceURI, int line, String lineText, int lineOffset) {
            return new EvaluatorException(message, sourceURI, line, lineText, lineOffset);
        }

        public List<IProblem> getItems() {
            return Collections.unmodifiableList(this.items);
        }
    }

    class JSLint {
        private ContextFactory contextFactory;
        private ScriptableObject scope;

        JSLint(ContextFactory contextFactory, ScriptableObject scope) {
            this.contextFactory = contextFactory;
            this.scope = scope;
            this.scope.sealObject();
        }

        public List<IProblem> getProblems(final String source, final String path) {
            final ArrayList<IProblem> items = new ArrayList<IProblem>();
            this.contextFactory.call(new ContextAction(){

                public Object run(Context cx) {
                    Function lintFunc = (Function)JSLint.this.scope.get("JSLINT", (Scriptable)JSLint.this.scope);
                    Object errorObject = lintFunc.get("errors", (Scriptable)JSLint.this.scope);
                    if (!(errorObject instanceof NativeArray)) {
                        return null;
                    }
                    NativeArray errorArray = (NativeArray)errorObject;
                    Object[] ids = errorArray.getIds();
                    if (ArrayUtil.isEmpty((Object[])ids)) {
                        return null;
                    }
                    boolean lastIsError = false;
                    NativeObject last = (NativeObject)errorArray.get(Integer.parseInt(ids[ids.length - 1].toString()), (Scriptable)JSLint.this.scope);
                    if (last == null) {
                        lastIsError = true;
                    }
                    Document doc = null;
                    int i = 0;
                    while (i < ids.length) {
                        NativeObject object = (NativeObject)errorArray.get(Integer.parseInt(ids[i].toString()), (Scriptable)JSLint.this.scope);
                        if (object != null) {
                            int line = (int)Double.parseDouble(object.get("line", (Scriptable)JSLint.this.scope).toString());
                            String reason = object.get("reason", (Scriptable)JSLint.this.scope).toString().trim();
                            if (doc == null) {
                                doc = new Document(source);
                            }
                            int character = (int)Double.parseDouble(object.get("character", (Scriptable)JSLint.this.scope).toString());
                            try {
                                IRegion lineInfo = null;
                                try {
                                    lineInfo = doc.getLineInformation(line - 1);
                                }
                                catch (Exception exception) {
                                    lineInfo = doc.getLineInformation(--line - 2);
                                }
                                int realOffset = lineInfo.getOffset();
                                String rawLine = doc.get(realOffset, lineInfo.getLength());
                                int lineLength = rawLine.length();
                                int actual = character - 1;
                                int x = 0;
                                while (x < actual) {
                                    if (lineLength <= x) break;
                                    ++realOffset;
                                    ++x;
                                }
                                character = realOffset;
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                            if (i == ids.length - 2 && lastIsError) {
                                if (reason.startsWith("Stopping")) {
                                    IProblem lastWarning = (IProblem)items.remove(items.size() - 1);
                                    items.add(JSLintValidator.this.createError(lastWarning.getMessage(), lastWarning.getLineNumber(), lastWarning.getOffset(), 1, path));
                                } else {
                                    items.add(JSLintValidator.this.createError(reason, line, character, 1, path));
                                }
                            } else {
                                items.add(JSLintValidator.this.createWarning(reason, line, character, 1, path));
                            }
                        }
                        ++i;
                    }
                    return null;
                }
            });
            return items;
        }

        void runLint(final String source, final Map<String, Object> options) {
            this.contextFactory.call(new ContextAction(){

                public Object run(Context cx) {
                    Object[] args = new Object[]{source, JSLint.this.optionsAsJavaScriptObject(options)};
                    Function lintFunc = (Function)JSLint.this.scope.get("JSLINT", (Scriptable)JSLint.this.scope);
                    lintFunc.call(cx, (Scriptable)JSLint.this.scope, (Scriptable)JSLint.this.scope, args);
                    return null;
                }
            });
        }

        private Scriptable optionsAsJavaScriptObject(final Map<String, Object> options) {
            return (Scriptable)this.contextFactory.call(new ContextAction(){

                public Object run(Context cx) {
                    Scriptable opts = cx.newObject((Scriptable)JSLint.this.scope);
                    for (Map.Entry entry : options.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = JSLint.this.javaToJS(entry.getValue(), opts);
                        opts.put(key, opts, value);
                    }
                    return opts;
                }
            });
        }

        Object javaToJS(Object o, Scriptable scope) {
            Class<?> cls = o.getClass();
            if (cls.isArray()) {
                return new NativeArray((Object[])o);
            }
            return Context.javaToJS((Object)o, (Scriptable)scope);
        }
    }
}

