/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator.JSHint;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Text {
    private String code;
    private int lineCount = 1;
    private int[] lineOffsets = new int[200];

    public Text(String text) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        StringReader reader = new StringReader(text);
        try {
            try {
                this.read(reader);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            reader.close();
        }
    }

    public Text(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        this.read(reader);
    }

    public String getContent() {
        return this.code;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getLineOffset(int line) {
        if (line >= this.lineCount) {
            throw new IndexOutOfBoundsException("line does not exist: " + line);
        }
        return this.lineOffsets[line];
    }

    public int getLineLength(int line) {
        if (line >= this.lineCount) {
            throw new IndexOutOfBoundsException("line does not exist");
        }
        int nextOffset = line + 1 == this.lineCount ? this.code.length() : this.lineOffsets[line + 1];
        return nextOffset - this.lineOffsets[line];
    }

    private void read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] cbuf = new char[8096];
        int read = reader.read(cbuf);
        while (read != -1) {
            int i = 0;
            while (i < read) {
                if (cbuf[i] == '\n') {
                    if (this.lineCount >= this.lineOffsets.length) {
                        this.growLineOffsets();
                    }
                    this.lineOffsets[this.lineCount++] = builder.length() + i + 1;
                }
                ++i;
            }
            builder.append(cbuf, 0, read);
            read = reader.read(cbuf);
        }
        this.code = builder.toString();
    }

    private void growLineOffsets() {
        int[] newLineOffsets = new int[this.lineOffsets.length * 2];
        System.arraycopy(this.lineOffsets, 0, newLineOffsets, 0, this.lineOffsets.length);
        this.lineOffsets = newLineOffsets;
    }
}

