/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.text;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.UIUtils;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;

public class GenerateSDocHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block22: {
            IEditorPart activeEditor = UIUtils.getActiveEditor();
            if (activeEditor instanceof AbstractThemeableEditor) {
                try {
                    AbstractThemeableEditor editor = (AbstractThemeableEditor)activeEditor;
                    int offset = editor.getCaretOffset();
                    IDocument document = editor.getDocument();
                    IParseRootNode rootNode = editor.getAST();
                    IParseNode node = rootNode.getNodeAtOffset(offset);
                    if (node == null) break block22;
                    switch (node.getNodeType()) {
                        case 70: {
                            JSFunctionNode funcNode = (JSFunctionNode)node;
                            if (funcNode.getParent() instanceof JSNameValuePairNode) {
                                JSNameValuePairNode nameValueNode = (JSNameValuePairNode)funcNode.getParent();
                                this.generateSDoc(offset, document, funcNode, nameValueNode.getStartingOffset());
                                break;
                            }
                            if (funcNode.getParent() instanceof JSStatementsNode || funcNode.getParent() instanceof JSParseRootNode) {
                                this.generateSDoc(offset, document, funcNode, funcNode.getStartingOffset());
                                break;
                            }
                            if (funcNode.getParent() instanceof JSDeclarationNode) {
                                this.processDeclarationNode(offset, document, (JSDeclarationNode)funcNode.getParent());
                                break;
                            }
                            if (funcNode.getParent() instanceof JSAssignmentNode) {
                                JSAssignmentNode assignNode = (JSAssignmentNode)funcNode.getParent();
                                this.generateSDoc(offset, document, funcNode, assignNode.getStartingOffset());
                            }
                            break;
                        }
                        case 64: {
                            JSDeclarationNode declarNode;
                            IParseNode declar;
                            JSVarNode varNode = (JSVarNode)node;
                            IParseNode[] declars = varNode.getDeclarations();
                            if (declars != null && declars.length == 1 && (declar = declars[0]) instanceof JSDeclarationNode && (declarNode = (JSDeclarationNode)declar).getValue() instanceof JSFunctionNode) {
                                this.generateSDoc(offset, document, (JSFunctionNode)declarNode.getValue(), varNode.getStartingOffset());
                                break;
                            }
                            this.generateSDoc(offset, document, null, varNode.getStartingOffset());
                            break;
                        }
                        case 63: {
                            JSDeclarationNode declarNode = (JSDeclarationNode)node;
                            this.processDeclarationNode(offset, document, declarNode);
                            break;
                        }
                        case 17: 
                        case 19: {
                            if (node.getParent() instanceof JSFunctionNode) {
                                JSFunctionNode fNode = (JSFunctionNode)node.getParent();
                                this.generateSDoc(offset, document, fNode, fNode.getStartingOffset());
                                break;
                            }
                            if (node.getParent() instanceof JSNameValuePairNode) {
                                JSNameValuePairNode nameValuePairNode = (JSNameValuePairNode)node.getParent();
                                if (nameValuePairNode.getName() == node) {
                                    if (nameValuePairNode.getValue() instanceof JSFunctionNode) {
                                        JSFunctionNode fNode = (JSFunctionNode)nameValuePairNode.getValue();
                                        this.generateSDoc(offset, document, fNode, nameValuePairNode.getStartingOffset());
                                        break;
                                    }
                                    this.generateSDoc(offset, document, null, nameValuePairNode.getStartingOffset());
                                }
                            } else {
                                if (node.getParent() instanceof JSDeclarationNode) {
                                    JSDeclarationNode dNode = (JSDeclarationNode)node.getParent();
                                    this.processDeclarationNode(offset, document, dNode);
                                    break;
                                }
                                IParseNode istmNode = ((JSNode)node).getContainingStatementNode();
                                if (istmNode instanceof JSNode) {
                                    JSNode stmNode = (JSNode)istmNode;
                                    this.generateSDoc(offset, document, null, stmNode.getStartingOffset());
                                }
                            }
                            break;
                        }
                        default: {
                            IParseNode istmNode = ((JSNode)node).getContainingStatementNode();
                            if (istmNode instanceof JSNode) {
                                JSNode stmNode = (JSNode)istmNode;
                                this.generateSDoc(offset, document, null, stmNode.getStartingOffset());
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private void processDeclarationNode(int offset, IDocument document, JSDeclarationNode declarNode) throws BadLocationException {
        if (declarNode.getParent() instanceof JSVarNode) {
            JSVarNode varNode = (JSVarNode)declarNode.getParent();
            if (varNode.getDeclarations().length == 1) {
                if (declarNode.getValue() instanceof JSFunctionNode) {
                    this.generateSDoc(offset, document, (JSFunctionNode)declarNode.getValue(), varNode.getStartingOffset());
                } else {
                    this.generateSDoc(offset, document, null, varNode.getStartingOffset());
                }
            } else if (declarNode.getValue() instanceof JSFunctionNode) {
                this.generateSDoc(offset, document, (JSFunctionNode)declarNode.getValue(), declarNode.getStartingOffset());
            } else {
                this.generateSDoc(offset, document, null, declarNode.getStartingOffset());
            }
        }
    }

    private void generateSDoc(int offset, IDocument document, JSFunctionNode funcNode, int nodeStartOffset) throws BadLocationException {
        StringBuffer sb = new StringBuffer();
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IRegion lineRegion = document.getLineInformationOfOffset(offset);
        if (nodeStartOffset < lineRegion.getOffset()) {
            return;
        }
        String indent = document.get(lineRegion.getOffset(), nodeStartOffset - lineRegion.getOffset());
        if (StringUtil.isNotBlank((String)indent)) {
            indent = "";
        }
        sb.append("/**").append(lineDelimiter);
        sb.append(indent).append(" ").append("*").append(" ");
        if (funcNode != null) {
            List parameters = ParseUtil.getFunctionParameters(document, funcNode.getStartingOffset());
            if (!CollectionsUtil.isEmpty(parameters)) {
                parameters = CollectionsUtil.map(parameters, (IMap)new IMap<String, String>(){

                    public String map(String item) {
                        return "@param {Object} " + item;
                    }
                });
            }
            sb.append(StringUtil.join((String)(String.valueOf(lineDelimiter) + indent + " " + "* "), (Collection)parameters));
        }
        sb.append(lineDelimiter).append(indent).append(" ").append("*/");
        sb.append(lineDelimiter).append(indent);
        document.replace(nodeStartOffset, 0, sb.toString());
    }

    public boolean isEnabled() {
        IEditorPart activeEditor = UIUtils.getActiveEditor();
        if (activeEditor instanceof AbstractThemeableEditor) {
            AbstractThemeableEditor editor = (AbstractThemeableEditor)activeEditor;
            if (editor instanceof JSSourceEditor) {
                this.setEnabled(true);
                return true;
            }
            try {
                int offset = editor.getCaretOffset();
                ITypedRegion region = editor.getDocument().getPartition(offset);
                if (region != null && region.getType() != null && region.getType().startsWith("__js_")) {
                    this.setEnabled(true);
                    return true;
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
        }
        this.setEnabled(false);
        return false;
    }
}

