/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc.parsing;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.js.sdoc.lexer.SDocTokenType;
import com.aptana.editor.js.sdoc.parsing.WhitespaceDetector;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class SDocTokenScanner
extends RuleBasedScanner {
    public SDocTokenScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WordRule((IWordDetector)new WhitespaceDetector(), this.getToken(SDocTokenType.WHITESPACE)));
        rules.add(this.createAlternateWhitespaceRule());
        WordRule tagRules = new WordRule((IWordDetector)new TagDetector(), this.getToken(SDocTokenType.UNKNOWN));
        tagRules.addWord("@advanced", this.getToken(SDocTokenType.ADVANCED));
        tagRules.addWord("@alias", this.getToken(SDocTokenType.ALIAS));
        tagRules.addWord("@author", this.getToken(SDocTokenType.AUTHOR));
        tagRules.addWord("@classDescription", this.getToken(SDocTokenType.CLASS_DESCRIPTION));
        tagRules.addWord("@constructor", this.getToken(SDocTokenType.CONSTRUCTOR));
        tagRules.addWord("@example", this.getToken(SDocTokenType.EXAMPLE));
        tagRules.addWord("@exception", this.getToken(SDocTokenType.EXCEPTION));
        tagRules.addWord("@extends", this.getToken(SDocTokenType.EXTENDS));
        tagRules.addWord("@internal", this.getToken(SDocTokenType.INTERNAL));
        tagRules.addWord("@method", this.getToken(SDocTokenType.METHOD));
        tagRules.addWord("@module", this.getToken(SDocTokenType.MODULE));
        tagRules.addWord("@namespace", this.getToken(SDocTokenType.NAMESPACE));
        tagRules.addWord("@overview", this.getToken(SDocTokenType.OVERVIEW));
        tagRules.addWord("@param", this.getToken(SDocTokenType.PARAM));
        tagRules.addWord("@private", this.getToken(SDocTokenType.PRIVATE));
        tagRules.addWord("@property", this.getToken(SDocTokenType.PROPERTY));
        tagRules.addWord("@return", this.getToken(SDocTokenType.RETURN));
        tagRules.addWord("@see", this.getToken(SDocTokenType.SEE));
        tagRules.addWord("@type", this.getToken(SDocTokenType.TYPE));
        rules.add(tagRules);
        CharacterMapRule cmRule = new CharacterMapRule();
        cmRule.add('#', this.getToken(SDocTokenType.POUND));
        cmRule.add('[', this.getToken(SDocTokenType.LBRACKET));
        cmRule.add(']', this.getToken(SDocTokenType.RBRACKET));
        cmRule.add('\r', this.getToken(SDocTokenType.WHITESPACE));
        cmRule.add('\n', this.getToken(SDocTokenType.WHITESPACE));
        rules.add(cmRule);
        rules.add(new PatternRule("{", "}", this.getToken(SDocTokenType.TYPES), '\u0000', false));
        WordRule operatorRules = new WordRule((IWordDetector)new OperatorDetector(), this.getToken(SDocTokenType.UNKNOWN));
        operatorRules.addWord("/**", this.getToken(SDocTokenType.START_DOCUMENTATION));
        operatorRules.addWord("*/", this.getToken(SDocTokenType.END_DOCUMENTATION));
        rules.add(operatorRules);
        rules.add(new WordRule((IWordDetector)new TextDetector(), this.getToken(SDocTokenType.TEXT)));
        this.setDefaultReturnToken(this.getToken(SDocTokenType.ERROR));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    protected IRule createAlternateWhitespaceRule() {
        return new ExtendedWordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return this.isWordPart(c);
            }

            public boolean isWordPart(char c) {
                return c == ' ' || c == '\t' || c == '*';
            }
        }, this.getToken(SDocTokenType.WHITESPACE), false){
            private final Pattern PATTERN;
            {
                this.PATTERN = Pattern.compile("^[ \\t]*\\*(?!/)[ \\t]*");
            }

            protected boolean wordOK(String word, ICharacterScanner scanner) {
                char c = (char)scanner.read();
                scanner.unread();
                if (word != null && word.length() > 0 & word.charAt(word.length() - 1) == '*' && c == '/') {
                    return false;
                }
                Matcher m = this.PATTERN.matcher(word);
                return m.matches();
            }
        };
    }

    protected IToken getToken(SDocTokenType type) {
        return new Token((Object)type);
    }

    static class OperatorDetector
    implements IWordDetector {
        private int fPosition;

        OperatorDetector() {
        }

        public boolean isWordPart(char c) {
            boolean result = false;
            ++this.fPosition;
            if (this.fPosition == 1) {
                switch (c) {
                    case '*': 
                    case '/': {
                        result = true;
                    }
                }
            } else if (this.fPosition == 2) {
                switch (c) {
                    case '*': {
                        result = true;
                    }
                }
            }
            return result;
        }

        public boolean isWordStart(char c) {
            boolean result = false;
            this.fPosition = 0;
            switch (c) {
                case '*': 
                case '/': {
                    result = true;
                }
            }
            return result;
        }
    }

    static class TagDetector
    implements IWordDetector {
        TagDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }

    static class TextDetector
    implements IWordDetector {
        TextDetector() {
        }

        public boolean isWordPart(char c) {
            boolean result = true;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '#': 
                case '[': 
                case ']': 
                case '{': {
                    result = false;
                }
            }
            return result;
        }

        public boolean isWordStart(char c) {
            return this.isWordPart(c);
        }
    }
}

