/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.js.sdoc.lexer.SDocTokenType;
import com.aptana.editor.js.sdoc.parsing.SDocTokenScanner;
import com.aptana.editor.js.sdoc.parsing.SDocTypeTokenScanner;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SDocScanner
extends Scanner {
    private SDocTokenScanner fTokenScanner = new SDocTokenScanner();
    private SDocTypeTokenScanner fTypeTokenScanner = new SDocTypeTokenScanner();
    private IDocument fDocument;
    private Queue<Symbol> fQueue = new LinkedList<Symbol>();
    private int fOffset;

    public void advance(int count) {
        int i = 0;
        while (i < count) {
            this.fTokenScanner.read();
            ++i;
        }
    }

    public Symbol nextToken() throws Scanner.Exception {
        Symbol result;
        if (this.fQueue.size() > 0) {
            result = this.fQueue.poll();
        } else {
            SDocTokenType type;
            IToken token = this.fTokenScanner.nextToken();
            Object data = token.getData();
            while (data == SDocTokenType.WHITESPACE) {
                token = this.fTokenScanner.nextToken();
                data = token.getData();
            }
            int offset = this.fTokenScanner.getTokenOffset();
            int length = this.fTokenScanner.getTokenLength();
            SDocTokenType sDocTokenType = type = data == null ? SDocTokenType.EOF : (SDocTokenType)((Object)data);
            if (type == SDocTokenType.TYPES) {
                this.queueTypeTokens(offset, length);
                result = this.fQueue.poll();
            } else {
                try {
                    int totalLength = this.fDocument.getLength();
                    if (offset > totalLength) {
                        offset = totalLength;
                    }
                    if (length == -1) {
                        length = 0;
                    }
                    result = new Symbol(type.getIndex(), offset + this.fOffset, offset + this.fOffset + length - 1, (Object)this.fDocument.get(offset, length));
                }
                catch (BadLocationException e) {
                    throw new Scanner.Exception(e.getLocalizedMessage());
                }
            }
        }
        return result;
    }

    public void queueTypeTokens(int typesOffset, int typesLength) throws Scanner.Exception {
        this.fTypeTokenScanner.setRange(this.fDocument, typesOffset, typesLength);
        IToken token = this.fTypeTokenScanner.nextToken();
        while (token != Token.EOF) {
            Object data = token.getData();
            while (data == SDocTokenType.WHITESPACE) {
                token = this.fTypeTokenScanner.nextToken();
                data = token.getData();
            }
            int offset = this.fTypeTokenScanner.getTokenOffset();
            int length = this.fTypeTokenScanner.getTokenLength();
            SDocTokenType type = data == null ? SDocTokenType.EOF : (SDocTokenType)((Object)data);
            try {
                Symbol symbol = new Symbol(type.getIndex(), offset + this.fOffset, offset + this.fOffset + length - 1, (Object)this.fDocument.get(offset, length));
                this.fQueue.offer(symbol);
                token = this.fTypeTokenScanner.nextToken();
            }
            catch (BadLocationException e) {
                throw new Scanner.Exception(e.getLocalizedMessage());
            }
        }
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public void setSource(IDocument document) {
        this.fDocument = document;
        this.fTokenScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
    }

    public void setSource(String text) {
        this.setSource((IDocument)new Document(text));
    }
}

