/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc.model;

import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.sdoc.model.Parameter;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.editor.js.sdoc.model.TagWithTypes;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.model.Usage;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamTag
extends TagWithTypes {
    private Parameter _parameter;
    private static Pattern valuePattern = Pattern.compile("[\\s]*[=]{0,1}[\\s]*([a-zA-Z_0-9|]+)");

    public ParamTag(Parameter parameter, List<Type> types, String text) {
        super(TagType.PARAM, types, text);
        this._parameter = parameter;
        if (parameter != null) {
            this.matchValues(parameter, text);
        }
    }

    private void matchValues(Parameter parameter, String text) {
        String values;
        Matcher matcher;
        if (StringUtil.isNotEmpty((String)text) && (matcher = valuePattern.matcher(text)).find() && StringUtil.isNotEmpty((String)(values = matcher.group(1)))) {
            String[] valueArr;
            String[] stringArray = valueArr = values.split("\\|");
            int n = valueArr.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                parameter.addValue(value);
                ++n2;
            }
            this.setText(text.substring(matcher.end()));
        }
    }

    public Parameter getParameter() {
        return this._parameter;
    }

    public String getName() {
        String result = "";
        if (this._parameter != null) {
            result = this._parameter.getName();
        }
        return result;
    }

    public Usage getUsage() {
        Usage result = Usage.UNKNOWN;
        if (this._parameter != null) {
            result = this._parameter.getUsage();
        }
        return result;
    }

    @Override
    public void toSource(SourcePrinter writer) {
        String text;
        writer.print(this.getType().toString());
        boolean first = true;
        writer.print(" {");
        for (Type type : this.getTypes()) {
            if (!first) {
                writer.print(',');
            } else {
                first = false;
            }
            type.toSource(writer);
        }
        writer.print("} ");
        if (this._parameter != null) {
            this._parameter.toSource(writer);
        }
        if ((text = this.getText()) != null && !StringUtil.isEmpty((String)text)) {
            writer.println();
            writer.printIndent().print("    ").print(text);
        }
    }
}

