/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc.lexer;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum SDocTokenType {
    UNDEFINED(-1),
    EOF(0),
    IDENTIFIER(1),
    RCURLY(3),
    LCURLY(2),
    RBRACKET(4),
    LBRACKET(5),
    COLON(6),
    TEXT(7),
    POUND(8),
    ERROR(10),
    FUNCTION(11),
    ARRAY(12),
    CLASS(13),
    COMMA(14),
    PIPE(15),
    RPAREN(16),
    LPAREN(17),
    CLASS_DESCRIPTION(18),
    EXCEPTION(19),
    EXTENDS(20),
    NAMESPACE(23),
    PARAM(24),
    PROPERTY(25),
    RETURN(26),
    TYPE(28),
    ADVANCED(29),
    ALIAS(30),
    AUTHOR(31),
    CONSTRUCTOR(33),
    EXAMPLE(34),
    INTERNAL(35),
    METHOD(36),
    MODULE(37),
    OVERVIEW(38),
    PRIVATE(39),
    SEE(40),
    UNKNOWN(41),
    END_DOCUMENTATION(44),
    ARROW(45),
    LESS_THAN(42),
    GREATER_THAN(43),
    ELLIPSIS(46),
    START_DOCUMENTATION(47),
    WHITESPACE(1024),
    TYPES(1025),
    VALUE(1026),
    DESCRIPTION(32),
    MEMBEROF(21),
    INHERITS(22),
    RETURNS(27),
    EQUALS(9);

    private static Map<Short, SDocTokenType> ID_MAP;
    private short _index;

    static {
        ID_MAP = new HashMap<Short, SDocTokenType>();
        for (SDocTokenType type : EnumSet.allOf(SDocTokenType.class)) {
            ID_MAP.put(type.getIndex(), type);
        }
    }

    private SDocTokenType(short beaverId) {
        this._index = beaverId;
    }

    private SDocTokenType(int index) {
        this((short)index);
    }

    public static SDocTokenType get(short id) {
        SDocTokenType result = UNDEFINED;
        if (ID_MAP.containsKey(id)) {
            result = ID_MAP.get(id);
        }
        return result;
    }

    public short getIndex() {
        return this._index;
    }
}

