/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.ExampleTag;
import com.aptana.editor.js.sdoc.model.ParamTag;
import com.aptana.editor.js.sdoc.model.ReturnTag;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.model.UnknownTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSDocUtils {
    public static final String NEW_LINE = "<br>";

    public static String getFormatDocument(JSNode jsNode) {
        JSFunctionNode funcNode;
        DocumentationBlock jsDoc;
        StringBuffer sb = new StringBuffer();
        if (jsNode instanceof JSFunctionNode && (jsDoc = (funcNode = (JSFunctionNode)jsNode).getDocumentation()) != null) {
            String header = JSDocUtils.getHeader(jsNode, jsDoc);
            sb.append(header);
            String descBody = JSDocUtils.getDescBody(jsNode, jsDoc);
            sb.append(descBody);
            String paramBody = JSDocUtils.getParamBody(jsNode, jsDoc);
            sb.append(paramBody);
            String returnBody = JSDocUtils.getReturnBody(jsNode, jsDoc);
            sb.append(returnBody);
            String exampleBody = JSDocUtils.getExampleBody(jsNode, jsDoc);
            sb.append(exampleBody);
            String footer = JSDocUtils.getFooter(jsNode, jsDoc);
            sb.append(footer);
        }
        return sb.toString();
    }

    private static String getExampleBody(JSNode jsNode, DocumentationBlock jsDoc) {
        StringBuffer sb = new StringBuffer();
        List<Tag> exampleTags = jsDoc.getTags(TagType.EXAMPLE);
        if (exampleTags != null && !exampleTags.isEmpty()) {
            for (Tag tag : exampleTags) {
                ExampleTag exampleTag = (ExampleTag)tag;
                sb.append(NEW_LINE);
                sb.append("<b>" + (Object)((Object)exampleTag.getType()) + "</b>" + " " + NEW_LINE + exampleTag.getText());
            }
        }
        return sb.toString();
    }

    private static String getReturnBody(JSNode jsNode, DocumentationBlock jsDoc) {
        StringBuffer sb = new StringBuffer();
        List<Tag> returnTags = jsDoc.getTags(TagType.RETURN);
        if (returnTags != null && !returnTags.isEmpty()) {
            for (Tag tag : returnTags) {
                sb.append(NEW_LINE);
                ReturnTag returnTag = (ReturnTag)tag;
                sb.append("<b>" + (Object)((Object)returnTag.getType()) + "</b>" + " " + StringUtil.avoidNull((String)returnTag.getText()));
            }
        }
        return sb.toString();
    }

    private static String getFooter(JSNode jsNode, DocumentationBlock jsDoc) {
        StringBuffer sb = new StringBuffer();
        sb.append(NEW_LINE);
        sb.append("<b>Supported Platforms</b> <br>");
        List<Tag> unknownTags = jsDoc.getTags(TagType.UNKNOWN);
        boolean hasUserAgent = false;
        if (unknownTags != null && !unknownTags.isEmpty()) {
            for (Tag tag : unknownTags) {
                UnknownTag unknownTag = (UnknownTag)tag;
                if (!TagType.USER_AGENT.toString().equals(unknownTag.getName())) continue;
                sb.append(unknownTag.getText());
                hasUserAgent = true;
                break;
            }
        }
        if (!hasUserAgent) {
            sb.append("No browser available.");
        }
        return sb.toString();
    }

    private static String getDescBody(JSNode jsNode, DocumentationBlock jsDoc) {
        StringBuffer sb = new StringBuffer();
        sb.append(NEW_LINE);
        if (StringUtil.isNotEmpty((String)jsDoc.getText())) {
            sb.append(jsDoc.getText());
        } else {
            sb.append("No description available.");
        }
        return sb.toString();
    }

    private static String getParamBody(JSNode jsNode, DocumentationBlock jsDoc) {
        StringBuffer sb = new StringBuffer();
        List<Tag> paramTags = jsDoc.getTags(TagType.PARAM);
        if (paramTags != null && !paramTags.isEmpty()) {
            for (Tag param : paramTags) {
                sb.append(NEW_LINE);
                ParamTag paramTag = (ParamTag)param;
                sb.append("<b>" + (Object)((Object)paramTag.getType()) + "</b>" + " " + paramTag.getName() + " " + StringUtil.avoidNull((String)paramTag.getText()));
            }
        }
        return sb.toString();
    }

    private static String getHeader(JSNode jsNode, DocumentationBlock jsDoc) {
        StringBuffer sb = new StringBuffer();
        sb.append("<b>");
        sb.append(jsNode.getText());
        sb.append("(");
        List<Tag> paramTags = jsDoc.getTags(TagType.PARAM);
        for (Tag param : paramTags) {
            ParamTag paramTag = (ParamTag)param;
            sb.append(String.valueOf(paramTag.getName()) + ":");
            List<Type> types = paramTag.getTypes();
            if (types == null || types.isEmpty()) {
                sb.append("unknow");
            } else {
                for (Type type : types) {
                    sb.append(type.getName());
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(",");
        }
        if (paramTags != null && !paramTags.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("):");
        List<Tag> returnTags = jsDoc.getTags(TagType.RETURN);
        if (returnTags != null && !returnTags.isEmpty()) {
            for (Tag tag : returnTags) {
                ReturnTag returnTag = (ReturnTag)tag;
                List<Type> types = returnTag.getTypes();
                if (types == null || types.isEmpty()) {
                    sb.append("unknow");
                    continue;
                }
                for (Type type : types) {
                    sb.append(type.getName());
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
        } else {
            sb.append("unknow");
        }
        sb.append("</b>");
        return sb.toString();
    }

    public static Map<String, String> getUserAgentNames(DocumentationBlock jsDoc) {
        if (jsDoc == null) {
            return null;
        }
        HashMap<String, String> userAgents = new HashMap<String, String>();
        List<Tag> unknownTags = jsDoc.getTags(TagType.UNKNOWN);
        boolean hasUserAgent = false;
        if (unknownTags != null && !unknownTags.isEmpty()) {
            for (Tag tag : unknownTags) {
                String[] userAgentsArr;
                UnknownTag unknownTag = (UnknownTag)tag;
                if (!TagType.USER_AGENT.toString().equals(unknownTag.getName())) continue;
                String userAgentsText = unknownTag.getText();
                String[] stringArray = userAgentsArr = userAgentsText.split(",");
                int n = userAgentsArr.length;
                int n2 = 0;
                while (n2 < n) {
                    String userAgent = stringArray[n2];
                    String[] agents = userAgent.split(":");
                    if (agents.length == 2) {
                        userAgents.put(agents[0], agents[1]);
                    }
                    ++n2;
                }
                hasUserAgent = true;
                break;
            }
        }
        if (!hasUserAgent) {
            return null;
        }
        return userAgents;
    }
}

