/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JSDoc3MetadataGenerator {
    public static void main(String[] args) throws Exception {
        SDoc sdoc = new SDoc();
        String baseUri = "http://usejsdoc.org/";
        sdoc.setName("JSDoc 3");
        sdoc.setUrl(baseUri);
        Document document = Jsoup.connect((String)baseUri).get();
        Element tags = document.select("#tag-dictionary").first().nextElementSibling();
        Elements children = tags.children();
        int i = 0;
        while (i < children.size()) {
            String synonyms;
            String synonymsTags;
            String[] tagss;
            DocTag docTag = new DocTag();
            Element dt = children.get(i);
            Element aTag = dt.getElementsByTag("a").first();
            docTag.setName(aTag.text());
            docTag.setSee(String.valueOf(baseUri) + aTag.attr("href"));
            Element tagPage = Jsoup.connect((String)(String.valueOf(baseUri) + aTag.attr("href"))).get().getElementById("syntax");
            if (tagPage != null) {
                Element nextElement = tagPage.nextElementSibling();
                Elements els = new Elements();
                while (!nextElement.hasAttr("id")) {
                    els.add(nextElement);
                    nextElement = nextElement.nextElementSibling();
                }
                if (els.isEmpty()) {
                    docTag.setSyntax(aTag.text());
                } else {
                    docTag.setSyntax(els.html());
                }
            } else {
                docTag.setSyntax(aTag.text());
            }
            if (aTag.nextSibling() != null && (tagss = (synonymsTags = (synonyms = aTag.nextSibling().outerHtml()).substring(synonyms.indexOf("@"), synonyms.length() - 1)).split(",")) != null) {
                int j = 0;
                while (j < tagss.length) {
                    tagss[j] = tagss[j].trim();
                    ++j;
                }
                docTag.setSynonyms(tagss);
            }
            Element dd = children.get(i + 1);
            docTag.setDescription(dd.text());
            sdoc.getTags().add(docTag);
            i += 2;
        }
        Gson gson = new Gson();
        System.out.println(gson.toJson((Object)sdoc));
    }

    static class DocTag {
        private String name = null;
        private String syntax = null;
        private String description = null;
        private String see = null;
        private String[] synonyms = null;

        DocTag() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSyntax() {
            return this.syntax;
        }

        public void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getSee() {
            return this.see;
        }

        public void setSee(String see) {
            this.see = see;
        }

        public String[] getSynonyms() {
            return this.synonyms;
        }

        public void setSynonyms(String[] synonyms) {
            this.synonyms = synonyms;
        }
    }

    static class SDoc {
        private String name = null;
        private String url = null;
        private List<DocTag> tags = new ArrayList<DocTag>();

        SDoc() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public List<DocTag> getTags() {
            return this.tags;
        }

        public void setTags(List<DocTag> tags) {
            this.tags = tags;
        }
    }
}

