/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing.lexer;

import com.aptana.parsing.lexer.ITypePredicate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum JSTokenType implements ITypePredicate
{
    UNDEFINED("UNDEFINED", -1),
    EOF("EOF", 0),
    LPAREN("(", 1),
    IDENTIFIER("IDENTIFIER", 2),
    LCURLY("{", 3),
    LBRACKET("[", 4),
    PLUS_PLUS("++", 5),
    MINUS_MINUS("--", 6),
    STRING("STRING", 7),
    NUMBER("NUMBER", 8),
    MINUS("-", 9),
    PLUS("+", 10),
    FUNCTION("function", 11),
    THIS("this", 12),
    NEW("new", 13),
    NULL("null", 14),
    TRUE("true", 15),
    FALSE("false", 16),
    REGEX("REGEX", 17),
    DELETE("delete", 18),
    EXCLAMATION("!", 19),
    TILDE("~", 20),
    TYPEOF("typeof", 21),
    VOID("void", 22),
    SEMICOLON(";", 23),
    COMMA("comma", 24),
    VAR("var", 25),
    WHILE("while", 26),
    FOR("for", 28),
    DO("do", 29),
    SWITCH("switch", 30),
    IF("if", 27),
    CONTINUE("continue", 31),
    BREAK("break", 32),
    WITH("with", 33),
    RETURN("return", 34),
    THROW("throw", 35),
    TRY("try", 37),
    RPAREN(")", 38),
    ELSE("else", 39),
    RCURLY("}", 40),
    COLON(":", 41),
    RBRACKET("]", 42),
    IN("in", 43),
    EQUAL("=", 44),
    CASE("case", 45),
    DOT(".", 46),
    LESS_LESS("<<", 47),
    GREATER_GREATER(">>", 48),
    GREATER_GREATER_GREATER(">>>", 49),
    LESS("<", 50),
    GREATER(">", 51),
    LESS_EQUAL("<=", 52),
    GREATER_EQUAL(">=", 53),
    INSTANCEOF("instanceof", 54),
    EQUAL_EQUAL("==", 55),
    EXCLAMATION_EQUAL("!=", 56),
    EQUAL_EQUAL_EQUAL("===", 57),
    EXCLAMATION_EQUAL_EQUAL("!==", 58),
    AMPERSAND("&", 59),
    CARET("^", 60),
    PIPE("|", 61),
    AMPERSAND_AMPERSAND("&&", 62),
    STAR_EQUAL("*=", 63),
    FORWARD_SLASH_EQUAL("/=", 64),
    PERCENT_EQUAL("%=", 65),
    PLUS_EQUAL("+=", 66),
    MINUS_EQUAL("-=", 67),
    LESS_LESS_EQUAL("<<=", 68),
    GREATER_GREATER_EQUAL(">>=", 69),
    GREATER_GREATER_GREATER_EQUAL(">>>=", 70),
    AMPERSAND_EQUAL("&=", 71),
    CARET_EQUAL("^=", 72),
    PIPE_EQUAL("|=", 73),
    STAR("*", 74),
    FORWARD_SLASH("/", 75),
    PERCENT("%", 76),
    QUESTION("?", 77),
    PIPE_PIPE("||", 78),
    DEFAULT("default", 79),
    FINALLY("finally", 80),
    CATCH("catch", 81),
    DEBUGGER("debugger", 36),
    SINGLELINE_COMMENT("SINGLELINE_COMMENT", 1024),
    MULTILINE_COMMENT("MULTILINE_COMMENT", 1025),
    SDOC("SDOC", 1026),
    VSDOC("VSDOC", 1027),
    STRING_SINGLE("STRING_SINGLE", 1028),
    STRING_DOUBLE("STRING_DOUBLE", 1029);

    private static Map<String, JSTokenType> NAME_MAP;
    private static Map<Short, JSTokenType> ID_MAP;
    private String _name;
    private short _index;

    static {
        NAME_MAP = new HashMap<String, JSTokenType>();
        ID_MAP = new HashMap<Short, JSTokenType>();
        for (JSTokenType type : EnumSet.allOf(JSTokenType.class)) {
            NAME_MAP.put(type.getName(), type);
            ID_MAP.put(type.getIndex(), type);
        }
    }

    private JSTokenType(String name, short beaverId) {
        this._name = name;
        this._index = beaverId;
    }

    private JSTokenType(String name, int index) {
        this(name, (short)index);
    }

    public static JSTokenType get(String name) {
        JSTokenType result = UNDEFINED;
        if (NAME_MAP.containsKey(name)) {
            result = NAME_MAP.get(name);
        }
        return result;
    }

    public static JSTokenType get(short id) {
        JSTokenType result = UNDEFINED;
        if (ID_MAP.containsKey(id)) {
            result = ID_MAP.get(id);
        }
        return result;
    }

    public short getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public boolean isDefined() {
        return this != UNDEFINED;
    }

    public String toString() {
        return this.getName();
    }
}

