/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing.ast;

import beaver.Symbol;
import com.aptana.core.util.ArrayUtil;
import com.aptana.editor.js.parsing.ast.IJSNodeTypes;
import com.aptana.editor.js.parsing.ast.JSFormatWalker;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.parsing.SDocParser;
import com.aptana.editor.js.vsdoc.parsing.VSDocReader;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseRootNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSNode
extends ParseNode {
    private static final int NODE_TYPE_MASK = 255;
    private static final int DOC_TYPE_MASK = 3;
    protected static final short DEFAULT_TYPE = 0;
    private static Map<Short, String> TYPE_NAME_MAP = new HashMap<Short, String>();
    private static final short PRE_DOC = 0;
    private static final short POST_DOC = 1;
    private static final byte DOC_BLOCK = 2;
    private Symbol fDoc;
    private int typeFlags = 0;
    private int fHash;

    static {
        Class<IJSNodeTypes> klass = IJSNodeTypes.class;
        Field[] fieldArray = klass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getName().toLowerCase();
            try {
                Short value = field.getShort(klass);
                TYPE_NAME_MAP.put(value, name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n2;
        }
    }

    protected JSNode() {
        this(0, new JSNode[0]);
    }

    protected JSNode(short type, JSNode ... children) {
        this.setNodeType(type);
        if (!ArrayUtil.isEmpty((Object[])children)) {
            this.setChildren((IParseNode[])children);
        }
    }

    public String getLanguage() {
        return "com.aptana.contenttype.js";
    }

    public void accept(JSTreeWalker walker) {
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof JSNode) {
            JSNode other = (JSNode)((Object)obj);
            result = this.getNodeType() == other.getNodeType() && this.getSemicolonIncluded() == other.getSemicolonIncluded() && Arrays.equals(this.getChildren(), other.getChildren());
        }
        return result;
    }

    public IParseNode getContainingStatementNode2() {
        JSNode result = this;
        IParseNode parent = result.getParent();
        while (parent != null) {
            if (parent instanceof ParseRootNode || parent.getNodeType() == 21) {
                result = parent;
                break;
            }
            result = parent;
            parent = parent.getParent();
        }
        return result;
    }

    public IParseNode getContainingStatementNode() {
        JSNode result = this;
        IParseNode parent = result.getParent();
        while (parent != null) {
            if (parent instanceof ParseRootNode || parent.getNodeType() == 21 || parent.getNodeType() == 83) break;
            result = parent;
            parent = parent.getParent();
        }
        return result;
    }

    public DocumentationBlock getDocumentation() {
        if (this.fDoc == null) {
            return null;
        }
        short docType = this.getDocType();
        if (docType != 2) {
            if (docType == 0) {
                this.updateDocumentationFromSDoc(this.fDoc);
            } else {
                this.updateDocumentationFromVSDoc(this.fDoc);
            }
        }
        if (this.fDoc instanceof DocumentationBlock) {
            return (DocumentationBlock)this.fDoc;
        }
        return null;
    }

    private void updateDocumentationFromVSDoc(Symbol doc) {
        block16: {
            VSDocReader parser = new VSDocReader();
            ByteArrayInputStream input = null;
            try {
                try {
                    List lines = (List)doc.value;
                    String source = this.buildVSDocXML(lines);
                    input = new ByteArrayInputStream(source.getBytes());
                    parser.loadXML(input);
                    DocumentationBlock result = parser.getBlock();
                    if (result != null) {
                        if (lines.size() > 0) {
                            result.setRange(((Symbol)lines.get(0)).getStart(), ((Symbol)lines.get(lines.size() - 1)).getEnd());
                        }
                        this.setDocumentation(result);
                    }
                }
                catch (Exception exception) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void updateDocumentationFromSDoc(Symbol comment) {
        SDocParser parser = new SDocParser();
        try {
            Object result = parser.parse((String)comment.value, comment.getStart());
            if (result instanceof DocumentationBlock) {
                this.setDocumentation((DocumentationBlock)((Object)result));
            }
        }
        catch (Exception exception) {}
    }

    private String buildVSDocXML(List<Symbol> lines) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<docs>\n");
        for (Symbol line : lines) {
            String text = (String)line.value;
            buffer.append(text.substring(3));
        }
        buffer.append("</docs>");
        return buffer.toString();
    }

    public String getElementName() {
        String result = TYPE_NAME_MAP.get(this.getNodeType());
        return result == null ? super.getElementName() : result;
    }

    public short getNodeType() {
        return (short)(this.typeFlags >>> 3 & 0xFF);
    }

    public short getDocType() {
        return (short)(this.typeFlags >>> 1 & 3);
    }

    public boolean getSemicolonIncluded() {
        return (this.typeFlags & 1) == 1;
    }

    public int hashCode() {
        if (this.fHash == -1) {
            int hash = this.getNodeType();
            hash = 31 * hash + (this.getSemicolonIncluded() ? 1 : 0);
            this.fHash = hash = 31 * hash + Arrays.hashCode(this.getChildren());
        }
        return this.fHash;
    }

    public void addChild(IParseNode child) {
        super.addChild(child);
        this.fHash = -1;
    }

    public void setChildren(IParseNode[] children) {
        super.setChildren(children);
        this.fHash = -1;
    }

    public void replaceChild(int index, IParseNode child) throws IndexOutOfBoundsException {
        super.replaceChild(index, child);
        this.fHash = -1;
    }

    public void trimToSize() {
        super.trimToSize();
        this.fHash = -1;
    }

    public boolean isEmpty() {
        return this.getNodeType() == 0;
    }

    public void setPreDocumentation(Symbol comment) {
        this.fDoc = comment;
        this.setDocType((short)0);
    }

    public void setPostDocumentation(Symbol comment) {
        this.fDoc = comment;
        this.setDocType((short)1);
    }

    public void setDocumentation(DocumentationBlock block) {
        this.fDoc = block;
        this.setDocType((short)2);
    }

    private void setDocType(short docBlock) {
        this.typeFlags |= (docBlock & 3) << 1;
    }

    protected void setNodeType(short type) {
        this.typeFlags |= type << 3;
        this.fHash = -1;
    }

    public void setSemicolonIncluded(boolean included) {
        this.typeFlags |= included ? 1 : 0;
        this.fHash = -1;
    }

    public String toString() {
        JSFormatWalker walker = new JSFormatWalker();
        this.accept(walker);
        return walker.getText();
    }
}

