/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing.ast;

import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.editor.js.sdoc.model.TagWithTypes;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseNodeAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class JSFunctionNode
extends JSNode {
    private List<String> fReturnTypes;

    public JSFunctionNode(JSNode ... children) {
        super((short)70, children);
    }

    @Override
    public void accept(JSTreeWalker walker) {
        walker.visit(this);
    }

    public IParseNodeAttribute[] getAttributes() {
        String name = this.getName().getText();
        if (name != null && name.length() > 0) {
            return new IParseNodeAttribute[]{new ParseNodeAttribute((IParseNode)this, "name", name)};
        }
        return ParseNode.NO_ATTRIBUTES;
    }

    public IParseNode getBody() {
        return this.getChild(2);
    }

    public IParseNode getName() {
        return this.getChild(0);
    }

    public IParseNode getParameters() {
        return this.getChild(1);
    }

    public List<JSReturnNode> getReturnNodes() {
        ArrayList<JSReturnNode> result = new ArrayList<JSReturnNode>();
        LinkedList<IParseNode> queue = new LinkedList<IParseNode>();
        queue.add(this.getBody());
        while (queue.size() > 0) {
            IParseNode current = (IParseNode)queue.poll();
            if (current instanceof JSReturnNode) {
                result.add((JSReturnNode)current);
                continue;
            }
            if (current instanceof JSFunctionNode) continue;
            for (IParseNode child : current) {
                queue.offer(child);
            }
        }
        return result;
    }

    public List<String> getReturnTypes() {
        if (this.fReturnTypes == null) {
            this.fReturnTypes = new LinkedList<String>();
            DocumentationBlock docs = this.getDocumentation();
            if (docs != null && docs.hasTags()) {
                for (Tag tag : docs.getTags()) {
                    if (tag.getType() != TagType.RETURN) continue;
                    TagWithTypes tagWithTypes = (TagWithTypes)tag;
                    for (Type type : tagWithTypes.getTypes()) {
                        this.fReturnTypes.add(type.getName());
                    }
                }
            }
        }
        return this.fReturnTypes;
    }

    public String getText() {
        return this.getName().getText();
    }
}

