/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.parsing.JSInsertionRecoveryStrategy;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBreakNode;
import com.aptana.editor.js.parsing.ast.JSCaseNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSCommaNode;
import com.aptana.editor.js.parsing.ast.JSCommentNode;
import com.aptana.editor.js.parsing.ast.JSConditionalNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSContinueNode;
import com.aptana.editor.js.parsing.ast.JSDebuggerNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSDefaultNode;
import com.aptana.editor.js.parsing.ast.JSDoNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSElisionNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSErrorNode;
import com.aptana.editor.js.parsing.ast.JSFalseNode;
import com.aptana.editor.js.parsing.ast.JSFinallyNode;
import com.aptana.editor.js.parsing.ast.JSForInNode;
import com.aptana.editor.js.parsing.ast.JSForNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSIfNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSLabelledNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSNullNode;
import com.aptana.editor.js.parsing.ast.JSNumberNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSRegexNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSSwitchNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSThrowNode;
import com.aptana.editor.js.parsing.ast.JSTrueNode;
import com.aptana.editor.js.parsing.ast.JSTryNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.editor.js.parsing.ast.JSWhileNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.editor.js.parsing.lexer.JSTokenType;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.IRecoveryStrategy;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.util.ParseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JSParser
extends Parser
implements IParser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjNGUS4sNJdzdaIXBwmHMEVhG31B6XW3HHGK5HKUbDHB428g2YW81AUMa25gJtAjARYegeMB5ZxxsyLh3jVF$TVUwokGkvIx9SyFqs#StEF6tc$ypJvhdSvOXg3#Kd#2owYgxcddG5NMf8r83QqcLqCLr2f$ETD8$Ee5owZsRpR1f5jz2jT1llvSVvChw4kt1dFezpE8rFvOPyBhVdDdmIxwSrj9OFyFFy0ZrC6$bbVeKFqXP#ZHjm3#xE5UXHAaLFyhFy7B$8BmKHy1oUo$Vn$Vm0B#29F9R7vMCgHUTQcBIJoKT#1n04#Et22ABn0UsB4q5fVgT87qom#I23pxGmSMigJnM0u9Ku4MJn5t7wuCqu4MJpTqNwO1vyC9ccq5Jw3qsZwLGrA0F1bt4YgCu$nUc3R#94aCE$5kc3#GLyKCVk0xuwJWJr#71yFk3huaHGdlygqWVBJHyecrepgXJYWnlZHD2SzUBvW1g5#60cpQ9xiJRtyl3u46YdQ9w8FhWx8fgwG30oJX#SfoN7v8FxwG5wa3e2mMtnxaYQFu8F9XM1fJOGt17lZgILZju7D8FkeP4qa2e3mUeuvy69Mbhi2BWT4AoB4q6kbXx7MkWE11lZ78MUMkMZpeCfHVgY5X1iZXD13wrgpADGXQe2mOuu4GpNQiMAWC$1kRQN7uqF0PVIwkKXeEJyKV27FHbsXjaHaiXxT0JKrq10wsWzRJ0Gq2EqYJRJ5jfcyy5aog7pyQv3BQYTRRyFFHaUmybWpZtkezKF8gL9z1Ejffj8uo5q0m#WcgQkywaTdy2dwKzffr87nv1su1Fv3Agdre2bDUYpfsam3QBhw4wQItDeB8sXL22zdAwaSsWqtKvtq3WwWHfJRmUG94UzOZsEMhLqNgZbKZTpdFu3Z$UZ$XY$OHWBe$yNq2VKoh3AlUFrEWaq5Rl7vkge9eDfP$ossSifSdLqjhcZN4L$Es2x8bUYRj6CDDVbslGuzyT8xtPif9#2xzMynaXFD#OrNuEyq7bz9Zq3gn5kIyxEQlYvXZdBdeNL$ILdbJkPLf#7rGZtCgTNC0$bCNmBV9uKwIuMfTLV4O#FvmVvBZh2Cu#2eRw98IdI$SlXlbx8AtWnRp3x6k7EvR3LUqrVx2E$eoidebM#cBVmCzWnN#H59MMLBwNV#GzgfH6FeIFOeIBSAHsnsj2qUWLVgQLYH5#5JSDgX7ka4rQvcs5LgwQLuyNqZbPMopHcKwIxeoDMUvdZYdb47z1dz3LzHp$2QeJxOfHMM#4zYOPm7qw6T1Zo9CGws#atrfZfMgh95r1xkf6UWDK8TyGehIumxRRYFePDd8OUsiv9dCe3sSS1Ea0lqnSqdtwWNs0rmhqmXhwsGZpL2jRAWCfoUTo#w$DJt8YRyicKHN$nLTo4JuVL27V1MApclRa5D#TMt9Qo#Mn4#ZVm2BwTr$8ctivxO3N2$IykgnqGqvzFENmHrU6k$1P$n9$pV$bt$aTBWjK8TxvOhMedK3s#dFjXTE$XoJoLfscbj4fQ5QscLbThn3DWDS8zBpghF0kHVWxFuXaypRJr42#5rQMyX9VnLlb8FgHIye6yB#$1QeIxNNHMvLrvHmx9s$AMl2bloElochmg1$aDFYHFylly0NyiZ$2dif6$WjK8zxaehJxCFyY3$8jCaGsoNjR9MbaZgsKLBvMLiaAMop9P8akrXd8OLYFSuQApgbMNtxN6MbFShK$Jpg18hoH#BpwheYCk$0exq9rq2fratdUQqicqXwxablbnOHCwaKwbqwWPROND57g17gE3z3HzIs$Hk$GfVKZ$S3ac4UTqEQZ9UFLoM5yVX$NjS5ZVBXhCFnTN7xzAn4$o9$mwVydlMlhu#sCm4gucLvEhoTNaQd8rEQx9kVFkU3mvZyVUkPfSJQucLvEZciBzNAvScC$lkz95r8OgKbbQ7aERisDgSuZUjzszMnQuYq#moM$JU$HGcFlwMT7RrKugeVujBO3rcf2KyPdd2l0LMXCyLz8gaph7WertSGPThpMWeM4yHBGeJ#1CpkBAdCrLk2fNu#fSWsjoBRDeRucDUUZhkMB$VedImQNffSHWvS7vdsJRLsNe9tx1#ECrj5Z8WnBaru#ZmSfV4sbbwFC4OVq#gZcGRhRvCq5OzQZcW3Ll6fSmrX7ARhEeiBvkjha#GMjhL5HOFpBRt9mWhAEZcQzSnsopFa5OrqIr3mmpspoI8ApReiAwqcopEq5OtmodGyi9#GsZ$zBFghhn2I$nX$7OvRxSjm26mhy95lR5doak2VBLaQZ6zHkppMy9mlfZD5WryyC1$ZinMBMKgB2MDzju4uGr4FsvgMKa26l56B1c9mXhZHYmred1RfaOsgJ5qAPr36swnD1cG0njOeatxegXpPBest1w36tgnT0cDuRxzkanj6aUvRnU5lxi2tcDZrBdtSNGEV4Ou5nu370kZdwVEEghauEwtd1Gb$NwmpcDVAs3kcvoKDUj3kfQvQ2kXntKzQs3klvqJfUcEQZBvw2k2WxgoefAL$5lmvbHwNNhkdNTkcxTuxbkiVS#FkMumElMTUkwTTsw$n$h6f#u5tw5potYfTNcZ71j2#Q6$yJzABaPuImLp8r68qwZhZYVBeD7Wb8twauzg2VrejxKX$gQVvzi$3Ii6KwkCwWvNKytq8qqX8QQVxCyd6wc4JZ1r7UFAA#EWQ$7mUlZQG9DfBleRfnoa$A$fKMZwJZthB#53jgTJNDeBiv4w#$3vz53#MMQ3LC6xWZn8rWR5a59#g1Hb3vePSEqX9OwWE3CXFkWPJ5zq11hzsIiO6ELjh39yIDOc70Vp8$11yiTzS6oXFjWIR5za6UpCrtWg0yMn#W3u#neYhLvh13OVH0PJU9yS1wTJvsmHn#h7IdeWwAm7AiTgMWV34H4CGZtlFWHR4eu0evhBMno084duZme6ady23R7DGej742G6nU2XGuWo0wBe6wnTuJu4JJ4wSXuBoSlti7zll39OCszHRJIXcu1hQAjj8qUeNMqapRG2bCNcxgyj0SnU6F7a3OstyiK3ajh4CbQMDKmgxt6ztDI2gNI5Y0DK2agJMMeB9MZyfH4oK0QFvBeL#nAHwrQEZFD7blZn6RCxZN7mkX$NJFjXDN6fgPeLqSkhN70TXUw29eIOzk8$xMeR1ln4ZjYEsYhdXfbOruR8stCQsCyGkTr0wfSmhDwe3dBE25MCqhOgk5lPsx4GLlrpVbbp9WJCAwHCFpx#rgqLSCN9MrrjMcHQNq9MgsVxzyJIingVMMLORFahAvMFLrVekDgpIF62S3OCPsqcedt0j0YUjXyBi1x1MoieksmKnVo2kp2zI4vRJNJj6TG5zWsUiMmgfbMZNS3q8PZO7Kjo0FTXiKCtBvp4KyjXjrMk47ccdOR79E#Mc$3qc9OQebt2zNJlFUnize2CVr2nCFp4GqlBo6ho$3EnUYsCdiRsbSdRXZsMDtesG9eRM7QoZL7KyDQDRuDhHxUclcivt044#xDvhEo6RTQAMTZ2KjdRY6xMaXgjyExH4Feqt2lDPwv4k7bW5NAZmkDMuqH5ngnKMXSM87Ig29LedJAWCqi#3lR#6vWgaRLgGRLf5gKGxMfZgEw7DDa#gc#go$n8#5gSZMvcbnDhYPNawl9rUHgSZMvcbnD8PgA$#dvrJIOhg5hwReIQwEHPhjxJojm5zzeapFmtX7clZxjUEvVGQmXAMDaqNlB1#OO6xGh9cmDpV#xK9VgX$sPHhuVgJMreRRKZiwYzdGsdKFdKWVgMB9#T63y4eSr#bNfOdLy3YHulaRXrvBUevIzYsET0$yMloOSw$$eV4suN$zDM8lMKJ$lF3O#uOqLQxx52#d20XWA$IQOX7tbnHsqpXrN5#k$0MiKQyp5UXnZTTkuRM9k4zMyfipmPr$8McdWwencdpYghhh7fowbCVVuHEVgSdNzR#gAQdUFHgzRrwthrdNh7izrtRtFhUlMTUkwTO$$kgWJ9jODcrlKo$Z4FLpRWhdXFt4$IcwZi9OAv4QbaRGMOytlHIhL47IH8Ti9B#F$FRTJyaMApoJAsXQiawDRl78fYsjb8G#0S1zHDUFl7Pu0tqd47l2NmQk1Vmwe7uB$XNHzekhbqMueU3sYf8V1pqJwRV1BWdQg3xPuqjw2E8iYjEcYT8mXIabHyXo5zqgKNuJqMYBV0LkRpQ0HH9wSO5wL4HPFhgXqF65nZpzOnzCfA2St8lBwG1sKdrNxKWjKUHMbvwrW6##GmlYhVmziprjonTOMzxseqcrjRPSHfLSEfgb$yNsK$PBYHqBpUKtaTfx3eUda9ZOy7nUkxq#oU9LQYdSgM4VfmPWam$$9qulRXy8wIkrN$0URtdSL$use1kQaxnMYqkb87mPNww5qFyoJJD1rg9C5pCcGPrfbgIyYhmdoKb1lefNdQqTK2VNJXw0$3o5$ZPMVzhWg7wJIUrLwaSNJ5RxasYf$EtIV3TsfqF6oofi1#LSbOntLw8boF#GTH9cfLdwcp#8fdoYCxmVxM#L9Y$lR49L1NygqWWwijUIEIkSta3k3lwxgsUQx7#lHZ$Nf$GMyXvLNusx8fuDwgJhd1UlNLlEvndpxE1INW6CbscBT#Mk3FmVU7Fp3O7dIIAKVO#Tlg#mFL3oNg6O077jPqYZ8pI2hlSl$G517IdNOQMhhOp$KHV$z0rJw2gH1VkmB$WSXtuBCJx4EaAuv7Vi5rdGIyDLS3dug2EKrTqClzhoK#P0F8kyqK7$8NuRsh#O$eMd$LnWFs2fp3$oVeSOZKvMrH$vwXHdxOvLlaNvLbTq6#R0gWvyoXX5LHPsool$#qP2LVrAUHnbyKLRDGV$jaATOSgsq89RQ6EjQkQhDNiYjKVSDy4l1tmA$5lmG#3ZmTy6nl$ENuEl1Qu4$XJvZBINzYJJs8QqcKQ0C2ET1e3JAqJQG0$wZPIDG3dG#vYhi13ghl3euJzJ#aF4iSFS6reqAznsGtx3arBOe6u$qdweC#tgvwae7#f6JZJmaoxMtyYfY7kKqHHwmbniSEWO1Z6VW1D0bq0k$1Pee6riXdmX2kq0tK7TG3n3MNw0N2DW2VK1zGPX30Ont07CWC0cspeMjRR0r3Uc1u9ZJ0SoVSZZJ0ZU1S2xceBqVwps0kHeO3C8wpq6P7#kwt3z8mz#1MTXNRi3wteB#hYOg3py7xWNjGbtOyMC$A0zRWJcWsP2nNmKmBdwKbySv7RWV$VWHRN7kbWUUm0CemrmjZ$4BO6wd$eIp77j9LQod2eOlvg5y3sICGm3xcAy1pcZuii9vI6Dk#r6$mesG5u3seHnzoqBVgs4yAi1#O17g$0mPk0ABKNurogv2#WEabw0C#qWQzjp0Kj01z64Xydv57lQO0EPC3ifpu7S$yAHXJGQMg$73$Xh0FFR$3euwWTziu$UxVJnLtX6Bvw1Du5NmZuDbNiGZIJqBjqbApPCHcnmCvbTk49Jf39NNFfXNQPZ5gwduoDD6sL5pBxaY6VzHa59mXdYnFhmuDnZxXySBZdr2mpncpAEKnu8wKp#mE2ykYBCeGfjFBPxMtDQ7Fa5PW#sqhlOswE$VHXmKgYTjHcYwygZ8TZqPe96WGrOwALtnkGNqp8gi9srDKFRk3YrB6bT0rpfRtSwHz1QmKKErtn#QxpidSZllvWBf3JPidWZszYbx7nKNOxG4#mSjdZpbA1ZCDO6nLcTAieezKZXOf#8fXTjLl43LQsdhzpF8dmp2caqPMJny5Glr7Nbg$qxP5CnB#JueLphDRjFYll6AdwDuHrlzBa4v6UTEAlQLIbE3UJwiDHzY5v#AmtsxmcFrFQRm3L7fNmhNISxR2$uiJl$3sqa$OF5iTP$8Rcp3i4$rQKNujZNouiC$KEUJy7K8PwRlhz0yJu4rv9rewzF5s6ERMV5T2lPqNoSGzk4KxEd#5g2My2dsT3$Y7Z$shbJiutuZBi2vuyiArUiBsMEKVkXAHRpZ6sUb$SE2PQaBWd8bx4UfXsowAjfy1cpfmEcxq5O#sLQECzVtT33jDpdclNsEuRobKu9fhQNYQjmzAcPEcgTmpx3YZnJ41$uLm8PumRyAj3gF2lXzcyNvT5l$r7t7lpAOnxiKPkXA$ypmiGtt25kVTAGViPLz5vGpcbiyK4$r3UTzHbULDy2Eo#QlZU7oOo7OCiy9#FS7rNSLFmNcs#eKkaCYxmjLVuWjxmN4EdL1RP2mzJTpjAhxSp2FJxR9msrrvoAzrLRskwqCiK3cTnZdPi4yRLHGpi9#eUsqbQdzALNjhLc8Gx8m3posSVACjhL7lELvr5QcsyhK$SgRTtzFGvxocNTii5wWGfvSa51szj7BijNF6BBLFKPhOJAIV#Gl#Kd#QygO6$A28BAMP$IFfQDq8D8$qh$74r6LZfr45vGbWN2J4aGkWYXUu1Lf33fLpiAp7TgTBUsbjRIICwMbj93cSeQSBisaitIIRgQTow7fPVrdwMsc1keluGbPhX14o8ARlNG1NQWVaK5ofQxBdQB#$wRWzY308jXnv0TeUL6EY5V6oXYvGsutQs0D2kxPWZXKRf3hpBnhvHhnIraf8wMbbFwS$gp#ZBvVVrhVXpBSbUHMkLc6IIN9a7If8jbIMR8aKsf97QajEP8h3QM1D96JfAcSADZN17SwGLmk8#Kc6Iv3HVrNOBbUlfVlv5lvHhwMh#HB#K8#by$aK$b44E49eZjvMT1N$GMolMHVIEg9V6clBVTn429cMGH2L2o8i0KHj#J$ttQP9xZbo5HR6qJpWXadYFvbjk1U88ZvPOPCDqidcyz9WlkwZ9TxybjDL7m2w2xzGpbNpW7Y3$HtzNVqG$hR#blwc$eR#klwQ$gh#a7z5HrtLFqd$JFzS$qB$KivNywJhcPxt9VaOXtpIZyiFSsSVg2#Sganrj97UkY8rlL$fB#EtLmyek7farGyAmZclbIN6dZM5TpNf95WHvMJvHJ1gIDjv4N1pKUc2Uv9WlkCp3NrFwQGFse#z#JtQBVvtALIEyqdRb7wy$hxqX7yFHttTnrpNyUzGlyBfGn272wuWqfLgIRb9Lb8$rF$rTAXVwB$eBGTaFruFgrIsytdDfNQQZwto7CglScmPagRzGFoL73LoVFMRCRJd3kcPCqTS#OSxHMSAqUjCQQe6h6zyle4gME#zBUj$3U1h#GFkK1w2Mx6Sfd#jVwD$gsEtPLRqXvYCiRd4T90J2j1bv2NUf87nBG9#PiWxpQ9QJDPtxzp0sIB35cpfOjFq$F9#AvSpPOk7brFnhTqUMWD#1gajq3UGiOtpdb0R7vZwLh8gy5NWzzEAQ0acW5#Xqb9e6Gb6vHgumRvRDmWVtxvJF2PQ3yJxItPe5GRDyXdumRvyyl70FCOO1eBFXPy7FWuy3kXSnPe0lHEG5sBKXNvp6ycMuN#B09VXFgBC5OR86#0F1vqBsWYwAvyyjBTADyEdTkXws78FT3UeAw5o4F6$ocupEG6UK59j0DbEv2$0taxaBSHyaRaTGVlZhpkoDk9z4x8MnLjGpgFkkMJ5#GnQGJI8v0UOSeUweLqB#YR13u9l6y#UK4U6WdP8Y$8exw$p4ExJ6BghUXcHVrCqcWo#6Jm9U06zJ59eodWKy0l1o#A#flaeHl1RmHV1fv70qpoq13m8U3BYKswmYGF3GKV2cvy1t0U3JJ9GyF0Xu7F1fyDlW2y8ArGTAL97he9$2RmEU1pm1U2ssaGyWQ1Zm8V1JuNtFZssgl0hmA$1VmMyFl0xmE$6jpuZOPRmMy5ln$yVl31u8F1RmE$3Vm1y0V0hm6$1dmu#73m1y4V1B$Mf2IG5#G1QJGLULEHDnLvKv4t5NaF8UyXv1c$5tmTyenlwZQ#AtiU#3pmfU3Hq3IqCNvtVZJuQF1ruEl0BpqAtVD$3Qbywm==");
    private WorkingParseResult fWorking;
    private final List<IRecoveryStrategy> recoveryStrategies;
    private JSFlexScanner fScanner;

    private void attachPostDocumentationBlocks(JSParseRootNode root, String source) {
        block3: for (Symbol block : this.fScanner.getVSDocComments()) {
            int index = block.getStart() - 1;
            while (index >= 0 && Character.isWhitespace(source.charAt(index))) {
                --index;
            }
            IParseNode node = root.getNodeAtOffset(index);
            if (!(node instanceof JSNode)) continue;
            switch (node.getNodeType()) {
                case 21: {
                    IParseNode parent = node.getParent();
                    if (parent.getNodeType() != 70) continue block3;
                    ((JSNode)parent).setPostDocumentation(block);
                    break;
                }
                default: {
                    ((JSNode)node).setPostDocumentation(block);
                }
            }
        }
    }

    private void attachPreDocumentationBlocks(JSParseRootNode root, String source) {
        List<Symbol> sDocComments = this.fScanner.getSDocComments();
        for (Symbol comment : sDocComments) {
            int index = comment.getEnd() + 1;
            while (index < source.length() && Character.isWhitespace(source.charAt(index))) {
                ++index;
            }
            IParseNode node = root.getNodeAtOffset(index);
            if (!(node instanceof JSNode)) continue;
            if (node instanceof JSGroupNode && node.getFirstChild() instanceof JSFunctionNode) {
                ((JSNode)node.getFirstChild()).setPreDocumentation(comment);
                continue;
            }
            if (node instanceof JSIdentifierNode && node.getParent() instanceof JSNameValuePairNode) {
                JSNameValuePairNode entry = (JSNameValuePairNode)node.getParent();
                ((JSNode)entry.getValue()).setPreDocumentation(comment);
                continue;
            }
            IParseNode statement = ((JSNode)node).getContainingStatementNode();
            if (statement instanceof JSAssignmentNode) {
                ((JSNode)statement.getLastChild()).setPreDocumentation(comment);
                continue;
            }
            switch (node.getNodeType()) {
                case 64: {
                    JSVarNode varNode = (JSVarNode)node;
                    ((JSNode)varNode.getFirstChild().getLastChild()).setPreDocumentation(comment);
                    break;
                }
                default: {
                    ((JSNode)node).setPreDocumentation(comment);
                }
            }
        }
    }

    protected Symbol getLastSymbol() {
        Symbol result = null;
        if (this.top >= 0 && this.top < this._symbols.length) {
            result = this._symbols[this.top];
        }
        return result;
    }

    public synchronized ParseResult parse(IParseState parseState) throws Exception {
        WorkingParseResult working = new WorkingParseResult();
        this.parse(parseState, working);
        return working.getImmutableResult();
    }

    protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fWorking = working;
        String source = parseState.getSource();
        this.fScanner = new JSFlexScanner();
        this.fScanner.setSource(source);
        boolean attachComments = true;
        boolean collectComments = true;
        if (parseState instanceof JSParseState) {
            JSParseState jsParseState = (JSParseState)parseState;
            attachComments = jsParseState.attachComments();
            collectComments = jsParseState.attachComments() || jsParseState.collectComments();
        }
        this.fScanner.setCollectComments(collectComments);
        try {
            JSParseRootNode result;
            try {
                result = (JSParseRootNode)((Object)this.parse(this.fScanner, parseState.getNeedSleep()));
                if (attachComments) {
                    this.attachComments(source, result);
                }
                if (collectComments) {
                    this.collectComments(result);
                }
            }
            finally {
                if (this.fScanner != null) {
                    EditorUtil.flexScannerYYclose((Object)((Object)this.fScanner));
                    this.fScanner = null;
                }
            }
            int start = parseState.getStartingOffset();
            int length = source.length();
            result.setLocation(0, length - 1);
            if (start != 0) {
                ParseUtil.addOffset((IParseNode)result, (int)start, (boolean)parseState.getNeedSleep());
            }
            this.fWorking.setParseResult((IParseRootNode)result);
        }
        finally {
            this.fWorking = null;
        }
    }

    private void attachComments(String source, JSParseRootNode result) {
        this.attachPreDocumentationBlocks(result, source);
        this.attachPostDocumentationBlocks(result, source);
    }

    private void collectComments(JSParseRootNode result) {
        List<Symbol> sDocComments = this.fScanner.getSDocComments();
        List<Symbol> vsDocComments = this.fScanner.getVSDocComments();
        List<Symbol> singleLineComments = this.fScanner.getSingleLineComments();
        List<Symbol> multiLineComments = this.fScanner.getMultiLineComments();
        ArrayList<JSCommentNode> comments = new ArrayList<JSCommentNode>(sDocComments.size() + vsDocComments.size() + singleLineComments.size() + multiLineComments.size());
        for (Symbol symbol : sDocComments) {
            comments.add(new JSCommentNode(90, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : vsDocComments) {
            comments.add(new JSCommentNode(91, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : singleLineComments) {
            comments.add(new JSCommentNode(92, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : multiLineComments) {
            comments.add(new JSCommentNode(93, symbol.getStart(), symbol.getEnd()));
        }
        result.setCommentNodes(comments.toArray(new IParseNode[comments.size()]));
    }

    protected void recoverFromError(Symbol token, Parser.TokenStream in) throws IOException, Parser.Exception {
        boolean success = false;
        if (this.recoveryStrategies != null) {
            for (IRecoveryStrategy strategy : this.recoveryStrategies) {
                if (!strategy.recover((IParser)this, this.getLastSymbol(), token, in, this.report)) continue;
                success = true;
                break;
            }
        }
        if (!success) {
            super.recoverFromError(token, in);
        }
    }

    public JSParser() {
        super(PARSING_TABLES);
        this.report = new JSEvents();
        this.recoveryStrategies = new ArrayList<IRecoveryStrategy>();
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.SEMICOLON, ";", new JSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.RPAREN, ")", JSTokenType.SEMICOLON, ";", new JSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.SEMICOLON, ";", JSTokenType.DOT, JSTokenType.NEW, JSTokenType.EQUAL));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.DOT, JSTokenType.NEW, JSTokenType.EQUAL));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.LPAREN));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.COLON, ":", JSTokenType.DOT));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.LCURLY, "{", JSTokenType.RCURLY, "}", JSTokenType.RPAREN));
        this.recoveryStrategies.add(new IRecoveryStrategy(){

            public boolean recover(IParser parser, Symbol lastToken, Symbol currentToken, Parser.TokenStream in, Parser.Events report) throws IOException {
                boolean result = false;
                if (JSParser.this.top >= 2) {
                    Symbol symbol1 = JSParser.this._symbols[JSParser.this.top - 2];
                    Symbol symbol2 = JSParser.this._symbols[JSParser.this.top - 1];
                    if (lastToken.getId() == JSTokenType.COMMA.getIndex() && symbol2.value instanceof List && symbol1.getId() == JSTokenType.LPAREN.getIndex()) {
                        Symbol term = new Symbol(JSTokenType.IDENTIFIER.getIndex(), currentToken.getStart(), currentToken.getStart() - 1, (Object)"");
                        Parser.Simulator sim = new Parser.Simulator((Parser)JSParser.this);
                        in.alloc(2);
                        in.insert(term, currentToken);
                        in.rewind();
                        if (sim.parse(in)) {
                            result = true;
                            in.rewind();
                            report.missingTokenInserted(term);
                        }
                    }
                }
                return result;
            }
        });
        JSInsertionRecoveryStrategy completeProperty = new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", new JSTokenType[0]);
        completeProperty.addCurrentTokenTypes(new JSTokenType[]{JSTokenType.RCURLY});
        this.recoveryStrategies.add((IRecoveryStrategy)completeProperty);
        JSInsertionRecoveryStrategy completeProperty2 = new JSInsertionRecoveryStrategy(JSTokenType.COLON, ":", JSTokenType.IDENTIFIER, "", new JSTokenType[0]);
        completeProperty2.addCurrentTokenTypes(new JSTokenType[]{JSTokenType.RCURLY});
        this.recoveryStrategies.add((IRecoveryStrategy)completeProperty2);
    }

    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                Symbol _symbol_p = this._symbols[offset + 1];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                return new JSParseRootNode((Symbol[])p);
            }
            case 1: {
                return new JSParseRootNode();
            }
            case 2: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 3: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 5: {
                Symbol ident = this._symbols[offset + 2];
                Symbol _symbol_params = this._symbols[offset + 3];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 4];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSFunctionNode(new JSIdentifierNode(ident), params, body);
            }
            case 6: {
                Symbol f = this._symbols[offset + 1];
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 3];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSFunctionNode(new JSEmptyNode(f), params, body);
            }
            case 8: {
                return new JSParametersNode(new JSNode[0]);
            }
            case 9: {
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                return params;
            }
            case 10: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol ident = this._symbols[offset + 3];
                JSIdentifierNode identifier = new JSIdentifierNode(ident);
                list.addChild((IParseNode)identifier);
                return list;
            }
            case 11: {
                Symbol ident = this._symbols[offset + 1];
                JSIdentifierNode identifier = new JSIdentifierNode(ident);
                return new JSParametersNode(identifier);
            }
            case 12: {
                return new JSStatementsNode(new JSNode[0]);
            }
            case 13: {
                Symbol _symbol_s = this._symbols[offset + 2];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSStatementsNode(s);
            }
            case 16: {
                Symbol v = this._symbols[offset + 1];
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                JSNode[] l = _list_l == null ? new JSNode[]{} : _list_l.toArray(new JSNode[_list_l.size()]);
                Symbol s = this._symbols[offset + 3];
                JSVarNode node = new JSVarNode(v, l);
                node.setSemicolonIncluded(s.getEnd() >= s.getStart());
                return node;
            }
            case 17: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.setSemicolonIncluded(true);
                return e;
            }
            case 29: {
                Symbol s = this._symbols[offset + 1];
                JSEmptyNode node = new JSEmptyNode(s);
                ((JSNode)node).setSemicolonIncluded(true);
                return node;
            }
            case 30: {
                return new JSErrorNode();
            }
            case 33: {
                Symbol v = this._symbols[offset + 1];
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                JSNode[] l = _list_l == null ? new JSNode[]{} : _list_l.toArray(new JSNode[_list_l.size()]);
                JSVarNode node = new JSVarNode(v, l);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 34: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.setSemicolonIncluded(true);
                return e;
            }
            case 45: {
                Symbol s = this._symbols[offset + 1];
                return new JSEmptyNode(s);
            }
            case 46: {
                return new JSErrorNode();
            }
            case 47: {
                return new JSStatementsNode(new JSNode[0]);
            }
            case 48: {
                Symbol _symbol_a = this._symbols[offset + 2];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                JSNode[] a = _list_a == null ? new JSNode[]{} : _list_a.toArray(new JSNode[_list_a.size()]);
                return new JSStatementsNode(a);
            }
            case 49: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 50: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 51: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 52: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 53: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 54: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 55: {
                Symbol i = this._symbols[offset + 1];
                return new JSDeclarationNode(new JSIdentifierNode(i), null, (JSNode)new JSEmptyNode(i));
            }
            case 56: {
                Symbol i = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(new JSIdentifierNode(i), e, expression);
            }
            case 57: {
                Symbol i = this._symbols[offset + 1];
                return new JSDeclarationNode(new JSIdentifierNode(i), null, (JSNode)new JSEmptyNode(i));
            }
            case 58: {
                Symbol i = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(new JSIdentifierNode(i), e, expression);
            }
            case 59: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_sn = this._symbols[offset + 5];
                JSNode sn = (JSNode)((Object)_symbol_sn.value);
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, sn, s);
            }
            case 60: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, s, (JSNode)new JSEmptyNode((Symbol)s));
            }
            case 61: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_sn = this._symbols[offset + 5];
                JSNode sn = (JSNode)((Object)_symbol_sn.value);
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, sn, s);
            }
            case 62: {
                Symbol _symbol_s = this._symbols[offset + 2];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                Symbol l = this._symbols[offset + 4];
                Symbol _symbol_e = this._symbols[offset + 5];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 6];
                JSDoNode node = new JSDoNode(s, l, e, r);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 63: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWhileNode(l, e, r, s);
            }
            case 64: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol r = this._symbols[offset + 5];
                Symbol _symbol_s = this._symbols[offset + 6];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 65: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol _symbol_a = this._symbols[offset + 5];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 66: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 67: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, a, r, s);
            }
            case 68: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 69: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 70: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 71: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, a, r, s);
            }
            case 72: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 73: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 74: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 75: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol _symbol_a = this._symbols[offset + 8];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 9];
                Symbol _symbol_s = this._symbols[offset + 10];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, a, r, s);
            }
            case 76: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, i, in, o, r, s);
            }
            case 77: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, (JSNode)new JSVarNode(v, i), in, o, r, s);
            }
            case 78: {
                Symbol _symbol_s = this._symbols[offset + 2];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                Symbol l = this._symbols[offset + 4];
                Symbol _symbol_e = this._symbols[offset + 5];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 6];
                JSDoNode node = new JSDoNode(s, l, e, r);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 79: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWhileNode(l, e, r, s);
            }
            case 80: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol r = this._symbols[offset + 5];
                Symbol _symbol_s = this._symbols[offset + 6];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 81: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol _symbol_a = this._symbols[offset + 5];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 82: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 83: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, a, r, s);
            }
            case 84: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 85: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 86: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 87: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, a, r, s);
            }
            case 88: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 89: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 90: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 91: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol _symbol_a = this._symbols[offset + 8];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 9];
                Symbol _symbol_s = this._symbols[offset + 10];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, a, r, s);
            }
            case 92: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, i, in, o, r, s);
            }
            case 93: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, (JSNode)new JSVarNode(v, i), in, o, r, s);
            }
            case 94: {
                JSContinueNode node = new JSContinueNode();
                node.setSemicolonIncluded(true);
                return node;
            }
            case 95: {
                Symbol i = this._symbols[offset + 2];
                JSContinueNode node = new JSContinueNode(i);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 96: {
                JSBreakNode node = new JSBreakNode();
                node.setSemicolonIncluded(true);
                return node;
            }
            case 97: {
                Symbol i = this._symbols[offset + 2];
                JSBreakNode node = new JSBreakNode(i);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 98: {
                Symbol r = this._symbols[offset + 1];
                JSReturnNode node = new JSReturnNode(new JSEmptyNode(r));
                node.setSemicolonIncluded(true);
                return node;
            }
            case 99: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSReturnNode node = new JSReturnNode(e);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 100: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWithNode(l, e, r, s);
            }
            case 101: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWithNode(l, e, r, s);
            }
            case 102: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol rc = this._symbols[offset + 6];
                return new JSSwitchNode(lp, e, rp, lc, rc, new JSNode[0]);
            }
            case 103: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol rc = this._symbols[offset + 7];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] s = c;
                int _symbol_s = c.length;
                int r = 0;
                while (r < _symbol_s) {
                    JSNode statement = s[r];
                    nodes.add(statement);
                    ++r;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 104: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_d = this._symbols[offset + 6];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol rc = this._symbols[offset + 7];
                return new JSSwitchNode(lp, e, rp, lc, rc, d);
            }
            case 105: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_d = this._symbols[offset + 6];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol _symbol_c = this._symbols[offset + 7];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol rc = this._symbols[offset + 8];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                nodes.add(d);
                JSNode[] jSNodeArray = c;
                int n = c.length;
                int s = 0;
                while (s < n) {
                    JSNode statement = jSNodeArray[s];
                    nodes.add(statement);
                    ++s;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 106: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol _symbol_d = this._symbols[offset + 7];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol rc = this._symbols[offset + 8];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] jSNodeArray = c;
                int n = c.length;
                int s = 0;
                while (s < n) {
                    JSNode statement = jSNodeArray[s];
                    nodes.add(statement);
                    ++s;
                }
                nodes.add(d);
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 107: {
                JSNode statement;
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c1 = this._symbols[offset + 6];
                ArrayList _list_c1 = (ArrayList)_symbol_c1.value;
                JSNode[] c1 = _list_c1 == null ? new JSNode[]{} : _list_c1.toArray(new JSNode[_list_c1.size()]);
                Symbol _symbol_d = this._symbols[offset + 7];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol _symbol_c2 = this._symbols[offset + 8];
                ArrayList _list_c2 = (ArrayList)_symbol_c2.value;
                JSNode[] c2 = _list_c2 == null ? new JSNode[]{} : _list_c2.toArray(new JSNode[_list_c2.size()]);
                Symbol rc = this._symbols[offset + 9];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] jSNodeArray = c1;
                int n = c1.length;
                int n2 = 0;
                while (n2 < n) {
                    statement = jSNodeArray[n2];
                    nodes.add(statement);
                    ++n2;
                }
                nodes.add(d);
                jSNodeArray = c2;
                n = c2.length;
                n2 = 0;
                while (n2 < n) {
                    statement = jSNodeArray[n2];
                    nodes.add(statement);
                    ++n2;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 108: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 109: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 110: {
                Symbol c = this._symbols[offset + 2];
                return new JSCaseNode(c, new JSNode[0]);
            }
            case 111: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol c = this._symbols[offset + 3];
                return new JSCaseNode(e, c, new JSNode[0]);
            }
            case 112: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol c = this._symbols[offset + 3];
                Symbol _symbol_s = this._symbols[offset + 4];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSCaseNode(e, c, s);
            }
            case 113: {
                Symbol c = this._symbols[offset + 2];
                return new JSDefaultNode(c, new JSNode[0]);
            }
            case 114: {
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSDefaultNode(c, s);
            }
            case 115: {
                Symbol i = this._symbols[offset + 1];
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                id.setLocation(i.getStart(), i.getEnd());
                return new JSLabelledNode(id, c, s);
            }
            case 116: {
                Symbol i = this._symbols[offset + 1];
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                id.setLocation(i.getStart(), i.getEnd());
                return new JSLabelledNode(id, c, s);
            }
            case 117: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSThrowNode node = new JSThrowNode(e);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 118: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                return new JSTryNode(b, c, new JSEmptyNode((Symbol)c));
            }
            case 119: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_f = this._symbols[offset + 3];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSTryNode(b, new JSEmptyNode((Symbol)b), f);
            }
            case 120: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol _symbol_f = this._symbols[offset + 4];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSTryNode(b, c, f);
            }
            case 121: {
                Symbol d = this._symbols[offset + 1];
                return new JSDebuggerNode(d);
            }
            case 122: {
                Symbol i = this._symbols[offset + 3];
                Symbol _symbol_b = this._symbols[offset + 5];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                return new JSCatchNode(id, b);
            }
            case 123: {
                Symbol i = this._symbols[offset + 3];
                Symbol e = this._symbols[offset + 5];
                Symbol _symbol_b = this._symbols[offset + 7];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                JSNode conditionNode = (JSNode)((Object)e.value);
                return new JSCatchNode(id, conditionNode, b);
            }
            case 124: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                return new JSFinallyNode(b);
            }
            case 127: {
                Symbol t = this._symbols[offset + 1];
                return new JSThisNode(t);
            }
            case 128: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 131: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                return new JSGroupNode(l, e, r);
            }
            case 132: {
                Symbol l = this._symbols[offset + 1];
                Symbol r = this._symbols[offset + 2];
                return new JSArrayNode(l, r, new JSNode[0]);
            }
            case 133: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                e.addChild((IParseNode)new JSNullNode());
                return new JSArrayNode(l, r, e);
            }
            case 134: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                return new JSArrayNode(l, r, e);
            }
            case 135: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                return new JSArrayNode(l, r, e, new JSNullNode());
            }
            case 136: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_n = this._symbols[offset + 4];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol r = this._symbols[offset + 5];
                n.addChild((IParseNode)new JSNullNode());
                return new JSArrayNode(l, r, e, n);
            }
            case 137: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSElementsNode(e);
            }
            case 138: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSElementsNode(n, e);
            }
            case 139: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                l.addChild((IParseNode)e);
                return l;
            }
            case 140: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_n = this._symbols[offset + 3];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_e = this._symbols[offset + 4];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                l.addChild((IParseNode)n);
                l.addChild((IParseNode)e);
                return l;
            }
            case 141: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.addChild((IParseNode)new JSNullNode());
                return e;
            }
            case 142: {
                return new JSElisionNode(new JSNullNode());
            }
            case 143: {
                Symbol l = this._symbols[offset + 1];
                Symbol r = this._symbols[offset + 2];
                return new JSObjectNode(l, r, new JSNode[0]);
            }
            case 144: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_p = this._symbols[offset + 2];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                Symbol r = this._symbols[offset + 3];
                return new JSObjectNode(l, r, p);
            }
            case 145: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_p = this._symbols[offset + 2];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                Symbol r = this._symbols[offset + 4];
                return new JSObjectNode(l, r, p);
            }
            case 146: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 147: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 148: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_v = this._symbols[offset + 3];
                JSNode v = (JSNode)((Object)_symbol_v.value);
                return new JSNameValuePairNode(n, c, v);
            }
            case 149: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol c = this._symbols[offset + 2];
                Symbol cfr_ignored_0 = this._symbols[offset + 3];
                return new JSNameValuePairNode(n, c, (JSNode)new JSEmptyNode(c));
            }
            case 150: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 151: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 152: {
                Symbol n = this._symbols[offset + 1];
                return new JSNumberNode(n);
            }
            case 155: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 156: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 157: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_a = this._symbols[offset + 3];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                return new JSConstructNode(e, a);
            }
            case 159: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 160: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 161: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_a = this._symbols[offset + 3];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                return new JSConstructNode(e, a);
            }
            case 163: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSConstructNode(e, new JSEmptyNode((Symbol)e));
            }
            case 165: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSConstructNode(e, new JSEmptyNode((Symbol)e));
            }
            case 166: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 167: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 168: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 169: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 170: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 171: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 172: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 173: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 174: {
                return new JSArgumentsNode(new JSNode[0]);
            }
            case 175: {
                Symbol _symbol_a = this._symbols[offset + 2];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                JSNode[] a = _list_a == null ? new JSNode[]{} : _list_a.toArray(new JSNode[_list_a.size()]);
                return new JSArgumentsNode(a);
            }
            case 176: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 177: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 183: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol o = this._symbols[offset + 2];
                return new JSPostUnaryOperatorNode(o, e);
            }
            case 185: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol o = this._symbols[offset + 2];
                return new JSPostUnaryOperatorNode(o, e);
            }
            case 189: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSPreUnaryOperatorNode(o, e);
            }
            case 191: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSPreUnaryOperatorNode(o, e);
            }
            case 202: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 204: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 209: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 211: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 215: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 217: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 222: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 224: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 226: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 235: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 237: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 239: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 244: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 246: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 248: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 250: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 252: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 254: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 256: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 258: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 260: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 262: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 264: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 266: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 268: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 270: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 272: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 275: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 276: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                return new JSConditionalNode(l, q, t, c);
            }
            case 277: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                return new JSConditionalNode(l, q, t);
            }
            case 278: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                return new JSConditionalNode(l, q);
            }
            case 280: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 281: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                return new JSConditionalNode(l, q, t, c, null);
            }
            case 282: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                return new JSConditionalNode(l, q, t, null, null);
            }
            case 283: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                return new JSConditionalNode(l, q, null, null, null);
            }
            case 285: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 287: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 289: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 291: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 304: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 306: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 308: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 310: {
                Symbol n = this._symbols[offset + 1];
                return new JSNullNode(n);
            }
            case 311: {
                Symbol t = this._symbols[offset + 1];
                return new JSTrueNode(t);
            }
            case 312: {
                Symbol f = this._symbols[offset + 1];
                return new JSFalseNode(f);
            }
            case 313: {
                Symbol n = this._symbols[offset + 1];
                return new JSNumberNode(n);
            }
            case 314: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 315: {
                Symbol r = this._symbols[offset + 1];
                return new JSRegexNode(r);
            }
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 153: 
            case 154: 
            case 158: 
            case 162: 
            case 164: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 203: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 210: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 223: 
            case 225: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 236: 
            case 238: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 245: 
            case 247: 
            case 249: 
            case 251: 
            case 253: 
            case 255: 
            case 257: 
            case 259: 
            case 261: 
            case 263: 
            case 265: 
            case 267: 
            case 269: 
            case 271: 
            case 273: 
            case 274: 
            case 279: 
            case 284: 
            case 286: 
            case 288: 
            case 290: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 305: 
            case 307: 
            case 309: {
                return this._symbols[offset + 1];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    private class JSEvents
    extends Parser.Events {
        private JSEvents() {
        }

        public void scannerError(Scanner.Exception e) {
        }

        public void syntaxError(Symbol token) {
            if (token != null && JSParser.this.fWorking != null) {
                JSParser.this.fWorking.addError((IParseError)new ParseError("com.aptana.contenttype.js", token, IParseError.Severity.ERROR));
            }
        }

        public void unexpectedTokenRemoved(Symbol token) {
        }

        public void missingTokenInserted(Symbol token) {
        }

        public void missingTokensInserted(List<Symbol> tokens) {
            if (tokens != null && tokens.size() == 1 && tokens.get(0).getId() == 23 && JSParser.this.fWorking != null) {
                IParseError lastError;
                List errors = JSParser.this.fWorking.getErrors();
                IParseError iParseError = lastError = errors.isEmpty() ? null : (IParseError)errors.get(errors.size() - 1);
                if (lastError != null) {
                    JSParser.this.fWorking.removeError(lastError);
                }
            }
            super.missingTokensInserted(tokens);
        }

        public void misspelledTokenReplaced(Symbol token) {
        }

        public void errorPhraseRemoved(Symbol error) {
        }
    }
}

