/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.outline;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.outline.CommonOutlineContentProvider;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.CommonOutlinePageInput;
import com.aptana.editor.js.outline.JSOutlineItem;
import com.aptana.editor.js.outline.Reference;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.ParseRootNode;
import com.aptana.parsing.lexer.IRange;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JSOutlineContentProvider
extends CommonOutlineContentProvider {
    private static final String CONTAINER_TYPE = "/";
    private static final String PROPERTY_TYPE = ".";
    private static final String FUNCTION_LITERAL = "<function>";
    private Map<String, JSOutlineItem> fItemsByScope = new HashMap<String, JSOutlineItem>();
    private JSOutlineItem fLastAddedItem;
    private static final Set<String> CLASS_EXTENDERS = CollectionsUtil.newSet((Object[])new String[]{"dojo.lang.extend", "Ext.extend", "jQuery.extend", "MochiKit.Base.update", "Object.extend", "qx.Class.define", "qx.Interface.define", "qx.Theme.define", "qx.Mixin.define"});

    public CommonOutlineItem getOutlineItem(IParseNode node) {
        if (node == null) {
            return null;
        }
        IParseNode tmp = node;
        if (tmp.getParent() instanceof JSParametersNode) {
            tmp = node.getParent();
        }
        if (tmp instanceof JSParametersNode) {
            tmp = tmp.getParent();
        }
        if (tmp.getParent() instanceof JSFunctionNode) {
            tmp = tmp.getParent();
        }
        if (tmp instanceof JSFunctionNode) {
            JSFunctionNode f = (JSFunctionNode)tmp;
            return new JSOutlineItem(String.valueOf(f.getName().getText()) + f.getParameters().toString(), JSOutlineContentProvider.getOutlineType(node), (IRange)f.getName(), (IParseNode)f);
        }
        return new JSOutlineItem(node.getText(), JSOutlineContentProvider.getOutlineType(node), (IRange)node, node);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof AbstractThemeableEditor || parentElement instanceof ParseRootNode || parentElement instanceof CommonOutlinePageInput) {
            this.fItemsByScope.clear();
            this.fLastAddedItem = null;
            return super.getChildren(parentElement);
        }
        if (parentElement instanceof JSOutlineItem) {
            JSOutlineItem item = (JSOutlineItem)((Object)parentElement);
            Object[] children = this.filter(item.getAllReferenceNodes());
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (!child.equals((Object)item) && child != null) {
                    list.add(child);
                }
                ++n2;
            }
            return list.toArray(new Object[list.size()]);
        }
        return super.getChildren(parentElement);
    }

    protected Object[] filter(IParseNode[] nodes) {
        TreeSet<JSOutlineItem> elements = new TreeSet<JSOutlineItem>();
        if (nodes.length > 0 && nodes[0].getParent() instanceof ParseRootNode) {
            this.processStatements(elements, nodes[0].getParent());
        } else {
            IParseNode[] iParseNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode node = iParseNodeArray[n2];
                this.processNode(elements, node);
                ++n2;
            }
        }
        return elements.toArray(new JSOutlineItem[elements.size()]);
    }

    private void addValue(Collection<JSOutlineItem> elements, Reference reference, IParseNode value) {
        this.addValue(elements, reference, value, null);
    }

    private void addValue(Collection<JSOutlineItem> elements, Reference reference, IParseNode value, IParseNode parent) {
        boolean processed = false;
        switch (value.getNodeType()) {
            case 70: {
                this.processFunction(elements, value, reference);
                processed = true;
                break;
            }
            case 62: {
                IParseNode child = value.getChild(0);
                if (child.getNodeType() == 70) {
                    this.processFunction(elements, child, reference);
                    processed = true;
                    break;
                }
                value = child;
            }
        }
        if (!processed) {
            String path = reference.toString();
            JSOutlineItem item = this.fItemsByScope.get(path);
            if (item == null) {
                int count = 0;
                if (value.getNodeType() == 77) {
                    count = value.getChildCount();
                }
                item = new JSOutlineItem(reference.getName(), JSOutlineContentProvider.getOutlineType(value), (IRange)reference.getNameNode(), value, count);
                this.fItemsByScope.put(path, item);
            }
            elements.add(item);
            this.fLastAddedItem = item;
        }
    }

    private void addVirtualChild(Collection<JSOutlineItem> elements, Reference reference, IParseNode node, IParseNode target) {
        String key = reference.getScope();
        JSOutlineItem item = this.fItemsByScope.get(key);
        if (item == null) {
            JSOutlineItem.Type type = node.getNodeType() == 70 ? JSOutlineItem.Type.FUNCTION : JSOutlineItem.Type.PROPERTY;
            item = new JSOutlineItem(node.getText(), type, (IRange)node, node);
            this.fItemsByScope.put(key, item);
        }
        elements.add(item);
        item.addVirtualChild(target);
        this.fLastAddedItem = item;
    }

    private void processNode(Collection<JSOutlineItem> elements, IParseNode node) {
        short type = node.getNodeType();
        switch (type) {
            case 1: {
                this.processAssignment(elements, node.getChild(0), node.getChild(1));
                break;
            }
            case 70: {
                this.processFunction(elements, node, null);
                break;
            }
            case 58: {
                if (node.getChildCount() <= 0) break;
                this.processNode(elements, node.getChild(0));
                break;
            }
            case 19: {
                this.processIdentifier(elements, node);
                break;
            }
            case 62: {
                this.processInvoke(elements, node);
                break;
            }
            case 76: {
                this.processNameValuePair(elements, node);
                break;
            }
            case 77: {
                int size = node.getChildCount();
                int i = 0;
                while (i < size) {
                    this.processNode(elements, node.getChild(i));
                    ++i;
                }
                break;
            }
            case 85: {
                IParseNode child;
                if (node.getChildCount() <= 0 || (child = node.getChild(0)).getNodeType() != 77) break;
                int size = child.getChildCount();
                int i = 0;
                while (i < size) {
                    this.processNode(elements, child.getChild(i));
                    ++i;
                }
                break;
            }
            case 21: {
                this.processStatements(elements, node);
                break;
            }
            case 65: 
            case 66: 
            case 86: {
                int size = node.getChildCount();
                int i = 0;
                while (i < size) {
                    this.processNode(elements, node.getChild(i));
                    ++i;
                }
                break;
            }
            case 20: 
            case 64: {
                this.processVar(elements, node);
            }
        }
    }

    private IParseNode processAssignment(Collection<JSOutlineItem> elements, IParseNode lhs, IParseNode rhs) {
        short lhsType = lhs.getNodeType();
        short rhsType = rhs.getNodeType();
        if (rhsType == 1) {
            rhs = this.processAssignment(elements, rhs.getChild(0), rhs.getChild(1));
            rhsType = rhs.getNodeType();
        }
        switch (lhsType) {
            case 17: {
                if (rhsType != 70 && rhsType != 77) break;
                String text = lhs.getText();
                Reference reference = new Reference(lhs.getParent(), lhs, text.substring(1, text.length() - 1), CONTAINER_TYPE);
                this.addValue(elements, reference, rhs);
                break;
            }
            case 19: {
                if (rhsType == 70 || rhsType == 77) {
                    Reference reference = new Reference(lhs.getParent(), lhs, lhs.getText(), CONTAINER_TYPE);
                    this.addValue(elements, reference, rhs);
                    break;
                }
                if (rhsType != 62 || rhs.getChildCount() != 2) break;
                IParseNode child = rhs.getChild(0);
                if (CLASS_EXTENDERS.contains(child.toString())) {
                    this.processInvoke(elements, rhs);
                    if (this.fLastAddedItem == null) break;
                    this.fLastAddedItem.setLabel(lhs.getText());
                    this.fLastAddedItem.setRange(lhs.getNameNode().getNameRange());
                    break;
                }
                Reference reference = new Reference(lhs.getParent(), lhs, lhs.getText(), CONTAINER_TYPE);
                this.addValue(elements, reference, child);
                break;
            }
            case 48: {
                IParseNode target = null;
                while (lhs.getNodeType() == 48) {
                    target = lhs.getChild(1);
                    lhs = lhs.getChild(0);
                }
                if (lhs.getNodeType() != 19 && lhs.getNodeType() != 20) break;
                String scopeString = Reference.createScopeString(lhs.getParent());
                if (this.fItemsByScope.containsKey(scopeString)) {
                    Reference reference = new Reference(scopeString, target, target.getText(), CONTAINER_TYPE);
                    this.addVirtualChild(elements, reference, lhs, target);
                    break;
                }
                Reference reference = new Reference(lhs, lhs, lhs.getText(), CONTAINER_TYPE);
                this.addValue(elements, reference, target);
                JSOutlineItem item = this.fItemsByScope.get(scopeString);
                item.addVirtualChild(target);
            }
        }
        return rhs;
    }

    private void processFunction(Collection<JSOutlineItem> elements, IParseNode node, Reference reference) {
        IRange range;
        String fullpath;
        JSOutlineItem item;
        boolean addToMap;
        String name;
        IParseNode nameNode;
        if (node.getNodeType() == 70 && node.getText().length() > 0) {
            nameNode = node.getChild(0);
            name = node.getText();
        } else if (reference != null) {
            nameNode = reference.getNameNode();
            name = reference.getName();
        } else {
            nameNode = node;
            name = FUNCTION_LITERAL;
        }
        if (reference == null) {
            reference = new Reference(node, nameNode, name, CONTAINER_TYPE);
        }
        boolean bl = addToMap = (item = this.fItemsByScope.get(fullpath = reference.toString())) == null || item.getType() != JSOutlineItem.Type.FUNCTION;
        if (!addToMap && (range = item.getSourceRange()) instanceof IParseNode) {
            boolean bl2 = addToMap = !name.equals(((IParseNode)range).getText());
        }
        if (addToMap) {
            String text;
            if (name.endsWith("<function>)")) {
                text = name;
            } else {
                String pattern = "{0}({1})";
                IParseNode parameters = node.getChild(1);
                String parmsString = parameters.toString();
                if (parmsString.startsWith("(")) {
                    pattern = "{0}{1}";
                }
                text = MessageFormat.format(pattern, name, parmsString);
            }
            IParseNode body = node.getChild(2);
            item = new JSOutlineItem(text, JSOutlineItem.Type.FUNCTION, (IRange)reference.getNameNode(), body, JSOutlineContentProvider.getChildrenCount(body));
            this.fItemsByScope.put(fullpath, item);
        }
        elements.add(item);
    }

    private void processIdentifier(Collection<JSOutlineItem> elements, IParseNode node) {
        IParseNode grandparent;
        IParseNode rhs;
        IParseNode parent = node.getParent();
        if (parent.getChildCount() > 1 && (rhs = parent.getChild(1)) == node && (grandparent = parent.getParent()) != null && grandparent.getChildCount() > 1) {
            IParseNode target = grandparent.getChild(1);
            switch (grandparent.getNodeType()) {
                case 61: {
                    target = grandparent.getChild(grandparent.getChildCount() - 1);
                    Reference reference = new Reference(parent, rhs, rhs.getText(), PROPERTY_TYPE);
                    String parentFullPath = reference.toString();
                    int size = target.getChildCount();
                    int i = 0;
                    while (i < size) {
                        IParseNode keyValuePair = target.getChild(i);
                        IParseNode key = keyValuePair.getChild(0);
                        String keyString = key.toString();
                        Reference keyValueReference = new Reference(parentFullPath, key, keyString, PROPERTY_TYPE);
                        this.addVirtualChild(elements, keyValueReference, node, keyValuePair);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    Reference reference = new Reference(parent, rhs, rhs.getText(), PROPERTY_TYPE);
                    while (target.getNodeType() == 1) {
                        target = target.getChild(1);
                    }
                    this.addValue(elements, reference, target);
                    break;
                }
                case 48: {
                    IParseNode property = grandparent.getChild(1);
                    Reference reference = new Reference(grandparent, property, property.getText(), PROPERTY_TYPE);
                    this.addVirtualChild(elements, reference, node, target);
                }
            }
        }
    }

    private void processInvoke(Collection<JSOutlineItem> elements, IParseNode node) {
        block22: {
            IParseNode args;
            IParseNode lhs;
            block21: {
                IParseNode args2;
                block23: {
                    lhs = node.getChild(0);
                    String source = lhs.toString();
                    if (!CLASS_EXTENDERS.contains(source)) break block21;
                    args2 = node.getChild(1);
                    if (args2.getNodeType() != 61) break block22;
                    if (args2.getChildCount() != 2) break block23;
                    IParseNode arg1 = args2.getChild(0);
                    IParseNode arg2 = args2.getChild(1);
                    if (arg2.getNodeType() != 77) break block22;
                    switch (arg1.getNodeType()) {
                        case 17: 
                        case 19: 
                        case 48: {
                            this.processAssignment(elements, arg1, arg2);
                        }
                    }
                    break block22;
                }
                if (args2.getChildCount() != 3) break block22;
                IParseNode arg1 = args2.getChild(0);
                IParseNode arg3 = args2.getChild(2);
                if (arg3.getNodeType() == 77) {
                    switch (arg1.getNodeType()) {
                        case 17: 
                        case 19: 
                        case 48: {
                            this.processAssignment(elements, arg1, arg3);
                        }
                    }
                }
                break block22;
            }
            if (lhs.getNodeType() == 58) {
                IParseNode[] nodes;
                IParseNode[] iParseNodeArray = nodes = lhs.getChildren();
                int n = nodes.length;
                int arg3 = 0;
                while (arg3 < n) {
                    IParseNode node2 = iParseNodeArray[arg3];
                    if (node2.getNodeType() == 70 && (node.getNodeType() != 70 || node.getText().length() == 0)) {
                        IParseNode[] grandChildren;
                        IParseNode[] iParseNodeArray2 = grandChildren = node2.getChildren();
                        int n2 = grandChildren.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            IParseNode node3 = iParseNodeArray2[n3];
                            this.processNode(elements, node3);
                            ++n3;
                        }
                    } else {
                        this.processNode(elements, node2);
                    }
                    ++arg3;
                }
            } else if (lhs.getNodeType() == 70) {
                if (node.getNodeType() != 70 || node.getText().length() == 0) {
                    IParseNode[] children;
                    IParseNode[] iParseNodeArray = children = lhs.getChildren();
                    int n = children.length;
                    int arg3 = 0;
                    while (arg3 < n) {
                        IParseNode node2 = iParseNodeArray[arg3];
                        this.processNode(elements, node2);
                        ++arg3;
                    }
                } else {
                    this.processNode(elements, lhs);
                }
            } else if (lhs.getNodeType() == 19 && (args = node.getChild(1)).getNodeType() == 61) {
                int count = args.getChildCount();
                int i = 0;
                while (i < count) {
                    IParseNode node2 = args.getChild(i);
                    if (node2.getNodeType() == 70) {
                        this.processFunction(elements, node2, new Reference(node2, node2, MessageFormat.format("{0}(@{1}:{2})", lhs.getText(), i, FUNCTION_LITERAL), ""));
                    }
                    ++i;
                }
            }
        }
    }

    private void processNameValuePair(Collection<JSOutlineItem> elements, IParseNode node) {
        IParseNode property = node.getChild(0);
        String name = property.getText();
        if (property.getNodeType() == 17) {
            name = name.substring(1, name.length() - 1);
        }
        IParseNode value = node.getChild(1);
        JSOutlineItem.Type type = JSOutlineContentProvider.getOutlineType(value);
        switch (value.getNodeType()) {
            case 70: {
                this.processFunction(elements, value, new Reference(value, property, name, ""));
                break;
            }
            case 77: {
                elements.add(new JSOutlineItem(name, type, (IRange)property, value, value.getChildCount()));
                break;
            }
            default: {
                elements.add(new JSOutlineItem(name, type, (IRange)property, value));
            }
        }
    }

    private void processStatements(Collection<JSOutlineItem> elements, IParseNode node) {
        short childType;
        IParseNode child;
        int size = node.getChildCount();
        int i = 0;
        while (i < size) {
            child = node.getChild(i);
            if (child.getNodeType() == 70 && child.getText().length() > 0) {
                this.processNode(elements, child);
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            child = node.getChild(i);
            if (child.getNodeType() == 86) {
                this.processNode(elements, child);
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            child = node.getChild(i);
            if (child.getNodeType() == 64) {
                this.processNode(elements, child);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < size) {
            child = node.getChild(i2);
            childType = child.getNodeType();
            if (childType == 1 || childType == 19 || childType == 76 || childType == 62 || childType == 58 || childType == 85) {
                this.processNode(elements, child);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < size) {
            child = node.getChild(i2);
            childType = child.getNodeType();
            if (childType == 65 || childType == 66) {
                this.processNode(elements, child);
            }
            ++i2;
        }
    }

    private void processVar(Collection<JSOutlineItem> elements, IParseNode node) {
        int size = node.getChildCount();
        int i = 0;
        while (i < size) {
            IParseNode declaration = node.getChild(i);
            IParseNode identifier = declaration.getChild(0);
            IParseNode value = declaration.getChild(1);
            if (value.getNodeType() != 0) {
                while (value.getNodeType() == 1) {
                    value = value.getChild(1);
                }
            }
            Reference reference = new Reference(node, identifier, identifier.getText(), CONTAINER_TYPE);
            this.addValue(elements, reference, value, node);
            ++i;
        }
    }

    private static int getChildrenCount(IParseNode node) {
        int result = 0;
        int size = node.getChildCount();
        int i = 0;
        while (i < size) {
            IParseNode child = node.getChild(i);
            switch (child.getNodeType()) {
                case 1: {
                    boolean ofInterest;
                    IParseNode lhs = child.getChild(0);
                    IParseNode rhs = child.getChild(1);
                    short lhsTypeIndex = lhs.getNodeType();
                    short rhsTypeIndex = rhs.getNodeType();
                    boolean identifierOrProperty = lhsTypeIndex == 19 || lhsTypeIndex == 48;
                    boolean bl = ofInterest = rhsTypeIndex == 70 || rhsTypeIndex == 77 || rhsTypeIndex == 62;
                    if (!identifierOrProperty || !ofInterest) break;
                    ++result;
                    break;
                }
                case 64: 
                case 70: {
                    ++result;
                    break;
                }
                case 21: 
                case 65: 
                case 66: 
                case 86: {
                    result += JSOutlineContentProvider.getChildrenCount(child);
                    break;
                }
                case 85: {
                    IParseNode grandchild;
                    if (child.getChildCount() <= 0 || (grandchild = child.getChild(0)).getNodeType() != 77) break;
                    ++result;
                    break;
                }
                case 62: {
                    IParseNode args;
                    if (child.getChildCount() <= 0) break;
                    IParseNode grandchild = child.getChild(0);
                    if (grandchild.getNodeType() == 70) {
                        ++result;
                        break;
                    }
                    if (grandchild.getNodeType() != 19 || child.getChildCount() <= 1 || (args = child.getChild(1)).getNodeType() != 61) break;
                    int count = args.getChildCount();
                    int j = 0;
                    while (j < count) {
                        if (args.getChild(j).getNodeType() == 70) {
                            ++result;
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    private static JSOutlineItem.Type getOutlineType(IParseNode node) {
        switch (node.getNodeType()) {
            case 73: {
                return JSOutlineItem.Type.ARRAY;
            }
            case 14: 
            case 15: {
                return JSOutlineItem.Type.BOOLEAN;
            }
            case 70: {
                return JSOutlineItem.Type.FUNCTION;
            }
            case 13: {
                return JSOutlineItem.Type.NULL;
            }
            case 16: {
                return JSOutlineItem.Type.NUMBER;
            }
            case 77: {
                return JSOutlineItem.Type.OBJECT_LITERAL;
            }
            case 18: {
                return JSOutlineItem.Type.REGEX;
            }
            case 17: {
                return JSOutlineItem.Type.STRING;
            }
        }
        return JSOutlineItem.Type.PROPERTY;
    }
}

