/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.inferencing.IInvocationProcessor;
import com.aptana.editor.js.inferencing.JQueryInvocationProcessor;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSPropertyCollector;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.frameworks.ExtApplyInvocationProcessor;
import com.aptana.editor.js.inferencing.frameworks.JSObjectInvocationProcessor;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSLabelledNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSSymbolCollector
extends JSTreeWalker {
    private static List<IInvocationProcessor> PROCESSORS;
    private static Map<String, IInvocationProcessor> INVOCATION_PROCESSORS;
    private JSScope _scope = new JSScope();
    private boolean buildTypeTable = true;
    private boolean recordCallExpress = false;
    private boolean isDelay = false;

    private static synchronized IInvocationProcessor getInvocationProcessor(String pattern) {
        if (INVOCATION_PROCESSORS == null) {
            INVOCATION_PROCESSORS = new HashMap<String, IInvocationProcessor>();
            for (IInvocationProcessor processor : JSSymbolCollector.getInvocationProcessors()) {
                for (String invocationPattern : processor.getInvocationPatterns()) {
                    INVOCATION_PROCESSORS.put(invocationPattern, processor);
                }
            }
        }
        return INVOCATION_PROCESSORS.get(pattern);
    }

    private static synchronized List<IInvocationProcessor> getInvocationProcessors() {
        if (PROCESSORS == null) {
            PROCESSORS = new ArrayList<IInvocationProcessor>();
            PROCESSORS.add(new JQueryInvocationProcessor());
            PROCESSORS.add(new ExtApplyInvocationProcessor());
            PROCESSORS.add(new JSObjectInvocationProcessor());
        }
        return PROCESSORS;
    }

    protected void accept(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    public void addPropertyValue(String name, JSNode value) {
        if (!StringUtil.isEmpty((String)name) && value != null) {
            JSPropertyCollection property = null;
            if (this._scope.hasLocalSymbol(name)) {
                property = this._scope.getLocalSymbol(name);
            } else if (this.isPotentialGlobalValue(value)) {
                if (this._scope.hasSymbol(name)) {
                    property = this._scope.getSymbol(name);
                } else {
                    JSScope scope = this._scope;
                    while (scope.getParentScope() != null) {
                        scope = scope.getParentScope();
                    }
                    property = new JSPropertyCollection();
                    scope.getObject().setProperty(name, property);
                    scope.getObject().applyReferenceSymbol(name, property);
                }
            } else {
                property = new JSPropertyCollection();
                this._scope.getObject().setProperty(name, property);
                this._scope.getObject().applyReferenceSymbol(name, property);
            }
            if (value instanceof JSObjectNode) {
                JSPropertyCollector collector = new JSPropertyCollector(property);
                collector.visit((JSObjectNode)value);
                if (this.isBuildTypeTable()) {
                    this.processClassObject(this._scope, property);
                }
            }
            property.addValue(value);
        }
    }

    public void addPropertyCall(String name, JSNode call) {
        if (!StringUtil.isEmpty((String)name) && call != null && this._scope.hasSymbol(name)) {
            JSPropertyCollection property = this._scope.getSymbol(name);
            property.addCall(call);
        }
    }

    private boolean isPotentialGlobalValue(JSNode node) {
        boolean result = true;
        if (node != null) {
            if (node.getNodeType() == 70 && !(node.getParent() instanceof JSAssignmentNode)) {
                result = false;
            } else {
                IParseNode parent = node.getParent();
                int nodeType = parent != null ? (int)parent.getNodeType() : -1;
                switch (nodeType) {
                    case 61: 
                    case 63: 
                    case 69: {
                        result = false;
                        break;
                    }
                    case 66: {
                        if (((JSCatchNode)parent).getIdentifier() == node) {
                            result = false;
                            break;
                        }
                    }
                    case 1: {
                        JSGetPropertyNode getNode;
                        JSAssignmentNode assginNode = (JSAssignmentNode)parent;
                        IParseNode lhs = assginNode.getLeftHandSide();
                        if (!(lhs instanceof JSGetPropertyNode) || !((getNode = (JSGetPropertyNode)lhs).getLeftHandSide() instanceof JSThisNode)) break;
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public JSScope getScope() {
        return this._scope;
    }

    protected void popScope() {
        if (this._scope != null) {
            if (this.isBuildTypeTable()) {
                this.processClassFunction(this._scope);
            }
            if (this.isRecordCallExpress()) {
                this.processCallExpress(this._scope);
            }
            this._scope = this._scope.getParentScope();
        }
        if (this.isDelay) {
            BuildHelper.waitByTimeGap();
        }
    }

    public void processCallExpress(JSScope scope) {
        if (scope != null) {
            List<JSNode> calls = scope.getObject().getCalls();
            for (JSNode call : calls) {
                this.addPropertyCall(call.getText(), call);
            }
        }
    }

    @Override
    public void visit(JSGetElementNode node) {
        super.visit(node);
        if (this.isRecordCallExpress()) {
            this.recordCallExpress(node.getLeftHandSide());
        }
    }

    protected void processClassFunction(JSScope scope) {
        IParseNode sNode = (IParseNode)scope.getRange();
        if (sNode.getParent() instanceof JSFunctionNode) {
            JSFunctionNode fNode = (JSFunctionNode)sNode.getParent();
            String fName = null;
            if (fNode.getName() != null && !(fNode.getName() instanceof JSEmptyNode)) {
                fName = fNode.getName().getText();
            } else {
                switch (fNode.getParent().getNodeType()) {
                    case 1: {
                        JSAssignmentNode assignNode = (JSAssignmentNode)fNode.getParent();
                        fName = assignNode.getLeftHandSide().getText();
                        break;
                    }
                    case 63: {
                        JSDeclarationNode declarNode = (JSDeclarationNode)fNode.getParent();
                        fName = declarNode.getIdentifier().getText();
                        break;
                    }
                }
            }
            if (StringUtil.isNotEmpty(fName)) {
                JSPropertyCollection classProps = scope.getLocalSymbol("this");
                scope.getParentScope().addType(fName, classProps);
            }
        }
    }

    protected void pushScope() {
        JSScope childScope = new JSScope();
        if (this._scope != null) {
            this._scope.addScope(childScope);
        }
        this._scope = childScope;
    }

    protected void setScopeRange(IRange range) {
        if (this._scope != null) {
            this._scope.setRange(range);
        }
    }

    @Override
    public void visit(JSAssignmentNode node) {
        IParseNode rhs;
        IParseNode lhs = node.getLeftHandSide();
        block0 : switch (lhs.getNodeType()) {
            case 19: {
                if (node.getRightHandSide() == null || !(node.getRightHandSide() instanceof JSNode)) break;
                this.addPropertyValue(lhs.getText(), (JSNode)node.getRightHandSide());
                break;
            }
            default: {
                while (lhs != null) {
                    switch (lhs.getNodeType()) {
                        case 19: {
                            if (!this._scope.hasLocalSymbol(lhs.getText())) {
                                if (this._scope.hasSymbol(lhs.getText())) {
                                    JSPropertyCollection propertyCollection = this._scope.getSymbol(lhs.getText());
                                    if (propertyCollection == null) break block0;
                                    JSPropertyCollector collector = new JSPropertyCollector(propertyCollection.getParentProperty());
                                    collector.visit(node);
                                    break block0;
                                }
                                JSScope globalScope = this._scope;
                                while (globalScope.getParentScope() != null) {
                                    globalScope = globalScope.getParentScope();
                                }
                                JSPropertyCollector collector = new JSPropertyCollector(globalScope.getObject());
                                collector.visit(node);
                                break block0;
                            }
                            JSPropertyCollector collector = new JSPropertyCollector(this._scope.getObject());
                            collector.visit(node);
                            break block0;
                        }
                        case 20: {
                            JSPropertyCollector collector = new JSPropertyCollector(this._scope.getObject());
                            collector.visit(node);
                            break block0;
                        }
                        default: {
                            lhs = lhs.getFirstChild();
                        }
                    }
                }
                break block0;
            }
        }
        if ((rhs = node.getRightHandSide()) != null) {
            this.accept(rhs);
            if (this.isRecordCallExpress()) {
                this.recordCallExpress(rhs);
            }
        }
    }

    @Override
    public void visit(JSNameValuePairNode node) {
        super.visit(node);
        if (this.isRecordCallExpress()) {
            this.recordCallExpress(node.getValue());
        }
    }

    @Override
    public void visit(JSCatchNode node) {
        this.pushScope();
        this.setScopeRange((IRange)node.getBody());
        IParseNode id = node.getIdentifier();
        if (id instanceof JSNode) {
            this.addPropertyValue(id.getText(), (JSNode)id);
        }
        this.popScope();
        this.accept(node.getBody());
    }

    @Override
    public void visit(JSDeclarationNode node) {
        String name = node.getIdentifier().getText();
        IParseNode value = node.getValue();
        if (value instanceof JSNode) {
            this.addPropertyValue(name, (JSNode)value);
        }
        this.accept(value);
    }

    @Override
    public void visit(JSFunctionNode node) {
        IParseNode args;
        String name = node.getName().getText();
        if (!StringUtil.isEmpty((String)name)) {
            this.addPropertyValue(name, node);
        }
        IParseNode body = node.getBody();
        this.pushScope();
        this.setScopeRange((IRange)body);
        IParseNode params = node.getParameters();
        if (node.getParent() instanceof JSGroupNode && (args = node.getParent().getParent().getLastChild()) instanceof JSArgumentsNode) {
            int count = Math.min(params.getChildCount(), args.getChildCount());
            int i = 0;
            while (i < count) {
                IParseNode identifier = params.getChild(i);
                IParseNode value = args.getChild(i);
                if (value instanceof JSNode) {
                    this.addPropertyValue(identifier.getText(), (JSNode)value);
                    this.addReferenceSymbol(this._scope.getLocalSymbol(identifier.getText()), value);
                }
                ++i;
            }
        }
        for (IParseNode parameter : node.getParameters()) {
            if (!(parameter instanceof JSNode)) continue;
            this.addPropertyValue(parameter.getText(), (JSNode)parameter);
        }
        this.accept(body);
        this.popScope();
    }

    protected void addReferenceSymbol(JSPropertyCollection localSymbol, IParseNode value) {
        if (localSymbol == null || value == null) {
            return;
        }
        switch (value.getNodeType()) {
            case 19: {
                JSPropertyCollection reference = this._scope.getSymbol(value.getText());
                if (reference == null) break;
                localSymbol.setReferenceSymbol(reference);
                break;
            }
            case 48: {
                String symbol;
                JSPropertyCollection firstPkg;
                JSGetPropertyNode getNode = (JSGetPropertyNode)value;
                IParseNode lhs = null;
                while (getNode.getLeftHandSide() != null) {
                    lhs = getNode.getLeftHandSide();
                    if (lhs instanceof JSThisNode) {
                        lhs = getNode.getRightHandSide();
                    }
                    if (lhs instanceof JSIdentifierNode || !(lhs instanceof JSGetPropertyNode)) break;
                    getNode = (JSGetPropertyNode)lhs;
                }
                if (lhs == null || !(lhs instanceof JSIdentifierNode) || (firstPkg = this._scope.getSymbol(symbol = lhs.getText())) == null) break;
                symbol = lhs.getParent().getChild(1).getText();
                break;
            }
        }
    }

    protected void checkReferenceSymbol(String funcName, JSPropertyCollection thisSymbolCollection) {
        JSPropertyCollection prop;
        if (StringUtil.isEmpty((String)funcName)) {
            return;
        }
        String[] pkgs = funcName.split("\\.");
        if (pkgs.length == 0) {
            return;
        }
        String leftVar = pkgs[0];
        if (this._scope.hasSymbol(leftVar) && (prop = this._scope.getSymbol(leftVar)).getReferenceSymbol() != null) {
            leftVar = prop.getReferenceSymbol().getName();
            int i = 1;
            while (i < pkgs.length) {
                leftVar = String.valueOf(leftVar) + "." + pkgs[i];
                ++i;
            }
            if (this._scope.getParentScope() != null) {
                this._scope.getParentScope().addType(leftVar, thisSymbolCollection);
            }
        }
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        this.accept(node.getLeftHandSide());
    }

    @Override
    public void visit(JSArgumentsNode node) {
        super.visit(node);
        if (this.isRecordCallExpress()) {
            Iterator iterator = node.iterator();
            while (iterator.hasNext()) {
                IParseNode child = (IParseNode)iterator.next();
                this.recordCallExpress(child);
            }
        }
    }

    @Override
    public void visit(JSInvokeNode node) {
        IInvocationProcessor processor;
        IParseNode expression = node.getExpression();
        boolean processed = false;
        if (this.isRecordCallExpress()) {
            this.recordCallExpress(expression);
        }
        if (expression instanceof JSGetPropertyNode && (processor = JSSymbolCollector.getInvocationProcessor(expression.toString())) != null) {
            processed = processor.processInvocation(this._scope, node);
        }
        if (!processed) {
            super.visit(node);
        }
    }

    private void recordCallExpress(IParseNode expr) {
        if (expr instanceof JSIdentifierNode) {
            JSIdentifierNode idNode = (JSIdentifierNode)expr;
            this._scope.getObject().addCall(idNode);
        }
    }

    @Override
    public void visit(JSLabelledNode node) {
        this.accept(node.getBlock());
    }

    @Override
    public void visit(JSParseRootNode node) {
        this.setScopeRange((IRange)node);
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            IParseNode child = (IParseNode)iterator.next();
            this.accept(child);
        }
    }

    @Override
    public void visit(JSWithNode node) {
        super.visit(node);
    }

    @Override
    public void visit(JSObjectNode node) {
        super.visit(node);
    }

    protected void processClassObject(JSScope scope, JSPropertyCollection property) {
        if (property != null && StringUtil.isNotEmpty((String)property.getName())) {
            scope.addType(property.getName(), property);
        }
    }

    public boolean isBuildTypeTable() {
        return this.buildTypeTable;
    }

    public boolean isRecordCallExpress() {
        return this.recordCallExpress;
    }

    public void setRecordCallExpress(boolean recordCallExpress) {
        this.recordCallExpress = recordCallExpress;
    }

    public void setBuildTypeTable(boolean buildTypeTable) {
        this.buildTypeTable = buildTypeTable;
    }

    public void setDelay(boolean delay) {
        this.isDelay = delay;
    }
}

