/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;

public class AttrNameInferrer
extends JSTreeWalker {
    private static final String GET_ATTR_METHOD = "getAttribute";
    private String attrName = null;

    @Override
    public void visit(JSIdentifierNode node) {
        String varName = node.getText();
        JSScope localScope = ParseUtil.getScopeAtOffset((IParseNode)node, node.getStartingOffset());
        JSPropertyCollection props = localScope.getSymbol(varName);
        if (props != null && props.getValues() != null) {
            for (JSNode value : props.getValues()) {
                value.accept(this);
            }
        }
    }

    @Override
    public void visit(JSInvokeNode node) {
        JSArgumentsNode argsNode;
        JSGetPropertyNode getNode;
        IParseNode exprNode = node.getExpression();
        if (exprNode instanceof JSGetPropertyNode && GET_ATTR_METHOD.equals((getNode = (JSGetPropertyNode)exprNode).getRightHandSide().getText()) && (argsNode = (JSArgumentsNode)node.getArguments()).hasChildren()) {
            this.visit((JSNode)argsNode.getFirstChild());
        }
    }

    @Override
    public void visit(JSStringNode node) {
        this.setAttrName(node.getString());
    }

    public void setAttrName(String attrName) {
        if (StringUtil.isEmpty((String)this.attrName)) {
            this.attrName = attrName;
        }
    }

    public String getAttrName() {
        return this.attrName;
    }
}

