/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.convertor;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.convertor.ConvertorContext;
import com.aptana.editor.js.htmlext.IHTMLDomAssist;
import com.aptana.editor.js.inferencing.ITypeConvertor;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.utils.DOMAssistUtils;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JQueryTypeConvertor
implements ITypeConvertor {
    @Override
    public List<TypeElement> convert(ConvertorContext context, JSGetPropertyNode node, List<TypeElement> typeElements) {
        return null;
    }

    @Override
    public List<TypeElement> convert(ConvertorContext context, JSInvokeNode node, List<TypeElement> typeElements) {
        IParseNode children;
        JSArgumentsNode argsNode;
        ArrayList<TypeElement> types = new ArrayList<TypeElement>(2);
        if (!(node.getParent() instanceof JSGetElementNode)) {
            return types;
        }
        if ((JSTypeUtil.hasType(typeElements, "$") || JSTypeUtil.hasType(typeElements, "jQuery")) && (argsNode = (JSArgumentsNode)node.getArguments()).hasChildren() && (children = argsNode.getChild(0)) instanceof JSStringNode) {
            JSStringNode strNode = (JSStringNode)children;
            String queryString = strNode.getString();
            if (StringUtil.isEmpty((String)queryString)) {
                return types;
            }
            Document doc = Jsoup.parse((String)context.getEditor().getDocument().get());
            Elements elements = doc.select(queryString);
            ArrayList<String> tags = new ArrayList<String>();
            for (Element el : elements) {
                tags.add(el.nodeName());
            }
            List<IHTMLDomAssist> domAssists = DOMAssistUtils.getDOMAssists();
            if (!CollectionsUtil.isEmpty(domAssists)) {
                IHTMLDomAssist domAssist = domAssists.get(0);
                List<String> domTypes = domAssist.getDOMTypesByTags(tags);
                for (String domType : domTypes) {
                    types.add(JSTypeUtil.createEmptyType(domType));
                }
            }
        }
        return types;
    }
}

