/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.rule;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.htmlext.IURIProposalRule;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.List;

public class AssignmentURIProposalRule
implements IURIProposalRule {
    private String typeName = null;
    private String propertyName = null;

    public AssignmentURIProposalRule(String typeName, String propertyName) {
        this.typeName = typeName;
        this.propertyName = propertyName;
    }

    @Override
    public boolean match(Index projectIndex, URI fileURI, JSStringNode node, int offset) {
        if (node.getParent() instanceof JSAssignmentNode) {
            JSAssignmentNode assignNode = (JSAssignmentNode)node.getParent();
            IParseNode parseNode = assignNode.getLeftHandSide();
            String leftVar = parseNode.toString();
            if (StringUtil.isEmpty((String)this.typeName) && this.propertyName.equals(leftVar)) {
                return true;
            }
            if (StringUtil.isNotBlank((String)this.typeName) && StringUtil.isNotEmpty((String)this.propertyName) && (String.valueOf(this.typeName) + "." + this.propertyName).equals(leftVar)) {
                return true;
            }
            if (parseNode instanceof JSGetPropertyNode) {
                JSGetPropertyNode getPropertyNode = (JSGetPropertyNode)parseNode;
                offset = getPropertyNode.getStartingOffset() + 1;
                List<String> types = ParseUtil.getParentObjectTypes(projectIndex, fileURI, getPropertyNode.getRightHandSide(), getPropertyNode, offset);
                if (types != null && !types.isEmpty() && types.contains(this.typeName) && this.propertyName.equals(getPropertyNode.getRightHandSide().getText())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getType() {
        return this.typeName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }
}

