/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.HashMap;
import java.util.Map;

public class UserAgentElement
implements JSON.Convertible {
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String OS_VERSION_PROPERTY = "osVersion";
    private static final String OS_PROPERTY = "os";
    private static final String VERSION_PROPERTY = "version";
    private static final String PLATFORM_PROPERTY = "platform";
    private static final Map<Integer, UserAgentElement> INSTANCE_CACHE = new HashMap<Integer, UserAgentElement>();
    private String _platform;
    private String _version;
    private String _os;
    private String _osVersion;
    private String _description;

    public static void clearCache() {
        INSTANCE_CACHE.clear();
    }

    public static UserAgentElement createUserAgentElement(Map<?, ?> map) {
        String platform = StringUtil.getStringValue(map.get(PLATFORM_PROPERTY));
        String version = StringUtil.getStringValue(map.get(VERSION_PROPERTY));
        String os = StringUtil.getStringValue(map.get(OS_PROPERTY));
        String osVersion = StringUtil.getStringValue(map.get(OS_VERSION_PROPERTY));
        String description = StringUtil.getStringValue(map.get(DESCRIPTION_PROPERTY));
        return UserAgentElement.createUserAgentElement(platform, version, os, osVersion, description);
    }

    public static UserAgentElement createUserAgentElement(String platform) {
        return UserAgentElement.createUserAgentElement(platform, "", "", "", "");
    }

    public static UserAgentElement createUserAgentElement(String platform, String version, String os, String osVersion, String description) {
        UserAgentElement result;
        int hashCode = UserAgentElement.getHashCode(platform, version, os, osVersion, description);
        if (INSTANCE_CACHE.containsKey(hashCode)) {
            result = INSTANCE_CACHE.get(hashCode);
        } else {
            result = new UserAgentElement();
            result.setPlatform(platform);
            result.setVersion(version);
            result.setOS(os);
            result.setOSVersion(osVersion);
            result.setDescription(description);
            INSTANCE_CACHE.put(hashCode, result);
        }
        return result;
    }

    private static int getHashCode(String platform, String version, String os, String osVersion, String description) {
        int h = 0;
        h = platform != null ? platform.hashCode() : 0;
        h = h * 31 + (version != null ? version.hashCode() : 0);
        h = h * 31 + (os != null ? os.hashCode() : 0);
        h = h * 31 + (osVersion != null ? osVersion.hashCode() : 0);
        h = h * 31 + (description != null ? description.hashCode() : 0);
        return h;
    }

    public void fromJSON(Map object) {
        this.setPlatform(StringUtil.getStringValue(object.get(PLATFORM_PROPERTY)));
        this.setVersion(StringUtil.getStringValue(object.get(VERSION_PROPERTY)));
        this.setOS(StringUtil.getStringValue(object.get(OS_PROPERTY)));
        this.setOSVersion(StringUtil.getStringValue(object.get(OS_VERSION_PROPERTY)));
        this.setDescription(StringUtil.getStringValue(object.get(DESCRIPTION_PROPERTY)));
    }

    public int hashCode() {
        return UserAgentElement.getHashCode(this._platform, this._version, this._os, this._osVersion, this._description);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserAgentElement) {
            UserAgentElement that = (UserAgentElement)obj;
            return ObjectUtil.areEqual((Object)this._platform, (Object)that._platform) && ObjectUtil.areEqual((Object)this._version, (Object)that._version) && ObjectUtil.areEqual((Object)this._os, (Object)that._os) && ObjectUtil.areEqual((Object)this._osVersion, (Object)that._osVersion) && ObjectUtil.areEqual((Object)this._description, (Object)that._description);
        }
        return super.equals(obj);
    }

    public String getDescription() {
        return StringUtil.getStringValue((Object)this._description);
    }

    public String getOS() {
        return StringUtil.getStringValue((Object)this._os);
    }

    public String getOSVersion() {
        return StringUtil.getStringValue((Object)this._osVersion);
    }

    public String getPlatform() {
        return StringUtil.getStringValue((Object)this._platform);
    }

    public String getVersion() {
        return StringUtil.getStringValue((Object)this._version);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setOS(String os) {
        this._os = os;
    }

    public void setOSVersion(String OSVersion) {
        this._osVersion = OSVersion;
    }

    public void setPlatform(String platform) {
        this._platform = platform;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void toJSON(JSON.Output out) {
        out.add(PLATFORM_PROPERTY, (Object)this.getPlatform());
        out.add(VERSION_PROPERTY, (Object)this.getVersion());
        out.add(OS_PROPERTY, (Object)this.getOS());
        out.add(OS_VERSION_PROPERTY, (Object)this.getOSVersion());
        out.add(DESCRIPTION_PROPERTY, (Object)this.getDescription());
    }

    public String toString() {
        return String.valueOf(this.getPlatform()) + "[" + this.getVersion() + "]:" + this.getOS();
    }
}

