/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.Messages;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyElement
extends BaseElement<Property> {
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String TYPES_PROPERTY = "types";
    private static final String IS_INTERNAL_PROPERTY = "isInternal";
    private static final String IS_INSTANCE_PROPERTY = "isInstanceProperty";
    private static final String IS_CLASS_PROPERTY = "isClassProperty";
    private static final String OWNING_TYPE_PROPERTY = "owningType";
    private static final String DEPRECATED_PROPERTY = "deprecated";
    private static final String DEFINE_JS_PROPERTY = "definejs";
    private static final String SOURCE_PATH = "source";
    private String _owningType;
    private boolean _isInstanceProperty;
    private boolean _isClassProperty;
    private boolean _isInternal;
    private List<ReturnTypeElement> _types;
    private List<String> _examples;
    private boolean _deprecated;
    private boolean _isDefine;
    private String _defineJS;
    private String source;
    private List<ValueElement> _values;

    public PropertyElement() {
    }

    public PropertyElement(PropertyElement base) {
        this._owningType = base.getOwningType();
        this._isInstanceProperty = base.isInstanceProperty();
        this._isClassProperty = base.isClassProperty();
        this._isInternal = base.isInternal();
        this._types = new ArrayList<ReturnTypeElement>(base.getTypes());
        this._examples = new ArrayList<String>(base.getExamples());
        this.setDescription(base.getDescription());
        this.setDefineJS(base.getDefineJS());
    }

    public void addExample(String example) {
        if (example != null && example.length() > 0) {
            if (this._examples == null) {
                this._examples = new ArrayList<String>();
            }
            this._examples.add(example);
        }
    }

    public void addValue(ValueElement value) {
        if (this._values == null) {
            this._values = new ArrayList<ValueElement>();
        }
        this._values.add(value);
    }

    public void addType(ReturnTypeElement type) {
        if (type != null) {
            int index;
            if (this._types == null) {
                this._types = new ArrayList<ReturnTypeElement>();
            }
            if ((index = this._types.indexOf(type)) != -1) {
                this._types.set(index, type);
            } else {
                this._types.add(type);
            }
        }
    }

    public void addType(String type) {
        if (type != null && type.length() > 0) {
            ReturnTypeElement returnType = new ReturnTypeElement();
            returnType.setType(type);
            this.addType(returnType);
        }
    }

    public int hashCode() {
        if (StringUtil.isNotEmpty((String)this.getOwningType())) {
            return (String.valueOf(this.getOwningType()) + this.toSource()).hashCode();
        }
        return this.toSource().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropertyElement) {
            PropertyElement other = (PropertyElement)obj;
            if (this.isClassProperty() != other.isClassProperty()) {
                return false;
            }
            if (this.isInternal() != other.isInternal()) {
                return false;
            }
            if (this.getName() != null && !this.getName().equals(other.getName()) || this.getName() == null && other.getName() != null) {
                return false;
            }
            List<String> types = this.getTypeNames();
            List<String> otherTypes = other.getTypeNames();
            return (types != null || otherTypes == null) && (types == null || types.equals(otherTypes));
        }
        return super.equals(obj);
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setOwningType(StringUtil.getStringValue(object.get(OWNING_TYPE_PROPERTY)));
        this.setIsClassProperty(Boolean.TRUE == object.get(IS_CLASS_PROPERTY));
        this.setIsInstanceProperty(Boolean.TRUE == object.get(IS_INSTANCE_PROPERTY));
        this.setDefineJS(StringUtil.getStringValue(object.get(DEFINE_JS_PROPERTY)));
        this.setSource(StringUtil.getStringValue(object.get(SOURCE_PATH)));
        this.setIsDeprecated(Boolean.TRUE == object.get(DEPRECATED_PROPERTY));
        this.setIsInternal(Boolean.TRUE == object.get(IS_INTERNAL_PROPERTY));
        this._types = IndexUtil.createList(object.get(TYPES_PROPERTY), ReturnTypeElement.class);
        this._examples = IndexUtil.createList(object.get(EXAMPLES_PROPERTY));
    }

    public List<String> getExamples() {
        return CollectionsUtil.getListValue(this._examples);
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public String getOwningType() {
        return StringUtil.getStringValue((Object)this._owningType);
    }

    public List<String> getTypeNames() {
        return CollectionsUtil.map(this.getTypes(), (IMap)new IMap<ReturnTypeElement, String>(){

            public String map(ReturnTypeElement item) {
                return item.getType();
            }
        });
    }

    public List<ReturnTypeElement> getTypes() {
        return CollectionsUtil.getListValue(this._types);
    }

    public boolean isClassProperty() {
        return this._isClassProperty;
    }

    public boolean isInstanceProperty() {
        return this._isInstanceProperty;
    }

    public boolean isInternal() {
        return this._isInternal;
    }

    public void setIsClassProperty(boolean value) {
        this._isClassProperty = value;
    }

    public void setIsInstanceProperty(boolean value) {
        this._isInstanceProperty = value;
    }

    public void setIsInternal(boolean value) {
        this._isInternal = value;
    }

    public void setOwningType(String type) {
        this._owningType = type;
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setIsDeprecated(boolean value) {
        this._deprecated = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isDefine() {
        return this._isDefine;
    }

    public void setIsDefine(boolean _isDefine) {
        if (StringUtil.isEmpty((String)this.source)) {
            this._isDefine = _isDefine;
        }
    }

    public String getDefineJS() {
        return this._defineJS;
    }

    public void setDefineJS(String _defineJS) {
        if (StringUtil.isEmpty((String)this.source)) {
            this._defineJS = _defineJS;
        }
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(OWNING_TYPE_PROPERTY, (Object)this.getOwningType());
        out.add(IS_CLASS_PROPERTY, this.isClassProperty());
        out.add(IS_INSTANCE_PROPERTY, this.isInstanceProperty());
        out.add(IS_INTERNAL_PROPERTY, this.isInternal());
        out.add(DEPRECATED_PROPERTY, this.isDeprecated());
        out.add(DEFINE_JS_PROPERTY, (Object)this.getDefineJS());
        out.add(SOURCE_PATH, (Object)this.getSource());
        out.add(TYPES_PROPERTY, this.getTypes());
        out.add(EXAMPLES_PROPERTY, this.getExamples());
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.printIndent();
        if (this.isClassProperty()) {
            printer.print("static ");
        }
        if (this.isInternal()) {
            printer.print("internal ");
        }
        printer.print(this.getName());
        printer.print(" : ");
        List<String> types = this.getTypeNames();
        if (types != null && types.size() > 0) {
            printer.print(StringUtil.join((String)",", this.getTypeNames()));
        } else {
            printer.print("undefined");
        }
    }

    public String toString() {
        return this.toSource();
    }

    public List<ValueElement> getValues() {
        return this._values;
    }

    static enum Property implements IPropertyInformation<PropertyElement>
    {
        NAME(Messages.PropertyElement_Name){

            public Object getPropertyValue(PropertyElement node) {
                return node.getName();
            }
        }
        ,
        DESCRIPTION(Messages.PropertyElement_Description){

            public Object getPropertyValue(PropertyElement node) {
                return node.getDescription();
            }
        }
        ,
        OWNING_TYPE(Messages.PropertyElement_OwningType){

            public Object getPropertyValue(PropertyElement node) {
                return node.getOwningType();
            }
        }
        ,
        CLASS_PROPERTY(Messages.PropertyElement_StaticProperty){

            public Object getPropertyValue(PropertyElement node) {
                return node._isClassProperty;
            }
        }
        ,
        INSTANCE_PROPERTY(Messages.PropertyElement_InstanceProperty){

            public Object getPropertyValue(PropertyElement node) {
                return node._isInstanceProperty;
            }
        }
        ,
        RETURN_TYPES(Messages.PropertyElement_ReturnTypes){

            public Object getPropertyValue(PropertyElement node) {
                if (node instanceof FunctionElement) {
                    return StringUtil.join((String)", ", ((FunctionElement)node).getReturnTypeNames());
                }
                return "";
            }
        }
        ,
        TYPES(Messages.PropertyElement_Types){

            public Object getPropertyValue(PropertyElement node) {
                return StringUtil.join((String)", ", node.getTypeNames());
            }
        }
        ,
        DOCUMENTS(Messages.PropertyElement_Documents){

            public Object getPropertyValue(PropertyElement node) {
                return StringUtil.join((String)", ", node.getDocuments());
            }
        }
        ,
        DEPRECATED(Messages.TypeElement_Deprecated){

            public Object getPropertyValue(PropertyElement node) {
                return node.isDeprecated();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

