/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.EventPropertyElement;
import com.aptana.editor.js.contentassist.model.Messages;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventElement
extends BaseElement<Property> {
    private static final String OWNING_TYPE_PROPERTY = "owningType";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String DEPRECATED_PROPERTY = "deprecated";
    private String _owningType;
    private List<EventPropertyElement> _properties;
    private boolean _deprecated;

    public void addProperty(EventPropertyElement property) {
        if (property != null) {
            if (this._properties == null) {
                this._properties = new ArrayList<EventPropertyElement>();
            }
            this._properties.add(property);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        if (object.containsKey(PROPERTIES_PROPERTY)) {
            List properties = IndexUtil.createList(object.get(PROPERTIES_PROPERTY), EventPropertyElement.class);
            for (EventPropertyElement property : properties) {
                this.addProperty(property);
            }
        }
        this.setIsDeprecated(Boolean.TRUE == object.get(DEPRECATED_PROPERTY));
    }

    public String getOwningType() {
        return StringUtil.getStringValue((Object)this._owningType);
    }

    public List<EventPropertyElement> getProperties() {
        return CollectionsUtil.getListValue(this._properties);
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public void setOwningType(String type) {
        this._owningType = type;
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setIsDeprecated(boolean value) {
        this._deprecated = value;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(OWNING_TYPE_PROPERTY, (Object)this.getOwningType());
        out.add(DEPRECATED_PROPERTY, this.isDeprecated());
        out.add(PROPERTIES_PROPERTY, this.getProperties());
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.printIndent();
        printer.print("event ");
        printer.print(this.getName());
        printer.println(" {");
        printer.increaseIndent();
        for (EventPropertyElement property : this.getProperties()) {
            property.toSource(printer);
            printer.println(';');
        }
        printer.decreaseIndent();
        printer.printWithIndent('}');
    }

    static enum Property implements IPropertyInformation<EventElement>
    {
        NAME(Messages.EventElement_Name){

            public Object getPropertyValue(EventElement node) {
                return node.getName();
            }
        }
        ,
        OWNING_TYPE(Messages.EventElement_OwningType){

            public Object getPropertyValue(EventElement node) {
                return node.getOwningType();
            }
        }
        ,
        PROPERTY_COUNT(Messages.EventElement_PropertyCount){

            public Object getPropertyValue(EventElement node) {
                return node.getProperties().size();
            }
        }
        ,
        DEPRECATED(Messages.TypeElement_Deprecated){

            public Object getPropertyValue(EventElement node) {
                return node.isDeprecated();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

