/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.model;

import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.index.JSIndexReader;
import com.aptana.editor.js.contentassist.model.BaseElement;
import com.aptana.editor.js.contentassist.model.ClassElement;
import com.aptana.editor.js.contentassist.model.Messages;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.index.core.CategoryInfo;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassGroupElement
extends BaseElement<Property> {
    private Index index;
    private List<ClassElement> classes;
    private int typeCount = -1;
    private CategoryInfo typeInfo;
    private CategoryInfo propertyInfo;
    private CategoryInfo functionInfo;

    public ClassGroupElement(String name, Index index) {
        this.index = index;
        this.setName(name);
    }

    public int getClassCount() {
        if (this.typeCount == -1) {
            JSIndexReader reader = new JSIndexReader();
            List<String> typeNames = reader.getTypeNames(this.index);
            HashSet<String> mergedTypeNames = new HashSet<String>();
            for (String typeName : typeNames) {
                boolean isClassType = JSTypeUtil.isClassType(typeName);
                String baseName = isClassType ? JSTypeUtil.getClassType(typeName) : typeName;
                mergedTypeNames.add(baseName);
            }
            this.typeCount = mergedTypeNames.size();
        }
        return this.typeCount;
    }

    public List<ClassElement> getClasses() {
        if (this.classes == null) {
            JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
            List<TypeElement> types = queryHelper.getTypes(this.index);
            this.classes = JSTypeUtil.typesToClasses(types);
        }
        return this.classes;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public CategoryInfo getFunctionInfo() {
        if (this.functionInfo == null) {
            JSIndexReader reader = new JSIndexReader();
            this.functionInfo = reader.getCategoryInfo(this.index, "js.function");
        }
        return this.functionInfo;
    }

    public CategoryInfo getPropertyInfo() {
        if (this.propertyInfo == null) {
            JSIndexReader reader = new JSIndexReader();
            this.propertyInfo = reader.getCategoryInfo(this.index, "js.property");
        }
        return this.propertyInfo;
    }

    public CategoryInfo getTypeInfo() {
        if (this.typeInfo == null) {
            JSIndexReader reader = new JSIndexReader();
            this.typeInfo = reader.getCategoryInfo(this.index, "js.type");
        }
        return this.typeInfo;
    }

    public boolean hasChildren() {
        return this.getTypeInfo().count > 0;
    }

    static enum Category {
        COUNTS(Messages.ClassGroupElement_Counts),
        MINS(Messages.ClassGroupElement_MinLengths),
        MAXS(Messages.ClassGroupElement_MaxLengths),
        SUMS(Messages.ClassGroupElement_Sums),
        MEDIANS(Messages.ClassGroupElement_Medians),
        AVERAGES(Messages.ClassGroupElement_Averages);

        private String name;

        private Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static enum Property implements IPropertyInformation<ClassGroupElement>
    {
        CLASS_COUNT(Messages.ClassGroupElement_ClassCount, Category.COUNTS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getClassCount();
            }
        }
        ,
        RAW_TYPE_COUNT(Messages.ClassGroupElement_TypeCount, Category.COUNTS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getTypeInfo().count;
            }
        }
        ,
        MIN_TYPE_LENGTH(Messages.ClassGroupElement_TypeMinLength, Category.MINS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getTypeInfo().minLength;
            }
        }
        ,
        MAX_TYPE_LENGTH(Messages.ClassGroupElement_TypeMaxLength, Category.MAXS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getTypeInfo().maxLength;
            }
        }
        ,
        SUM_TYPE_LENGTHS(Messages.ClassGroupElement_TypeLengthSums, Category.SUMS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getTypeInfo().sum;
            }
        }
        ,
        MEDIAN_TYPE_LENGTH(Messages.ClassGroupElement_TypeMedianLength, Category.MEDIANS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getTypeInfo().median;
            }
        }
        ,
        AVERAGE_TYPE_LENGTH(Messages.ClassGroupElement_TypeAverageLength, Category.AVERAGES){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getTypeInfo().average;
            }
        }
        ,
        RAW_PROPERTY_COUNT(Messages.ClassGroupElement_PropertyCount, Category.COUNTS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getPropertyInfo().count;
            }
        }
        ,
        MIN_PROPERTY_LENGTH(Messages.ClassGroupElement_PropertyMinLength, Category.MINS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getPropertyInfo().minLength;
            }
        }
        ,
        MAX_PROPERTY_LENGTH(Messages.ClassGroupElement_PropertyMaxLength, Category.MAXS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getPropertyInfo().maxLength;
            }
        }
        ,
        SUM_PROPERTY_LENGTHS(Messages.ClassGroupElement_PropertyLengthSums, Category.SUMS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getPropertyInfo().sum;
            }
        }
        ,
        MEDIAN_PROPERTY_LENGTH(Messages.ClassGroupElement_PropertyMedianLength, Category.MEDIANS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getPropertyInfo().median;
            }
        }
        ,
        AVERAGE_PROPERTY_LENGTH(Messages.ClassGroupElement_PropertyAverageLength, Category.AVERAGES){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getPropertyInfo().average;
            }
        }
        ,
        RAW_FUNCTION_COUNT(Messages.ClassGroupElement_MethodCount, Category.COUNTS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getFunctionInfo().count;
            }
        }
        ,
        MIN_FUNCTION_LENGTH(Messages.ClassGroupElement_MethodMinLength, Category.MINS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getFunctionInfo().minLength;
            }
        }
        ,
        MAX_FUNCTION_LENGTH(Messages.ClassGroupElement_MethodMaxLength, Category.MAXS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getFunctionInfo().maxLength;
            }
        }
        ,
        SUM_FUNCTION_LENGTH(Messages.ClassGroupElement_MethodLengthSums, Category.SUMS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getFunctionInfo().sum;
            }
        }
        ,
        MEDIAN_FUNCTION_LENGTH(Messages.ClassGroupElement_MethodMedianLength, Category.MEDIANS){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getFunctionInfo().median;
            }
        }
        ,
        AVERAGE_FUNCTION_LENGTH(Messages.ClassGroupElement_MethodAverageLength, Category.AVERAGES){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getFunctionInfo().average;
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, Category category) {
            this.header = header;
            this.category = category.getName();
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

