/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.inferencing;

import com.aptana.core.GetPropertor;
import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.JSTypeConstants;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.FunctionTypeElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSymbolTypeInferrer;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JSAssistSymbolTypeInferrer
extends JSSymbolTypeInferrer<TypeElement> {
    private String contextType = null;
    private boolean writeSubType = false;
    private List<TypeElement> _typeElements = new ArrayList<TypeElement>(5);

    public JSAssistSymbolTypeInferrer() {
    }

    public JSAssistSymbolTypeInferrer(JSScope activeScope, Index index, URI location, boolean writeSubType) {
        super(activeScope, index, location);
        this.writeSubType = writeSubType;
    }

    public boolean isWriteSubType() {
        return this.writeSubType;
    }

    public void setWriteSubType(boolean writeSubType) {
        this.writeSubType = writeSubType;
    }

    @Override
    protected PropertyElement createPropertyElement(Set<TypeElement> types) {
        Set typeNames;
        if (!CollectionsUtil.isEmpty(types) && !CollectionsUtil.isEmpty((Collection)(typeNames = CollectionsUtil.getPropertyList(types, (GetPropertor)new GetPropertor<TypeElement, String>(){

            public String getProperty(TypeElement obj) {
                if (obj != null) {
                    return obj.getName();
                }
                return "";
            }
        })))) {
            if (typeNames.contains("Function")) {
                return new FunctionElement();
            }
            for (String typeName : typeNames) {
                if (!typeName.startsWith("Function")) continue;
                return new FunctionElement();
            }
        }
        return new PropertyElement();
    }

    @Override
    protected JSSymbolTypeInferrer<TypeElement> createSymbolTypeInferrer() {
        return new JSAssistSymbolTypeInferrer(this.activeScope, this.index, this.location, this.writeSubType);
    }

    @Override
    public List<PropertyElement> getScopeProperties() {
        List<String> symbolNames = this.activeScope.getLocalSymbolNames();
        return CollectionsUtil.map(symbolNames, (IMap)new IMap<String, PropertyElement>(){

            public PropertyElement map(String symbol) {
                JSAssistSymbolTypeInferrer symbolTypeInferrer = (JSAssistSymbolTypeInferrer)JSAssistSymbolTypeInferrer.this.createSymbolTypeInferrer();
                PropertyElement prop = symbolTypeInferrer.getSymbolPropertyElement(symbol);
                List<TypeElement> types = symbolTypeInferrer.getTypeElements();
                if (!CollectionsUtil.isEmpty(types)) {
                    for (TypeElement type : types) {
                        prop.addType(type.getName());
                    }
                }
                return prop;
            }
        });
    }

    @Override
    protected void useCachedTypes(Set<TypeElement> types, JSPropertyCollection property) {
        types.addAll(property.getTypes());
        this._typeElements.addAll(types);
    }

    @Override
    protected void cachedTypes(Set<TypeElement> types, JSPropertyCollection property) {
        property.clearTypes();
        for (TypeElement type : types) {
            property.addType(type);
        }
        this._typeElements.addAll(types);
    }

    @Override
    protected void applySignature(PropertyElement result, Set<TypeElement> types) {
        for (TypeElement type : types) {
            JSTypeUtil.applySignature(result, type);
        }
    }

    private Set<String> getTypeNames(Set<TypeElement> types) {
        if (CollectionsUtil.isEmpty(types)) {
            return Collections.emptySet();
        }
        return CollectionsUtil.getPropertyList(types, (GetPropertor)new GetPropertor<TypeElement, String>(){

            public String getProperty(TypeElement obj) {
                return obj.getName();
            }
        });
    }

    @Override
    public void processProperties(JSPropertyCollection property, Set<TypeElement> types) {
        block12: {
            block11: {
                if (!property.hasProperties()) break block11;
                Set<String> typeNames = this.getTypeNames(types);
                List<String> additionalProperties = this.getAdditionalProperties(property, typeNames);
                if (additionalProperties.isEmpty()) break block12;
                TypeElement subType = JSAssistSymbolTypeInferrer.generateType(property, typeNames);
                if (JSTypeUtil.hasType(types, subType)) {
                    for (TypeElement temp : types) {
                        if (!subType.getName().equals(temp.getName())) continue;
                        subType = temp;
                        break;
                    }
                }
                ArrayList<String> returnTypes = new ArrayList<String>();
                for (TypeElement type : types) {
                    if (!JSTypeUtil.isFunctionPrefix(type.getName())) continue;
                    returnTypes.addAll(JSTypeUtil.getFunctionSignatureReturnTypeNames(type.getName()));
                }
                String propertyType = subType.getName();
                if (!JSTypeUtil.isFunctionPrefix(propertyType) && !returnTypes.isEmpty()) {
                    propertyType = String.valueOf(propertyType) + JSTypeUtil.toFunctionType(returnTypes);
                }
                types.add(JSTypeUtil.createEmptyType(propertyType));
                for (String pname : additionalProperties) {
                    if ("prototype".equals(pname)) continue;
                    JSAssistSymbolTypeInferrer inferrer = (JSAssistSymbolTypeInferrer)this.createSymbolTypeInferrer();
                    PropertyElement pe = inferrer.getSymbolPropertyElement(property, pname);
                    if (subType.getProperty(pname) != null) {
                        pe = subType.getProperty(pname);
                    } else {
                        subType.addProperty(pe);
                    }
                    List<TypeElement> typeElements = inferrer.getTypeElements();
                    for (TypeElement typeElement : typeElements) {
                        ReturnTypeElement returnType = new ReturnTypeElement();
                        returnType.setTypeElement(typeElement);
                        returnType.setType(typeElement.getName());
                        if (pe instanceof FunctionElement) {
                            for (ReturnTypeElement rtnType : typeElement.getReturnTypes()) {
                                ((FunctionElement)pe).addReturnType(rtnType);
                            }
                            continue;
                        }
                        pe.addType(returnType);
                    }
                }
                if (!this.writeSubType) break block12;
                this.writeType(subType);
                break block12;
            }
            for (TypeElement type : types) {
                property.addType(type);
            }
        }
    }

    @Override
    protected void addWindowMemberTypes(JSPropertyCollection property, Set<TypeElement> types) {
        if ("window".equals(property.getName())) {
            types.add(JSTypeConstants.EMPTY_WINDOW_TYPE);
        } else {
            JSIndexQueryHelper helper = new JSIndexQueryHelper();
            Collection<PropertyElement> props = helper.getTypeMembers(this.index, "Window", property.getName());
            if (!CollectionsUtil.isEmpty(props)) {
                for (PropertyElement prop : props) {
                    if (prop instanceof FunctionElement) {
                        FunctionTypeElement type = new FunctionTypeElement((FunctionElement)prop);
                        types.add(type);
                        continue;
                    }
                    types.addAll(JSTypeUtil.createEmptyTypes(prop.getTypeNames()));
                }
            }
        }
    }

    @Override
    protected JSNodeTypeInferrer<TypeElement> createNodeTypeInferrer(JSScope activeScope, Index index, URI location) {
        JSAssistNodeTypeInferrer inferrer = new JSAssistNodeTypeInferrer(activeScope, index, location);
        inferrer.setWriteType(this.writeSubType);
        inferrer.setContextType(this.contextType);
        return inferrer;
    }

    @Override
    protected void addExceptionType(JSPropertyCollection property, Set<TypeElement> types, JSCatchNode catchNode, JSNodeTypeInferrer<TypeElement> inferrer) {
        boolean defaultExceptionType = true;
        if (catchNode.getChild(1) instanceof JSBinaryBooleanOperatorNode) {
            IParseNode lastChild;
            JSBinaryBooleanOperatorNode conditionNode = (JSBinaryBooleanOperatorNode)catchNode.getChild(1);
            if ("instanceof".equals(conditionNode.getOperator().value) && (lastChild = conditionNode.getLastChild()) instanceof JSIdentifierNode) {
                defaultExceptionType = false;
                types.add(JSTypeUtil.createEmptyType(lastChild.toString()));
            }
        }
        if (defaultExceptionType) {
            types.add(JSTypeUtil.createEmptyType("Error"));
        }
    }

    @Override
    protected void addObjectType(JSPropertyCollection property, Set<TypeElement> types, JSNode value, JSNodeTypeInferrer<TypeElement> infer) {
        super.addObjectType(property, types, value, infer);
        this.writeSubType = true;
        if (infer instanceof JSAssistNodeTypeInferrer) {
            JSAssistNodeTypeInferrer inferrer = (JSAssistNodeTypeInferrer)infer;
            String typeName = property.getName();
            TypeElement type = JSTypeUtil.createEmptyType(typeName);
            if (this.activeScope.hasType(typeName)) {
                JSPropertyCollection props = this.activeScope.getTypePropertyCollection(typeName);
                if (props.hasProperties()) {
                    for (String propName : props.getPropertyNames()) {
                        PropertyElement prop = this.createSymbolTypeInferrer().getSymbolPropertyElement(props, propName);
                        type.addProperty(prop);
                    }
                }
            } else {
                JSTypeUtil.applyObjectPropertiesCollection((JSObjectNode)value, type, this.index, this.location);
            }
            inferrer.addType(type);
        }
    }

    @Override
    protected void processDocumentationBlock(JSPropertyCollection property, Set<TypeElement> types, JSNode value, boolean isFunction, DocumentationBlock docs) {
        if (isFunction) {
            FunctionElement f = new FunctionElement();
            JSTypeUtil.applyDocumentation(f, value, docs);
            if (!docs.hasTag(TagType.RETURN)) {
                JSAssistNodeTypeInferrer inferrer = new JSAssistNodeTypeInferrer(this.activeScope, this.index, this.location);
                inferrer.setWriteType(this.writeSubType);
                property.addType("Function");
                inferrer.visit(value);
                property.clearTypes();
                types.addAll(inferrer.getTypes());
            } else {
                types.addAll(JSTypeUtil.createEmptyTypes(f.getSignatureTypes()));
            }
        } else {
            PropertyElement p = new PropertyElement();
            JSTypeUtil.applyDocumentation(p, value, docs);
            types.addAll(JSTypeUtil.createEmptyTypes(p.getTypeNames()));
        }
    }

    public List<TypeElement> getTypeElements() {
        return this._typeElements;
    }

    public void setContextType(String contextType) {
        this.contextType = contextType;
    }
}

