/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.index.JSIndexWriter;
import com.aptana.editor.js.contentassist.index.JSMetadataReader;
import com.aptana.editor.js.contentassist.model.AliasElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class SDocMLFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        if (context == null || index == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            sub.subTask(this.getIndexingMessage(index, context.getURI()));
            try {
                PropertyElement property4;
                String typeName;
                JSMetadataReader reader = new JSMetadataReader();
                InputStream stream = context.openInputStream((IProgressMonitor)sub.newChild(5));
                reader.loadXML(stream, context.getURI().toString());
                sub.worked(45);
                String globalTypeName = JSTypeUtil.getGlobalType(context.getProject(), context.getName());
                TypeElement window = JSTypeUtil.createGlobalType(globalTypeName);
                JSIndexWriter indexer = new JSIndexWriter();
                TypeElement[] types = reader.getTypes();
                AliasElement[] aliases = reader.getAliases();
                URI location = context.getURI();
                ArrayList<TypeElement> typeElementList = new ArrayList<TypeElement>();
                Object[] objectArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeElement type = objectArray[n2];
                    type.setHasAllUserAgents();
                    for (PropertyElement property2 : type.getProperties()) {
                        property2.setHasAllUserAgents();
                    }
                    typeName = type.getName();
                    if (!typeName.contains(".") && !typeName.startsWith("Class<")) {
                        List<FunctionElement> constructors = type.getConstructors();
                        if (!constructors.isEmpty()) {
                            for (FunctionElement constructor : constructors) {
                                type.removeProperty(constructor);
                                window.addProperty(constructor);
                            }
                            String newName = JSTypeUtil.toFunctionType(typeName);
                            type.setName(newName);
                            for (PropertyElement property3 : type.getProperties()) {
                                property3.setOwningType(newName);
                            }
                        } else {
                            property4 = window.getProperty(typeName);
                            if (property4 == null) {
                                property4 = new PropertyElement();
                                property4.setName(typeName);
                                property4.addType(typeName);
                                property4.setHasAllUserAgents();
                                property4.setIsInternal(type.isInternal());
                                window.addProperty(property4);
                            }
                        }
                    }
                    indexer.writeType(index, type, location);
                    typeElementList.add(type);
                    ++n2;
                }
                objectArray = aliases;
                n = aliases.length;
                n2 = 0;
                while (n2 < n) {
                    Object alias = objectArray[n2];
                    typeName = ((AliasElement)alias).getType();
                    ArrayList<PropertyElement> aliasProperties = new ArrayList<PropertyElement>();
                    for (PropertyElement property4 : window.getProperties()) {
                        if (!typeName.equals(property4.getName()) || property4 == null) continue;
                        property4 = property4 instanceof FunctionElement ? new FunctionElement((FunctionElement)property4) : new PropertyElement(property4);
                        property4.setName(((AliasElement)alias).getName());
                        aliasProperties.add(property4);
                    }
                    for (PropertyElement property4 : aliasProperties) {
                        window.addProperty(property4);
                    }
                    property4 = new PropertyElement();
                    property4.setName(((AliasElement)alias).getName());
                    property4.addType(JSTypeUtil.toClassType(typeName));
                    window.addProperty(property4);
                    ++n2;
                }
                indexer.writeType(index, window, location);
                typeElementList.add(window);
                JSIndexCacher.getInstance().addIndexCache(index, location.toString(), typeElementList);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            sub.done();
        }
    }

    public boolean isEnableType(BuildContextType contextType) {
        return true;
    }
}

