/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.model.EventElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.IndexWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.Plugin;

public class JSIndexWriter
extends IndexWriter {
    protected URI getDocumentPath() {
        return URI.create("js.metadata");
    }

    protected void writeEvent(Index index, EventElement event, URI location) {
        String value = StringUtil.join((String)"\u0000", (String[])new String[]{event.getOwningType(), event.getName(), this.serialize(event)});
        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_index_writes")) {
            String message = MessageFormat.format("Writing event ''{0}.{1}'' from location ''{2}'' to index ''{3}''", event.getOwningType(), event.getName(), location.toString(), index.toString());
            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message, (String)"com.aptana.editor.js/debug/show_index_writes");
        }
        index.addEntry("js.event", value, location);
    }

    protected void writeFunction(Index index, FunctionElement function, URI location) {
        String value = StringUtil.join((String)"\u0000", (String[])new String[]{function.getOwningType(), function.getName(), this.serialize(function)});
        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_index_writes")) {
            String message = MessageFormat.format("Writing function ''{0}.{1}'' from location ''{2}'' to index ''{3}''", function.getOwningType(), function.getName(), location.toString(), index.toString());
            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message, (String)"com.aptana.editor.js/debug/show_index_writes");
        }
        index.addEntry("js.function", value, location);
    }

    protected void writeProperty(Index index, PropertyElement property, URI location) {
        String value = StringUtil.join((String)"\u0000", (String[])new String[]{property.getOwningType(), property.getName(), this.serialize(property)});
        if (IdeLog.isTraceEnabled((Plugin)JSPlugin.getDefault(), (String)"com.aptana.editor.js/debug/show_index_writes")) {
            String message = MessageFormat.format("Writing property ''{0}.{1}'' from location ''{2}'' to index ''{3}''", property.getOwningType(), property.getName(), location.toString(), index.toString());
            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)message, (String)"com.aptana.editor.js/debug/show_index_writes");
        }
        index.addEntry("js.property", value, location);
    }

    public void writeRequires(Index index, Collection<String> paths, URI location) {
        if (index != null && !CollectionsUtil.isEmpty(paths)) {
            String value = StringUtil.join((String)",", paths);
            index.addEntry("js.require", value, location);
        }
    }

    public void writeWebViewId(Index index, Collection<String> ids, URI location) {
        if (index != null && !CollectionsUtil.isEmpty(ids)) {
            String value = StringUtil.join((String)",", ids);
            index.addEntry("js.webview.id", value, location);
        }
    }

    public void writeType(Index index, TypeElement type) {
        this.writeType(index, type, this.getDocumentPath());
    }

    public void writeType(Index index, TypeElement type, URI location) {
        if (index != null && type != null && location != null) {
            this.getJSIndexCacher().addIndexCache(index, location.toString(), type);
        }
    }

    public JSIndexCacher getJSIndexCacher() {
        return JSIndexCacher.getInstance();
    }

    public Index getIndex(Index index) {
        return IndexPlugin.getDefault().getIndexManager().getIndex(index.getRoot());
    }
}

