/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.TimeLogUtils;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ProposalUtils;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.UserAgentElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.pandora.core.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class JSIndexCacher {
    private static final String BAK_EXTEND = "_bak";
    private Map<String, Map<String, Map<String, TypeElement>>> memoryIndex = new ConcurrentHashMap<String, Map<String, Map<String, TypeElement>>>();
    private Map<String, Map<String, Set<ICompletionProposal>>> proposals = new ConcurrentHashMap<String, Map<String, Set<ICompletionProposal>>>();
    public static final String BIG_PROJECT_KEY = "$BIG_PROJECT_KEY$";
    private static final Set<ICompletionProposal> BIG_PROJECT_KEY_VALUE = Collections.emptySet();
    private static final int BIG_PROJECT_SIZE = 100000;
    private static Kryo kryo = new Kryo();
    private static JSIndexCacher instance;

    static {
        kryo.setClassLoader(JSIndexCacher.class.getClassLoader());
        kryo.setAutoReset(true);
        instance = null;
    }

    private JSIndexCacher() {
    }

    public static JSIndexCacher getInstance() {
        if (instance == null) {
            instance = new JSIndexCacher();
        }
        return instance;
    }

    public void addIndexCache(Index index, Map<String, Map<String, TypeElement>> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        this.memoryIndex.put(index.getRoot().toString(), map);
    }

    public void addIndexCache(Index index, String fileUri, List<TypeElement> typeElementList) {
        String key = index.getRoot().toString();
        Map<String, Map<String, TypeElement>> projectIndex = null;
        projectIndex = this.memoryIndex.containsKey(key) ? this.memoryIndex.get(key) : this.checkAndDeserialize(index, key, projectIndex);
        if (projectIndex == null) {
            projectIndex = new ConcurrentHashMap<String, Map<String, TypeElement>>();
        }
        if (CollectionsUtil.isEmpty(typeElementList)) {
            return;
        }
        this.memoryIndex.put(key, projectIndex);
        ConcurrentHashMap<String, TypeElement> types = new ConcurrentHashMap<String, TypeElement>();
        for (TypeElement type : typeElementList) {
            if (!StringUtil.isNotEmpty((String)type.getName())) continue;
            types.put(type.getName(), type);
        }
        projectIndex.put(fileUri, types);
        this.flushProposal(index, URI.create(fileUri));
    }

    private Map<String, Map<String, TypeElement>> checkAndDeserialize(Index index, String key, Map<String, Map<String, TypeElement>> projectIndex) {
        boolean isIndexfileExist;
        File indexFile = this.getIndexFile(index, false);
        boolean bl = isIndexfileExist = indexFile == null ? false : indexFile.exists();
        if (isIndexfileExist) {
            try {
                this.deSerialize(index);
                projectIndex = this.memoryIndex.get(key);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"addIndexCache and deSerialize index file error\uff01", (Throwable)e);
            }
        }
        return projectIndex;
    }

    public void flushProposal(Index index, URI location) {
        TimeLogUtils log = TimeLogUtils.getTimeLog();
        JSIndexQueryHelper indexHelper = new JSIndexQueryHelper();
        Map<String, List<TypeElement>> relationTypes = indexHelper.getRelationTypes(index);
        if (location != null) {
            List<TypeElement> types = relationTypes.get(location.toString());
            relationTypes.clear();
            relationTypes.put(location.toString(), types);
        }
        Map<Object, Object> datas = null;
        if (this.proposals.containsKey(index.getRoot().toString())) {
            datas = this.proposals.get(index.getRoot().toString());
        } else {
            datas = new HashMap();
            this.proposals.put(index.getRoot().toString(), datas);
        }
        for (String locationKey : relationTypes.keySet()) {
            List<TypeElement> types = relationTypes.get(locationKey);
            if (!CollectionsUtil.isNotEmpty(types)) continue;
            HashSet<CommonCompletionProposal> proposals = new HashSet<CommonCompletionProposal>();
            for (TypeElement type : types) {
                for (PropertyElement prop : type.getProperties()) {
                    CommonCompletionProposal proposal = ProposalUtils.createPropertyElementProposal(prop);
                    proposal.setCompletionProposalType(CompletionProposalType.OTHER);
                    Map<String, String> userAgents = prop.getUserAgentsNameWithVersion();
                    if (!CollectionsUtil.isEmpty(userAgents)) {
                        userAgents.put("_lazy_", "_lazy_");
                    }
                    proposal.setUserAgentImages(userAgents);
                    proposals.add(proposal);
                }
            }
            datas.put(locationKey, proposals);
        }
        int count = 0;
        try {
            datas.put(BIG_PROJECT_KEY, BIG_PROJECT_KEY_VALUE);
            for (Set set : datas.values()) {
                count += set.size();
            }
            if (count < 100000) {
                datas.remove(BIG_PROJECT_KEY);
            }
        }
        catch (Exception exception) {}
        log.logTaskCostTime("\u5237\u65b0[" + location + "]\u5168\u63d0\u793a\u7f13\u5b58(" + count + ")", true);
    }

    public void addIndexCache(Index index, String fileUri, TypeElement typeElement) {
        String key = index.getRoot().toString();
        Map<String, Map<String, TypeElement>> projectIndex = null;
        projectIndex = this.memoryIndex.containsKey(key) ? this.memoryIndex.get(key) : this.checkAndDeserialize(index, key, projectIndex);
        if (projectIndex == null) {
            projectIndex = new ConcurrentHashMap<String, Map<String, TypeElement>>();
        }
        if (typeElement == null) {
            return;
        }
        if (StringUtil.isBlank((String)typeElement.getName())) {
            return;
        }
        Map<String, TypeElement> types = null;
        if (projectIndex.containsKey(fileUri)) {
            types = projectIndex.get(fileUri);
        }
        if (types == null) {
            types = new ConcurrentHashMap<String, TypeElement>();
        }
        types.put(typeElement.getName(), typeElement);
        projectIndex.put(fileUri, types);
        this.memoryIndex.put(key, projectIndex);
    }

    public boolean isExistCache(String key) {
        return this.memoryIndex.containsKey(key) && this.memoryIndex.get(key) != null;
    }

    public void initMetaDataCacher(Index index, List<TypeElement> types) {
        String key = "metadata:/js";
        Map<String, Map<String, TypeElement>> metaIndex = null;
        if (this.memoryIndex.get(key) != null) {
            metaIndex = this.memoryIndex.get(key);
            this.memoryIndex.remove(key);
        }
        if (metaIndex == null) {
            metaIndex = new ConcurrentHashMap<String, Map<String, TypeElement>>();
        }
        this.memoryIndex.put(key, metaIndex);
        ConcurrentHashMap<String, TypeElement> typeMaps = new ConcurrentHashMap<String, TypeElement>();
        for (TypeElement el : types) {
            if (!StringUtil.isNotEmpty((String)el.getName())) continue;
            typeMaps.put(el.getName(), el);
        }
        metaIndex.put(key, typeMaps);
        this.save(index);
        this.flushProposal(index, URI.create("metadata:/js"));
    }

    public void saveALL() {
        if (this.memoryIndex == null) {
            return;
        }
        Set<String> keys = this.memoryIndex.keySet();
        if (keys.isEmpty()) {
            return;
        }
        IndexPlugin pligun = IndexPlugin.getDefault();
        if (pligun == null) {
            return;
        }
        IndexManager manager = pligun.getIndexManager();
        if (manager == null) {
            return;
        }
        Index index = null;
        for (String uri : keys) {
            index = manager.getIndex(URI.create(uri));
            if (index == null) continue;
            this.save(index);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(Index index) {
        String key = index.getRoot().toString();
        if (this.memoryIndex.containsKey(key)) {
            Map<String, Map<String, TypeElement>> projectCache = this.memoryIndex.get(key);
            Output output = null;
            try {
                try {
                    File indexFile = this.getIndexFile(index, true);
                    if (indexFile.exists()) {
                        File targetFile = new File(String.valueOf(indexFile.getAbsolutePath()) + BAK_EXTEND);
                        this.deleteBackupFile(targetFile);
                        FileUtil.copyFile((File)indexFile, (File)targetFile);
                    }
                    output = this.save(projectCache, indexFile);
                    return;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + key + ",\u4fdd\u5b58\u7d22\u5f15\u6587\u4ef6\u5931\u8d25---one"), (Throwable)e);
                    try {
                        kryo.reset();
                        if (output != null) {
                            output.close();
                            output = null;
                        }
                        File indexfile = this.getIndexFile(index, true);
                        indexfile.createNewFile();
                        output = this.save(projectCache, indexfile);
                    }
                    catch (Exception e1) {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + key + ",\u4fdd\u5b58\u7d22\u5f15\u6587\u4ef6\u5931\u8d25---two"), (Throwable)e1);
                    }
                    kryo.reset();
                    if (output == null) return;
                    output.close();
                }
                return;
            }
            finally {
                kryo.reset();
                if (output != null) {
                    output.close();
                }
            }
        }
        IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + key + ",\u4fdd\u5b58\u7d22\u5f15\u6587\u4ef6\u5931\u8d25,\u5185\u5b58\u4e2d\u4e0d\u5b58\u5728\u7d22\u5f15\u6570\u636e\u3002"));
    }

    public Output save(Map<String, Map<String, TypeElement>> projectCache, File indexfile) throws FileNotFoundException {
        Output output = new Output((OutputStream)new FileOutputStream(indexfile));
        kryo.writeClassAndObject(output, projectCache);
        return output;
    }

    public File getIndexFile(Index index, boolean create) {
        String fileName = index.getIndexFile().getAbsolutePath();
        File indexFile = new File(fileName = String.valueOf(fileName) + ".db");
        if (!indexFile.exists() && create) {
            try {
                indexFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return indexFile;
    }

    public void removeCache(Index index, String fileUri) {
        Map<String, Map<String, TypeElement>> projectIndex;
        String key = index.getRoot().toString();
        if (this.memoryIndex.containsKey(key) && (projectIndex = this.memoryIndex.get(key)) != null) {
            projectIndex.remove(fileUri);
        }
    }

    public void removeProjectCache(Index index) {
        File indexFile;
        String key = index.getRoot().toString();
        if (this.memoryIndex.containsKey(key)) {
            this.memoryIndex.remove(key);
        }
        if ((indexFile = this.getIndexFile(index, false)).exists()) {
            try {
                indexFile.delete();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + key + ",\u5220\u9664\u7d22\u5f15\u6587\u4ef6" + indexFile.getAbsolutePath() + "\u5931\u8d25"));
                e.printStackTrace();
            }
        }
    }

    public Map<String, Map<String, Map<String, TypeElement>>> getCacher() {
        return this.memoryIndex;
    }

    public Map<String, Map<String, Set<ICompletionProposal>>> getProposals() {
        return this.proposals;
    }

    public void deSerialize(Index index) throws Exception {
        Input input = null;
        File indexFile = this.getIndexFile(index, false);
        File indexBackFile = new File(String.valueOf(indexFile.getAbsolutePath()) + BAK_EXTEND);
        if (!indexFile.exists() && !indexBackFile.exists()) {
            throw new FileNotFoundException();
        }
        try {
            try {
                input = this.deSerialize(index, indexFile);
                this.deleteBackupFile(indexBackFile);
            }
            catch (Exception e) {
                block16: {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + index.getRoot().toString() + ",\u8bfb\u53d6\u7d22\u5f15\u6587\u4ef6\u5931\u8d25\u3002------one"), (Throwable)e);
                    try {
                        kryo.reset();
                        if (input != null) {
                            input.close();
                            input = null;
                        }
                        input = this.deSerialize(index, indexFile);
                        this.deleteBackupFile(indexBackFile);
                    }
                    catch (Exception e1) {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + index.getRoot().toString() + ",\u8bfb\u53d6\u7d22\u5f15\u6587\u4ef6\u5931\u8d25\u3002------two"), (Throwable)e1);
                        if (indexBackFile.exists()) {
                            try {
                                input = this.deSerializeIndexBackFile(index, input, indexFile, indexBackFile);
                                break block16;
                            }
                            catch (Exception e2) {
                                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + index.getRoot().toString() + ",\u8bfb\u53d6\u7d22\u5f15\u6587\u4ef6\u5931\u8d25\u3002------three"), (Throwable)e2);
                                try {
                                    input = this.deSerializeIndexBackFile(index, input, indexFile, indexBackFile);
                                    break block16;
                                }
                                catch (Exception e3) {
                                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u9879\u76ee\uff1a" + index.getRoot().toString() + ",\u8bfb\u53d6\u7d22\u5f15\u6587\u4ef6\u5931\u8d25\u3002------four"), (Throwable)e3);
                                    throw e3;
                                }
                            }
                        }
                        throw e1;
                    }
                }
                kryo.reset();
                if (input != null) {
                    input.close();
                }
                this.flushProposal(index, null);
            }
        }
        finally {
            kryo.reset();
            if (input != null) {
                input.close();
            }
            this.flushProposal(index, null);
        }
    }

    public void deleteBackupFile(File indexBackFile) {
        if (indexBackFile.exists()) {
            indexBackFile.delete();
        }
    }

    public Input deSerializeIndexBackFile(Index index, Input input, File indexFile, File indexBackFile) throws FileNotFoundException {
        kryo.reset();
        if (input != null) {
            input.close();
            input = null;
        }
        input = this.deSerialize(index, indexBackFile);
        this.restoreIndexFile(indexFile, indexBackFile);
        return input;
    }

    public void restoreIndexFile(File indexFile, File indexBackFile) {
        if (indexFile.exists()) {
            indexFile.delete();
        }
        FileUtil.copyFile((File)indexBackFile, (File)indexFile);
    }

    public Input deSerialize(Index index, File indexFile) throws FileNotFoundException {
        Input input = new Input((InputStream)new FileInputStream(indexFile));
        Object obj = kryo.readClassAndObject(input);
        if (obj instanceof Map) {
            Map map = (Map)obj;
            this.addIndexCache(index, map);
            this.filterCacher(index);
            this.filterWindowCacher(index);
        }
        return input;
    }

    private void filterWindowCacher(Index index) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.editor.common");
        String needFilter = prefs.get("NEED_FILTER_WINDOW", "true");
        if ("false".equals(needFilter)) {
            return;
        }
        String key = index.getRoot().toString();
        if (!this.memoryIndex.containsKey(key) || "metadata:/js".equals(key)) {
            return;
        }
        Map<String, Map<String, TypeElement>> projectCacherMap = this.memoryIndex.get(key);
        if (projectCacherMap == null) {
            return;
        }
        Set<String> fileKeys = projectCacherMap.keySet();
        if (fileKeys == null) {
            return;
        }
        String typeName = "Window";
        Set<PropertyElement> metaDataPropertyElementSet = this.geMtaDataPropertyElementSet(typeName);
        if (metaDataPropertyElementSet == null || metaDataPropertyElementSet.isEmpty()) {
            return;
        }
        for (String fileKey : fileKeys) {
            List<PropertyElement> propertyElements;
            TypeElement typeElement;
            Map<String, TypeElement> fileCacherMap = projectCacherMap.get(fileKey);
            if (fileCacherMap == null || (typeElement = fileCacherMap.get(typeName)) == null || (propertyElements = typeElement.getProperties()) == null || propertyElements.isEmpty()) continue;
            ArrayList<PropertyElement> propertyElementSet = new ArrayList<PropertyElement>();
            for (PropertyElement propertyElement : propertyElements) {
                List<UserAgentElement> uList;
                if (metaDataPropertyElementSet.contains(propertyElement) || (uList = propertyElement.getUserAgents()) != null && !uList.isEmpty()) continue;
                propertyElementSet.add(propertyElement);
            }
            typeElement.setAllPropertys(propertyElementSet);
        }
    }

    private Set<PropertyElement> geMtaDataPropertyElementSet(String typeName) {
        String metaDataKey = "metadata:/js";
        if (!this.memoryIndex.containsKey(metaDataKey)) {
            return null;
        }
        Map<String, Map<String, TypeElement>> metaDataCacherMap = this.memoryIndex.get(metaDataKey);
        if (metaDataCacherMap == null || !metaDataCacherMap.containsKey(metaDataKey)) {
            return null;
        }
        Map<String, TypeElement> metaDataTypeElementCacherMap = metaDataCacherMap.get(metaDataKey);
        if (metaDataTypeElementCacherMap == null || !metaDataTypeElementCacherMap.containsKey(typeName)) {
            return null;
        }
        TypeElement metaDataTypeElement = metaDataTypeElementCacherMap.get(typeName);
        if (metaDataTypeElement == null) {
            return null;
        }
        HashSet<PropertyElement> metaDataPropertyElementSet = new HashSet<PropertyElement>();
        metaDataPropertyElementSet.addAll(metaDataTypeElement.getProperties());
        return metaDataPropertyElementSet;
    }

    public void filterCacher(Index index) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.editor.common");
        String needFilter = prefs.get("NEED_FILTER", "true");
        if ("false".equals(needFilter)) {
            return;
        }
        String key = index.getRoot().toString();
        if (!this.memoryIndex.containsKey(key)) {
            return;
        }
        Map<String, Map<String, TypeElement>> projectCacherMap = this.memoryIndex.get(key);
        if (projectCacherMap == null) {
            return;
        }
        Set<String> fileKeys = projectCacherMap.keySet();
        if (fileKeys == null) {
            return;
        }
        for (String fileKey : fileKeys) {
            Set<String> typeElementKeys;
            Map<String, TypeElement> fileCacherMap = projectCacherMap.get(fileKey);
            if (fileCacherMap == null || (typeElementKeys = fileCacherMap.keySet()) == null || typeElementKeys.isEmpty()) continue;
            for (String typeElementKey : typeElementKeys) {
                List<PropertyElement> propertyElements;
                TypeElement typeElement = fileCacherMap.get(typeElementKey);
                if (typeElement == null || (propertyElements = typeElement.getProperties()) == null || propertyElements.isEmpty()) continue;
                HashSet<PropertyElement> propertyElementSet = new HashSet<PropertyElement>();
                propertyElementSet.addAll(propertyElements);
                typeElement.setAllPropertys(new ArrayList<PropertyElement>(propertyElementSet));
                fileCacherMap.put(typeElementKey, typeElement);
            }
            projectCacherMap.put(fileKey, fileCacherMap);
        }
        this.memoryIndex.put(key, projectCacherMap);
    }
}

