/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.index.core.Index;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class JSIndexCacheReader {
    public List<FunctionElement> getFunctions(Index index, List<String> typeNames) {
        return Collections.emptyList();
    }

    public List<FunctionElement> getFunctions(Index index, String typeName) {
        return Collections.emptyList();
    }

    public Map<String, Map<String, Map<String, TypeElement>>> getCacher() {
        return JSIndexCacher.getInstance().getCacher();
    }

    public Collection<? extends PropertyElement> getProperties(Index index, List<String> typeNames, URI location) {
        String key = index.getRoot().toString();
        Map<String, Map<String, TypeElement>> metaIndex = this.getCacher().get(key);
        if (!CollectionsUtil.isEmpty(metaIndex) && metaIndex.containsKey(location.toString())) {
            ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
            Map<String, TypeElement> value = metaIndex.get(location.toString());
            for (String typeName : typeNames) {
                if (!value.containsKey(typeName)) continue;
                TypeElement typeElement = value.get(typeName);
                properties.addAll(typeElement.getProperties());
            }
            return properties;
        }
        return Collections.emptyList();
    }

    public List<PropertyElement> getProperties(Index index, List<String> typeNames) {
        String key = index.getRoot().toString();
        Map<String, Map<String, TypeElement>> metaIndex = this.getCacher().get(key);
        if (!CollectionsUtil.isEmpty(metaIndex)) {
            ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
            Collection<Map<String, TypeElement>> values = metaIndex.values();
            for (Map<String, TypeElement> value : values) {
                for (String typeName : typeNames) {
                    if (!value.containsKey(typeName)) continue;
                    TypeElement typeElement = value.get(typeName);
                    properties.addAll(typeElement.getProperties());
                }
            }
            return properties;
        }
        return Collections.emptyList();
    }

    public List<PropertyElement> getAllProperties(Index index) {
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        List<TypeElement> types = this.getTypes(index);
        if (!CollectionsUtil.isEmpty(types)) {
            for (TypeElement type : types) {
                properties.addAll(type.getProperties());
            }
        }
        return properties;
    }

    public List<PropertyElement> getPossibleProperties(Index index, String propertyName) {
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        if (StringUtil.isEmpty((String)propertyName)) {
            return properties;
        }
        List<PropertyElement> allProperties = this.getAllProperties(index);
        if (!CollectionsUtil.isEmpty(allProperties)) {
            for (PropertyElement property : allProperties) {
                if (!propertyName.equals(property.getName())) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public List<PropertyElement> getProperties(Index index, String typeName) {
        ArrayList<String> typeNames = new ArrayList<String>();
        typeNames.add(typeName);
        return this.getProperties(index, typeNames);
    }

    public List<FunctionElement> getFunctions(Index index, String typeName, String methodName, boolean isExactOrPrefix) {
        return Collections.emptyList();
    }

    public List<PropertyElement> getProperties(Index index, String typeName, String propertyName) {
        if (StringUtil.isEmpty((String)propertyName)) {
            return Collections.emptyList();
        }
        String key = index.getRoot().toString();
        Map<String, Map<String, TypeElement>> metaIndex = this.getCacher().get(key);
        if (!CollectionsUtil.isEmpty(metaIndex)) {
            ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
            Collection<Map<String, TypeElement>> values = metaIndex.values();
            for (Map<String, TypeElement> value : values) {
                if (!StringUtil.isEmpty((String)typeName)) {
                    if (!value.containsKey(typeName)) continue;
                    TypeElement typeElement = value.get(typeName);
                    this.addProperties(propertyName, properties, typeElement);
                    continue;
                }
                Collection<TypeElement> types = value.values();
                for (TypeElement type : types) {
                    this.addProperties(propertyName, properties, type);
                }
            }
            return properties;
        }
        return Collections.emptyList();
    }

    private void addProperties(String propertyName, List<PropertyElement> properties, TypeElement type) {
        for (PropertyElement prop : type.getProperties()) {
            if (!propertyName.equals(prop.getName())) continue;
            properties.add(prop);
        }
    }

    public Collection<TypeElement> getTypes(Index index, String typeName) {
        if (StringUtil.isEmpty((String)typeName)) {
            return Collections.emptyList();
        }
        String key = index.getRoot().toString();
        Map<String, Map<String, Map<String, TypeElement>>> cacher = this.getCacher();
        if (CollectionsUtil.isEmpty(cacher) || !cacher.containsKey(key)) {
            return Collections.emptyList();
        }
        Map<String, Map<String, TypeElement>> value = cacher.get(key);
        Collection<Map<String, TypeElement>> typeCollections = null;
        if (CollectionsUtil.isEmpty(value) || CollectionsUtil.isEmpty(typeCollections = value.values())) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> resultTypes = new ArrayList<TypeElement>();
        for (Map<String, TypeElement> types : typeCollections) {
            if (!types.containsKey(typeName)) continue;
            resultTypes.add(types.get(typeName));
        }
        return resultTypes;
    }

    public List<TypeElement> getTypes(Index index) {
        ArrayList<TypeElement> types = new ArrayList<TypeElement>();
        String key = index.getRoot().toString();
        Map<String, Map<String, Map<String, TypeElement>>> cacher = this.getCacher();
        if (CollectionsUtil.isEmpty(cacher) || !cacher.containsKey(key)) {
            return types;
        }
        Map<String, Map<String, TypeElement>> value = cacher.get(key);
        Collection<Map<String, TypeElement>> typeCollections = null;
        if (CollectionsUtil.isEmpty(value) || CollectionsUtil.isEmpty(typeCollections = value.values())) {
            return types;
        }
        for (Map<String, TypeElement> typeCollection : typeCollections) {
            if (CollectionsUtil.isEmpty(typeCollection)) continue;
            types.addAll(typeCollection.values());
        }
        return types;
    }

    public List<TypeElement> getTypes(Index index, URI location) {
        ArrayList<TypeElement> types = new ArrayList<TypeElement>();
        String key = index.getRoot().toString();
        Map<String, Map<String, Map<String, TypeElement>>> cacher = this.getCacher();
        if (CollectionsUtil.isEmpty(cacher) || !cacher.containsKey(key)) {
            return types;
        }
        Map<String, Map<String, TypeElement>> value = cacher.get(key);
        if (CollectionsUtil.isEmpty(value)) {
            return types;
        }
        if (value.containsKey(location.toString()) && value.get(location.toString()) != null) {
            types.addAll(value.get(location.toString()).values());
        }
        return types;
    }

    public Collection<ICompletionProposal> getAllProposals(Index index, Set<String> locations) {
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        String locationKey = index.getRoot().toString();
        Map<String, Set<ICompletionProposal>> relationProposals = JSIndexCacher.getInstance().getProposals().get(locationKey);
        if (CollectionsUtil.isNotEmpty(relationProposals)) {
            for (String location : locations) {
                Set<ICompletionProposal> set = relationProposals.get(location);
                if (set == null) continue;
                results.addAll(set);
            }
        }
        return results;
    }

    public Collection<ICompletionProposal> getAllProposals(Index index) {
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        String indexKey = index.getRoot().toString();
        Map<String, Set<ICompletionProposal>> relationProposals = JSIndexCacher.getInstance().getProposals().get(indexKey);
        if (CollectionsUtil.isNotEmpty(relationProposals)) {
            for (Set<ICompletionProposal> props : relationProposals.values()) {
                results.addAll(props);
            }
        }
        return results;
    }

    public Map<String, List<TypeElement>> getRelationTypes(Index index) {
        HashMap<String, List<TypeElement>> results = new HashMap<String, List<TypeElement>>();
        String key = index.getRoot().toString();
        Map<String, Map<String, Map<String, TypeElement>>> cacher = this.getCacher();
        if (CollectionsUtil.isEmpty(cacher) || !cacher.containsKey(key)) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, TypeElement>> value = cacher.get(key);
        if (CollectionsUtil.isEmpty(value) || CollectionsUtil.isEmpty(value.values())) {
            return Collections.emptyMap();
        }
        for (Map.Entry<String, Map<String, TypeElement>> entry : value.entrySet()) {
            ArrayList<TypeElement> types = new ArrayList<TypeElement>();
            types.addAll(entry.getValue().values());
            results.put(entry.getKey(), types);
        }
        return results;
    }

    public boolean isBigProject(Index index) {
        String indexKey = index.getRoot().toString();
        Map<String, Set<ICompletionProposal>> relationProposals = JSIndexCacher.getInstance().getProposals().get(indexKey);
        return CollectionsUtil.isNotEmpty(relationProposals) && relationProposals.containsKey("$BIG_PROJECT_KEY$");
    }
}

