/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.model.AliasElement;
import com.aptana.editor.js.contentassist.model.EventElement;
import com.aptana.editor.js.contentassist.model.EventPropertyElement;
import com.aptana.editor.js.contentassist.model.ExceptionElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.contentassist.model.SinceElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.UserAgentElement;
import com.aptana.json.IContextHandler;
import com.aptana.json.IState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class JSCAHandler
implements IContextHandler {
    private static final Map<String, String> TYPE_MAP;
    private static final Pattern TYPE_DELIMITER;
    private static final Pattern DOT_PATTERN;
    private static final Pattern IDENTIFIER_PATTERN;
    private static final Pattern EVENT_IDENTIFIER_PATTERN;
    private static final Pattern TYPE_PATTERN;
    private Map<String, TypeElement> typesByName = new HashMap<String, TypeElement>();
    private List<AliasElement> aliases = new ArrayList<AliasElement>();
    private AliasElement currentAlias;
    private TypeElement currentType;
    private UserAgentElement currentUserAgent;
    private SinceElement currentSince;
    private PropertyElement currentProperty;
    private FunctionElement currentFunction;
    private EventElement currentEvent;
    private EventPropertyElement currentEventProperty;
    private ReturnTypeElement currentReturnType;
    private String currentExample;
    private ParameterElement currentParameter;
    private ExceptionElement currentException;
    private String currentString;
    private Boolean currentBoolean;

    static {
        TYPE_DELIMITER = Pattern.compile("\\s*[,|]\\s*");
        DOT_PATTERN = Pattern.compile("\\.");
        IDENTIFIER_PATTERN = Pattern.compile("[$_a-zA-Z][$_a-zA-Z0-9]*");
        EVENT_IDENTIFIER_PATTERN = Pattern.compile("[$_a-zA-Z][$_a-zA-Z0-9]*(?::[$_a-zA-Z][$_a-zA-Z0-9]*)?");
        TYPE_PATTERN = Pattern.compile("[$_a-zA-Z][$_a-zA-Z0-9]*(?:\\.[$_a-zA-Z][$_a-zA-Z0-9]*)*(?:(?:<[$_a-zA-Z][$_a-zA-Z0-9]*>)|(?:\\[\\]))?");
        TYPE_MAP = new HashMap<String, String>();
        TYPE_MAP.put("array", "Array");
        TYPE_MAP.put("bool", "Boolean");
        TYPE_MAP.put("boolean", "Boolean");
        TYPE_MAP.put("date", "Date");
        TYPE_MAP.put("double", "Number");
        TYPE_MAP.put("float", "Number");
        TYPE_MAP.put("function", "Function");
        TYPE_MAP.put("int", "Number");
        TYPE_MAP.put("long", "Number");
        TYPE_MAP.put("number", "Number");
        TYPE_MAP.put("object", "Object");
        TYPE_MAP.put("string", "String");
    }

    public void addElement(String elementTypeName, IState elementType) {
        TypeName type = TypeName.get(elementTypeName);
        switch (type) {
            case ALIAS: {
                this.aliases.add(this.currentAlias);
                this.currentAlias = null;
                break;
            }
            case TYPE: {
                List<UserAgentElement> userAgents;
                String propertyName;
                PropertyElement property;
                String typeName = this.currentType.getName();
                String namespace = this.getNamespace(typeName);
                this.setIsInternal(typeName, this.currentType.isInternal());
                this.hideNamespace(namespace);
                TypeElement namespaceType = this.getType(namespace);
                if (namespaceType != null && (property = namespaceType.getProperty(propertyName = typeName.substring(namespace.length() + 1))) != null && !CollectionsUtil.isEmpty(userAgents = this.currentType.getUserAgents())) {
                    for (UserAgentElement userAgent : userAgents) {
                        property.addUserAgent(userAgent);
                    }
                }
                this.currentType = null;
                break;
            }
            case USER_AGENT: {
                if (this.currentProperty != null) {
                    this.currentProperty.addUserAgent(this.currentUserAgent);
                } else if (this.currentFunction != null) {
                    this.currentFunction.addUserAgent(this.currentUserAgent);
                } else if (this.currentType != null) {
                    this.currentType.addUserAgent(this.currentUserAgent);
                }
                this.currentUserAgent = null;
                break;
            }
            case SINCE: {
                if (this.currentProperty != null) {
                    this.currentProperty.addSince(this.currentSince);
                } else if (this.currentFunction != null) {
                    this.currentFunction.addSince(this.currentSince);
                } else if (this.currentType != null) {
                    this.currentType.addSince(this.currentSince);
                }
                this.currentSince = null;
                break;
            }
            case PROPERTY: {
                if (this.currentType != null) {
                    this.currentType.addProperty(this.currentProperty);
                }
                this.currentProperty = null;
                break;
            }
            case FUNCTION: {
                if (this.currentType != null) {
                    this.currentType.addProperty(this.currentFunction);
                }
                this.currentFunction = null;
                break;
            }
            case EVENT: {
                if (this.currentType != null) {
                    this.currentType.addEvent(this.currentEvent);
                }
                this.currentEvent = null;
                break;
            }
            case STRING: {
                if (this.currentFunction != null) {
                    this.currentFunction.addReference(this.currentString);
                } else if (this.currentType != null) {
                    this.currentType.addRemark(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case EVENT_PROPERTY: {
                if (this.currentEvent != null) {
                    this.currentEvent.addProperty(this.currentEventProperty);
                }
                this.currentEventProperty = null;
                break;
            }
            case EXAMPLE: {
                if (this.currentProperty != null) {
                    this.currentProperty.addExample(this.currentExample);
                } else if (this.currentFunction != null) {
                    this.currentFunction.addExample(this.currentExample);
                } else if (this.currentType != null) {
                    this.currentType.addExample(this.currentExample);
                }
                this.currentExample = null;
                break;
            }
            case PARAMETER: {
                if (this.currentFunction != null) {
                    this.currentFunction.addParameter(this.currentParameter);
                }
                this.currentParameter = null;
                break;
            }
            case EXCEPTION: {
                if (this.currentFunction != null) {
                    this.currentFunction.addException(this.currentException);
                }
                this.currentException = null;
                break;
            }
            case RETURN_TYPE: {
                if (this.currentFunction != null) {
                    this.currentFunction.addReturnType(this.currentReturnType);
                }
                this.currentReturnType = null;
                break;
            }
            default: {
                this.log("Unrecognized element type name in JSCAHandler#addElement: " + elementTypeName);
            }
        }
    }

    protected void createType() {
        if (this.typesByName.containsKey(this.currentString)) {
            this.currentType = this.typesByName.get(this.currentString);
        } else {
            this.currentType.setName(this.currentString);
            this.typesByName.put(this.currentString, this.currentType);
        }
        String[] parts = DOT_PATTERN.split(this.currentString);
        if (parts.length > 1) {
            String accumulatedName = parts[0];
            TypeElement type = this.getType(accumulatedName);
            int i = 1;
            while (i < parts.length) {
                String pName = parts[i];
                accumulatedName = String.valueOf(accumulatedName) + "." + pName;
                PropertyElement property = type.getProperty(pName);
                if (property == null) {
                    property = new PropertyElement();
                    property.setName(pName);
                    property.setIsClassProperty(true);
                    property.addType(accumulatedName);
                    type.addProperty(property);
                }
                this.typesByName.put(type.getName(), type);
                type = this.getType(accumulatedName);
                ++i;
            }
        }
    }

    public void createType(String typeName, IState type, Object value) {
        TypeName t = TypeName.get(typeName);
        switch (t) {
            case ALIAS: {
                this.currentAlias = new AliasElement();
                break;
            }
            case TYPE: {
                this.currentType = new TypeElement();
                break;
            }
            case USER_AGENT: {
                this.currentUserAgent = new UserAgentElement();
                break;
            }
            case SINCE: {
                this.currentSince = new SinceElement();
                break;
            }
            case PROPERTY: {
                this.currentProperty = new PropertyElement();
                break;
            }
            case FUNCTION: {
                this.currentFunction = new FunctionElement();
                break;
            }
            case EVENT: {
                this.currentEvent = new EventElement();
                break;
            }
            case EVENT_PROPERTY: {
                this.currentEventProperty = new EventPropertyElement();
                break;
            }
            case RETURN_TYPE: {
                this.currentReturnType = new ReturnTypeElement();
                break;
            }
            case EXAMPLE: {
                break;
            }
            case PARAMETER: {
                this.currentParameter = new ParameterElement();
                break;
            }
            case EXCEPTION: {
                this.currentException = new ExceptionElement();
                break;
            }
            case STRING: {
                this.currentString = (String)value;
                break;
            }
            case BOOLEAN: {
                this.currentBoolean = (Boolean)value;
                break;
            }
            case JSMETADATA: {
                break;
            }
            default: {
                if (typeName == null || typeName.startsWith("Array<")) break;
                this.log("Unrecognized type name in JSCAHandler#createType: " + typeName);
            }
        }
    }

    public AliasElement[] getAliases() {
        return this.aliases.toArray(new AliasElement[this.aliases.size()]);
    }

    protected List<String> getMappedTypes(String typeSpec) {
        ArrayList<String> result = new ArrayList<String>();
        if (typeSpec != null && typeSpec.length() > 0) {
            String[] types;
            String[] stringArray = types = TYPE_DELIMITER.split(typeSpec);
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (this.isValidTypeIdentifier(type)) {
                    if (TYPE_MAP.containsKey(type)) {
                        result.add(TYPE_MAP.get(this.currentString));
                    } else {
                        result.add(type);
                    }
                } else {
                    this.log("Invalid type name: " + type);
                }
                ++n2;
            }
        }
        return result;
    }

    private String getNamespace(String typeName) {
        int index = typeName.lastIndexOf(46);
        return index != -1 ? typeName.substring(0, index) : "";
    }

    private TypeElement getType(String typeName) {
        TypeElement result = this.typesByName.get(typeName);
        if (result == null) {
            result = new TypeElement();
            result.setName(typeName);
        }
        return result;
    }

    public TypeElement[] getTypes() {
        Collection<TypeElement> types = this.typesByName.values();
        return types.toArray(new TypeElement[types.size()]);
    }

    protected void hideNamespace(String namespace) {
        while (!StringUtil.isEmpty((String)namespace)) {
            TypeElement type = this.typesByName.get(namespace);
            if (type != null) {
                boolean isInternal = true;
                for (PropertyElement property : type.getProperties()) {
                    if (property.isInternal()) continue;
                    isInternal = false;
                    break;
                }
                this.setIsInternal(namespace, isInternal);
            } else {
                this.log("Unrecognized namespace in JSCAHandler#hideNamespace: " + namespace);
            }
            namespace = this.getNamespace(namespace);
        }
    }

    protected void setIsInternal(String typeName, boolean isInternal) {
        String namespace = this.getNamespace(typeName);
        if (!StringUtil.isEmpty((String)namespace)) {
            String name;
            PropertyElement property;
            TypeElement namespaceType = this.typesByName.get(namespace);
            if (namespaceType != null && (property = namespaceType.getProperty(name = typeName.substring(namespace.length() + 1))) != null) {
                property.setIsInternal(isInternal);
            }
        } else {
            TypeElement type = this.typesByName.get(typeName);
            type.setIsInternal(isInternal);
        }
    }

    protected boolean isValidEventIdentifier(String name) {
        boolean result = false;
        if (name != null) {
            Matcher m = EVENT_IDENTIFIER_PATTERN.matcher(name);
            result = m.matches();
        }
        return result;
    }

    protected boolean isValidIdentifier(String name) {
        boolean result = false;
        if (name != null) {
            Matcher m = IDENTIFIER_PATTERN.matcher(name);
            result = m.matches();
        }
        return result;
    }

    protected boolean isValidTypeIdentifier(String name) {
        boolean result = false;
        if (name != null) {
            Matcher m = TYPE_PATTERN.matcher(name);
            result = m.matches();
        }
        return result;
    }

    protected void log(String message) {
        if (Platform.inDevelopmentMode()) {
            System.out.println(message);
        } else {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)message);
        }
    }

    public void setProperty(String propertyName, String propertyTypeName, IState propertyType) {
        PropertyName p = PropertyName.get(propertyName);
        switch (p) {
            case VERSION: {
                if (this.currentUserAgent != null) {
                    this.currentUserAgent.setVersion(this.currentString);
                } else if (this.currentSince != null) {
                    this.currentSince.setVersion(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case NAME: {
                if (this.currentSince != null) {
                    this.currentSince.setName(this.currentString);
                } else if (this.currentExample == null) {
                    if (this.currentEventProperty != null) {
                        if (this.isValidIdentifier(this.currentString)) {
                            this.currentEventProperty.setName(this.currentString);
                        } else {
                            this.log("Invalid event property name: " + this.currentString);
                        }
                    } else if (this.currentEvent != null) {
                        if (this.isValidEventIdentifier(this.currentString)) {
                            this.currentEvent.setName(this.currentString);
                        } else {
                            this.log("Invalid event name: " + this.currentString);
                        }
                    } else if (this.currentProperty != null) {
                        if (this.isValidIdentifier(this.currentString)) {
                            this.currentProperty.setName(this.currentString);
                        } else {
                            this.log("Invalid property name: " + this.currentString);
                        }
                    } else if (this.currentParameter != null) {
                        if (this.isValidIdentifier(this.currentString)) {
                            this.currentParameter.setName(this.currentString);
                        } else {
                            this.log("Invalid parameter name: " + this.currentString);
                        }
                    } else if (this.currentFunction != null) {
                        if (this.isValidIdentifier(this.currentString)) {
                            this.currentFunction.setName(this.currentString);
                        } else {
                            this.log("Invalid function name: " + this.currentString);
                        }
                    } else if (this.currentAlias != null) {
                        if (this.isValidIdentifier(this.currentString)) {
                            this.currentAlias.setName(this.currentString);
                        } else {
                            this.log("Invalid alias: " + this.currentString);
                        }
                    } else if (this.currentType != null) {
                        if (this.isValidTypeIdentifier(this.currentString)) {
                            this.createType();
                        } else {
                            this.log("Invalid type name: " + this.currentString);
                        }
                    } else {
                        this.log("Unable to set a name property");
                    }
                }
                this.currentString = null;
                break;
            }
            case DESCRIPTION: {
                if (this.currentUserAgent != null) {
                    this.currentUserAgent.setDescription(this.currentString);
                } else if (this.currentException != null) {
                    this.currentException.setDescription(this.currentString);
                } else if (this.currentEventProperty != null) {
                    this.currentEventProperty.setDescription(this.currentString);
                } else if (this.currentEvent != null) {
                    this.currentEvent.setDescription(this.currentString);
                } else if (this.currentProperty != null) {
                    this.currentProperty.setDescription(this.currentString);
                } else if (this.currentParameter != null) {
                    this.currentParameter.setDescription(this.currentString);
                } else if (this.currentReturnType != null) {
                    this.currentReturnType.setDescription(this.currentString);
                } else if (this.currentFunction != null) {
                    this.currentFunction.setDescription(this.currentString);
                } else if (this.currentAlias != null) {
                    this.currentAlias.setDescription(this.currentString);
                } else if (this.currentType != null) {
                    this.currentType.setDescription(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case TYPE: {
                List<String> types = this.getMappedTypes(this.currentString);
                for (String type : types) {
                    if (this.currentException != null) {
                        this.currentException.setType(type);
                    }
                    if (this.currentReturnType != null) {
                        this.currentReturnType.setType(type);
                        continue;
                    }
                    if (this.currentEventProperty != null) {
                        this.currentEventProperty.setType(type);
                        continue;
                    }
                    if (this.currentParameter != null) {
                        this.currentParameter.addType(type);
                        continue;
                    }
                    if (this.currentProperty != null) {
                        this.currentProperty.addType(type);
                        continue;
                    }
                    if (this.currentAlias == null) continue;
                    this.currentAlias.setType(type);
                }
                this.currentString = null;
                break;
            }
            case DEPRECATED: {
                if (this.currentEventProperty != null) {
                    this.currentEventProperty.setIsDeprecated(this.currentBoolean);
                } else if (this.currentEvent != null) {
                    this.currentEvent.setIsDeprecated(this.currentBoolean);
                } else if (this.currentProperty != null) {
                    this.currentProperty.setIsDeprecated(this.currentBoolean);
                } else if (this.currentFunction != null) {
                    this.currentFunction.setIsDeprecated(this.currentBoolean);
                } else if (this.currentType != null) {
                    this.currentType.setIsDeprecated(this.currentBoolean);
                }
                this.currentBoolean = null;
                break;
            }
            case INHERITS: {
                if (this.currentType != null) {
                    this.currentType.addParentType(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case PLATFORM: {
                if (this.currentUserAgent != null) {
                    this.currentUserAgent.setPlatform(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case OS: {
                if (this.currentUserAgent != null) {
                    this.currentUserAgent.setOS(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case OS_VERSION: {
                if (this.currentUserAgent != null) {
                    this.currentUserAgent.setOSVersion(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case IS_INSTANCE_PROPERTY: {
                if (this.currentProperty != null) {
                    this.currentProperty.setIsInstanceProperty(this.currentBoolean);
                } else if (this.currentFunction != null) {
                    this.currentFunction.setIsInstanceProperty(this.currentBoolean);
                }
                this.currentBoolean = null;
                break;
            }
            case IS_CLASS_PROPERTY: {
                if (this.currentProperty != null) {
                    this.currentProperty.setIsClassProperty(this.currentBoolean);
                } else if (this.currentFunction != null) {
                    this.currentFunction.setIsClassProperty(this.currentBoolean);
                }
                this.currentBoolean = null;
                break;
            }
            case IS_INTERNAL: {
                if (this.currentProperty != null) {
                    this.currentProperty.setIsInternal(this.currentBoolean);
                } else if (this.currentFunction != null) {
                    this.currentFunction.setIsInternal(this.currentBoolean);
                } else if (this.currentType != null) {
                    this.currentType.setIsInternal(this.currentBoolean);
                }
                this.currentBoolean = null;
                break;
            }
            case IS_CONSTRUCTOR: {
                if (this.currentFunction != null) {
                    this.currentFunction.setIsConstructor(this.currentBoolean);
                }
                this.currentBoolean = null;
                break;
            }
            case IS_METHOD: {
                if (this.currentFunction != null) {
                    this.currentFunction.setIsMethod(this.currentBoolean);
                }
                this.currentBoolean = null;
                break;
            }
            case CODE: {
                this.currentExample = this.currentString;
                this.currentString = null;
                break;
            }
            case USAGE: {
                if (this.currentParameter != null) {
                    this.currentParameter.setUsage(this.currentString);
                }
                this.currentString = null;
                break;
            }
            case ALIASES: 
            case TYPES: 
            case USER_AGENTS: 
            case SINCE: 
            case PROPERTIES: 
            case FUNCTIONS: 
            case EVENTS: 
            case REMARKS: 
            case EXAMPLES: 
            case PARAMETERS: 
            case REFERENCES: 
            case EXCEPTIONS: 
            case RETURN_TYPES: {
                break;
            }
            default: {
                this.log("Unrecognized property name: " + propertyName);
            }
        }
    }

    private static enum PropertyName {
        UNDEFINED(""),
        VERSION("version"),
        ALIASES("aliases"),
        TYPES("types"),
        NAME("name"),
        DESCRIPTION("description"),
        TYPE("type"),
        DEPRECATED("deprecated"),
        USER_AGENTS("userAgents"),
        SINCE("since"),
        INHERITS("inherits"),
        PROPERTIES("properties"),
        FUNCTIONS("functions"),
        EVENTS("events"),
        REMARKS("remarks"),
        PLATFORM("platform"),
        OS("os"),
        OS_VERSION("osVersion"),
        IS_INSTANCE_PROPERTY("isInstanceProperty"),
        IS_CLASS_PROPERTY("isClassProperty"),
        IS_INTERNAL("isInternal"),
        EXAMPLES("examples"),
        PARAMETERS("parameters"),
        REFERENCES("references"),
        EXCEPTIONS("exceptions"),
        RETURN_TYPES("returnTypes"),
        IS_CONSTRUCTOR("isConstructor"),
        IS_METHOD("isMethod"),
        CODE("code"),
        USAGE("usage");

        private static Map<String, PropertyName> NAME_MAP;
        private String name;

        static {
            NAME_MAP = new HashMap<String, PropertyName>();
            for (PropertyName property : EnumSet.allOf(PropertyName.class)) {
                NAME_MAP.put(property.getName(), property);
            }
        }

        public static PropertyName get(String name) {
            PropertyName result = UNDEFINED;
            if (NAME_MAP.containsKey(name)) {
                result = NAME_MAP.get(name);
            }
            return result;
        }

        private PropertyName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum TypeName {
        UNDEFINED(""),
        JSMETADATA("JSMetadata"),
        ALIAS("Alias"),
        TYPE("Type"),
        USER_AGENT("UserAgent"),
        SINCE("Since"),
        PROPERTY("Property"),
        FUNCTION("Function"),
        EVENT("Event"),
        EVENT_PROPERTY("EventProperty"),
        RETURN_TYPE("ReturnType"),
        EXAMPLE("Example"),
        PARAMETER("Parameter"),
        EXCEPTION("Exception"),
        STRING("String"),
        BOOLEAN("Boolean");

        private static Map<String, TypeName> NAME_MAP;
        private String name;

        static {
            NAME_MAP = new HashMap<String, TypeName>();
            for (TypeName type : EnumSet.allOf(TypeName.class)) {
                NAME_MAP.put(type.getName(), type);
            }
        }

        public static TypeName get(String name) {
            TypeName result = UNDEFINED;
            if (NAME_MAP.containsKey(name)) {
                result = NAME_MAP.get(name);
            }
            return result;
        }

        private TypeName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

